/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import com.agitar.common.util.IOUtility;
import com.agitar.common.util.StringUtility;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class AgitarProperties {
    private static final Properties props = (Properties)System.getProperties().clone();
    public static final String NO_TIMEOUT_PROPERTY = "NO_TIMEOUT";
    public static final String JUNIT_JAR_LOCATION_PROPERTY = "agitar.junit.jar.location";
    public static final String MOCKINGBIRD_JAR_LOCATION_PROPERTY = "mockingbird.jar.location";
    public static final String AGITATOR_CLASSPATH = "agitator.class.path";
    public static final String AGITAR_LIB_DIR = "agitator.lib.dir";
    public static final String AGITAR_NATIVE_PATH = "agitar.native.path";
    public static final String LOG_SUPPRESS_MULTIBYTES_PROPERTY = "logging.suppressMultibytes";
    public static final String DIAGNOSTIC_LOG_LEVEL = "agitar.diagnostic.log.level";
    public static final String LICENSE_CUSTOMER_ID = "license.customer.id";
    public static final String LICENSE_USER_EMAIL = "license.user.email";
    public static final String LICENSE_MACHINE_NAME = "license.machine.name";
    public static final String LICENSE_SESSION_ID = "license.session.id";
    public static final String LICENSE_SERVER_URL = "license.server.url";
    public static final String LICENSE_QUOTA_URL = "license.quota.url";
    public static final String LICENSE_ACCESS_KEY = "license.access.key";
    public static final String LICENSE_CHARGEBACK_CODE = "license.chargeback.code";
    public static final String BREAKPOINTFILE = "Agitator.BreakpointFileSet";
    public static final String LINE_SEPARATOR = AgitarProperties.get("line.separator", "\n");
    public static final String OS_NAME = AgitarProperties.get("os.name");
    private static final boolean isWindows = OS_NAME.toLowerCase().startsWith("windows");
    private static final boolean isLinux = OS_NAME.toLowerCase().startsWith("linux");
    private static final boolean isMacintosh = OS_NAME.toLowerCase().startsWith("mac os");
    private static final boolean isSolaris = OS_NAME.toLowerCase().startsWith("sun");
    public static final String USER_NAME = AgitarProperties.get("user.name");
    public static final File USER_HOME = AgitarProperties.getUserHome();
    public static final File JAVA_HOME = new File(AgitarProperties.get("java.home", ""));
    public static final String JAVA5_HOME = AgitarProperties.get("java5.home");
    public static final String JAVA_VERSION = AgitarProperties.get("java.version");
    public static final String[] CLASS_PATH = AgitarProperties.get("java.class.path", "").split(File.pathSeparator);
    public static final String[] BOOT_CLASS_PATH = AgitarProperties.get("sun.boot.class.path", "").split(File.pathSeparator);
    public static final String BOOT_CLASS_PATH_STRING = AgitarProperties.get("sun.boot.class.path");
    public static final boolean NO_TIMEOUT = AgitarProperties.isSet("NO_TIMEOUT");
    public static final boolean PROFILING = AgitarProperties.isSet("agitar.profiling");
    public static final boolean DIAG_MODE = AgitarProperties.isSet("agitar.diag");
    public static final boolean DUMP_TIMES = AgitarProperties.isSet("agitar.time") || DIAG_MODE;
    public static final int DUMP_TIMES_THRESHOLD = AgitarProperties.getInt("agitar.time", 100);
    public static final int HTTP_READ_TIMEOUT = AgitarProperties.getInt("agitar.read.timeout", 300);
    public static final String MYSTERY_TIME = AgitarProperties.get("AG_MYSTERY");
    public static final int JNDI_TIMEOUT = AgitarProperties.getInt("jndi.timeout", 10000);
    public static final boolean SEVERE_MYSTERY = AgitarProperties.isSet("AG_MYSTERY") || DIAG_MODE;
    public static final String CHECK_CSUM_STR = "CSUM";
    public static final String CSUM = AgitarProperties.get("CSUM");
    public static final String CHECK_CSUM1_STR = "CSUM1";
    public static final String CSUM1 = AgitarProperties.get("CSUM1");
    public static final String TMPDIR = AgitarProperties.get("java.io.tmpdir", "");
    public static final String[] EXT_DIRS = AgitarProperties.get("java.ext.dirs", "").split(File.pathSeparator);
    public static final String XSEED = AgitarProperties.get("xseed");
    public static final boolean PRINT_STACK_TRACE = AgitarProperties.getBoolean("printStackTrace");
    public static final boolean FACCONVERT = AgitarProperties.get("facconvert") != null && AgitarProperties.get("facconvert").equals("true");
    public static final boolean NOPERCENT = AgitarProperties.getBoolean("nopercent");
    public static final boolean EXTENDED = AgitarProperties.getBoolean("extended");
    public static final boolean OUTCOME = AgitarProperties.getBoolean("outcome");
    public static final boolean FEEDBACK = AgitarProperties.getBoolean("feedback");
    public static final boolean SHOW_STDOUT = AgitarProperties.getBoolean("stdout");
    public static final String[] DEBUG_SOLVE = AgitarProperties.get("debugSolve") != null ? AgitarProperties.get("debugSolve").split(",") : null;
    public static final int RECYCLE_THREADS = AgitarProperties.getInt("agitar.recycle.threads", 4);
    public static final int RECYCLE_MEMORY = AgitarProperties.getInt("agitar.recycle.memory", 33);
    public static final boolean TBS_MODE = AgitarProperties.getBoolean("AgTBSMode");
    public static final boolean TBS_DEBUG_MODE = !StringUtility.nullOrEmpty(AgitarProperties.get("TBSDebug"));
    public static final boolean NO_SERIAL = AgitarProperties.getBoolean("agitar.noserial");
    public static final boolean TRACE_PARTING = AgitarProperties.getBoolean("agitar.tp");
    public static final boolean LOG_INSTRUMENTATION = AgitarProperties.getBoolean("agitar.loginstr");
    public static final boolean LOG_UNLIMITED_FILE = AgitarProperties.getBoolean("logging.unlimited");
    public static final boolean LOG_SUPPRESS_MULTIBYTES = AgitarProperties.getBoolean("logging.suppressMultibytes");
    public static final String XML_CONSOLE_LOG = AgitarProperties.get("logging.xmlConsole");
    public static final int GUI_XMLRPC_PORT = AgitarProperties.getInt("agitar.xmlrpc.port", -1);
    public static final boolean NO_FONT_SUBSTITUTION = AgitarProperties.getBoolean("agitar.no.font.substitutions");
    public static final String DIRMAPSDIR_PROPERTY = "agitar.dirmaps";
    public static final boolean TELEMETRY = !AgitarProperties.isSet("agitar.telemetry") || AgitarProperties.getBoolean("agitar.telemetry");
    public static final boolean NO_DOUBLE_DIP = AgitarProperties.getBoolean("agitar.no.double.dip") || AgitarProperties.getBoolean("agitar.o.double.dip");
    public static final String MOCKITATOR_MODE = System.getProperty("mockitator", "on").toLowerCase();
    public static final boolean NEW_OBSESRVATION_SYSTEM = true;
    public static final boolean NOPROJECTLOCK = AgitarProperties.getBoolean("noprojectlock");
    public static final boolean ALL_MOCKINGBIRD = AgitarProperties.get("agitar.allbird") != null;
    public static final boolean LOCKDOWN = AgitarProperties.getBoolean("lockdown");
    public static final boolean JUNITFACTORY_RESEARCH = AgitarProperties.getBoolean("junit.factory.research");
    public static final String EXPERTS_PATH = AgitarProperties.get("expertspath");
    public static final String PATH_SEPARATOR = AgitarProperties.get("path.separator");
    public static final String AGITAR_SERVER_MODE = "agitar.server.mode";
    public static final String LOGGING_MANAGER = AgitarProperties.get("java.util.logging.manager");
    public static final boolean SERVER_MODE = System.getProperty("agitar.server.mode") != null;
    public static final String ECLIPSE_VERIFIER_MARKER_PROPERTY = "-DAGITAR_VERIFIER";
    public static final String SUPERRUNNER_SUBPROCESS_MARKER_PROPERTY = "-DAGITAR_SUPERRUN_SUB";
    public static final String SUPER_RUNNER_HARNESS_MARKER_PROPERTY = "-DAGITAR_SYSTEM_TEST_SUPERRUN";
    public static final String WASHER_MARKER_PROPERTY = "-D_WASHER";
    public static final boolean LICENSE_SKIP_CHECK = AgitarProperties.isSet("ils.mode.off");
    public static final String DISABLE_INSTRUMENTER_CHECK = "disableInstrumenterCheck";
    public static final boolean DISABLE_INSTRUMENTATER_CHECK = AgitarProperties.isSet("disableInstrumenterCheck");
    public static final boolean BREAKPOINTFILE_IS_SET = AgitarProperties.isSet("Agitator.BreakpointFileSet");
    public static final boolean LOCALGEN = AgitarProperties.isSet("localgen");
    public static final String TEST_GEN_SOURCE_FOLDER = "agitar.test.gen.source.folder";
    public static final String TEST_GEN_SOURCE_FOLDER_VALUE = AgitarProperties.get("agitar.test.gen.source.folder");
    public static final String MOCKITATOR = "mockitator";
    public static final String MOCKITATOR_CLASSPATH = "mockitator.classpath";
    public static boolean AGGRESSIVE_MOCKS_OFF = AgitarProperties.isSet("aggressive.mocks.off");

    public static String get(String key) {
        return props.getProperty(key);
    }

    public static String get(String key, String defaultValue) {
        return props.getProperty(key, defaultValue);
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static boolean isMacintosh() {
        return isMacintosh;
    }

    public static boolean isSet(String key) {
        return props.getProperty(key) != null;
    }

    public static boolean getBoolean(String key) {
        String value = props.getProperty(key, "false");
        return value.equals("true") || value.equals("") || value.equals("1") || value.equals("on");
    }

    public static int getInt(String key, int defaultValue) {
        String value = props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception x) {
            return defaultValue;
        }
    }

    public static boolean javaVersion(int major, int minor, int micro) {
        int sysMicro;
        StringTokenizer tok = new StringTokenizer(JAVA_VERSION, ".-_");
        int sysMajor = Integer.parseInt(tok.nextToken());
        int sysMinor = Integer.parseInt(tok.nextToken());
        int n = sysMicro = tok.hasMoreTokens() ? Integer.parseInt(tok.nextToken()) : 0;
        if (sysMajor > major) {
            return true;
        }
        if (sysMajor < major) {
            return false;
        }
        if (sysMinor > minor) {
            return true;
        }
        if (sysMinor < minor) {
            return false;
        }
        return sysMicro >= micro;
    }

    public static Iterator keyIterator() {
        return props.keySet().iterator();
    }

    public static void restore() {
        System.setProperties((Properties)props.clone());
    }

    public static void setUserProperty(String key, String val) {
        props.setProperty(key, val);
        AgitarProperties.restore();
    }

    public static boolean isDebugSolveOn() {
        return DEBUG_SOLVE != null && DEBUG_SOLVE.length > 0 && DEBUG_SOLVE[0].indexOf(46) != -1;
    }

    private static File getUserHome() {
        String userHome = AgitarProperties.get("agitar.user.home");
        if (userHome == null) {
            userHome = AgitarProperties.get("user.home", "");
        }
        return new File(userHome);
    }

    public static boolean isSolaris() {
        return isSolaris;
    }

    public static boolean isLinux() {
        return isLinux;
    }

    public static String locateJava() {
        return AgitarProperties.locateJava(JAVA_HOME);
    }

    public static String locateJava(File javaHome) {
        String result = AgitarProperties.locateJavaFile(javaHome).toString();
        if (result.indexOf(32) >= 0) {
            result = '\"' + result + '\"';
        }
        return result;
    }

    public static File locateJavaFile(File javaHome) {
        String result = "java";
        String executable = AgitarProperties.isWindows() ? "java.exe" : "java";
        String sep = File.separator;
        File java = new File(javaHome + sep + "bin" + sep + executable);
        if (java.exists() && java.isFile()) {
            result = IOUtility.getCanonicalPath(java);
        } else {
            java = new File(javaHome + sep + ".." + sep + "bin" + sep + executable);
            if (java.exists() && java.isFile()) {
                result = IOUtility.getCanonicalPath(java);
            }
        }
        return new File(result);
    }

    public static List propsAsDashDs() {
        ArrayList<String> dashDs = new ArrayList<String>();
        Iterator<Map.Entry<Object, Object>> e = props.entrySet().iterator();
        while (e.hasNext()) {
            Map.Entry<Object, Object> element = e.next();
            dashDs.add("-D" + element.getKey() + "=" + element.getValue());
        }
        return dashDs;
    }
}

