/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class AgXPathAPI {
    private static Object xpathCall(String methodName, Node node, String str) throws TransformerException {
        try {
            Class<?> xpathClass;
            try {
                xpathClass = Class.forName("org.apache.xpath.XPathAPI");
            }
            catch (ClassNotFoundException e) {
                xpathClass = Class.forName("com.sun.org.apache.xpath.internal.XPathAPI");
            }
            Method m = xpathClass.getDeclaredMethod(methodName, Node.class, String.class);
            return m.invoke(null, node, str);
        }
        catch (Exception ex) {
            AgXPathAPI.processException(ex);
            return null;
        }
    }

    private static void processException(Exception ex) throws TransformerException {
        if (!(ex instanceof InvocationTargetException)) {
            throw new InvocationException(ex);
        }
        if (ex.getCause() instanceof TransformerException) {
            throw (TransformerException)ex.getCause();
        }
        if (ex.getCause() instanceof RuntimeException) {
            throw (RuntimeException)ex.getCause();
        }
        throw new InvocationException(ex);
    }

    public static NodeList selectNodeList(Node contextNode, String str) throws TransformerException {
        return (NodeList)AgXPathAPI.xpathCall("selectNodeList", contextNode, str);
    }

    public static Node selectSingleNode(Node contextNode, String str) throws TransformerException {
        return (Node)AgXPathAPI.xpathCall("selectSingleNode", contextNode, str);
    }

    public static Object eval(Node contextNode, String str) throws TransformerException {
        return AgXPathAPI.xpathCall("eval", contextNode, str);
    }

    public static NodeIterator selectNodeIterator(Node contextNode, String str) throws TransformerException {
        return (NodeIterator)AgXPathAPI.xpathCall("selectNodeIterator", contextNode, str);
    }

    public static double getXPathCount(Node contextNode, String str) throws TransformerException {
        Object o = AgXPathAPI.eval(contextNode, str);
        try {
            Method m = o.getClass().getDeclaredMethod("num", new Class[0]);
            Double result = (Double)m.invoke(o, new Object[0]);
            return result;
        }
        catch (Exception ex) {
            AgXPathAPI.processException(ex);
            return Double.NaN;
        }
    }

    public static class InvocationException
    extends RuntimeException {
        public InvocationException(Throwable cause) {
            super(cause);
        }
    }
}

