/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.types;

import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TypeName {
    public static final String DEFAULT_PACKAGE = "";
    public static final String CLASS_EXTENSION = ".class";
    public static final String SOURCE_EXTENSION = ".java";
    public static final int PACKAGE = 1;
    public static final int CONTAINER = 2;
    public static final int ARRAY = 4;
    public static final int GENERICS = 8;
    public static final int FULL = 15;
    public static final int WO_PACKAGE = 14;
    public static final int SIMPLE = 12;
    public static final int ERASED = 7;
    public static final int SIMPLE_ERASED = 4;
    public static final int BASE = 3;
    private static final Set PRIMITIVES;
    private static final Map cache;
    public static final TypeName OBJECT;
    public static final TypeName STRING;
    public static final TypeName EXCEPTION;
    public static final TypeName THROWABLE;
    public static final TypeName VOID;
    private final String packageName;
    private final String simpleClassName;
    private final String fullClassName;
    private final String simpleTypeName;
    private final String fullTypeName;
    private final Wildcard[] genericParameters;
    private final String bytecodeName;
    private final boolean primitive;
    private final int arrayDepth;
    private final TypeName containingClass;
    public static Comparator COMPARE_BY_NAME_WO_PACKAGE;
    public static Comparator COMPARE_BY_SIMPLE_NAME;
    public static Comparator COMPARE_BY_NAME;
    static final /* synthetic */ boolean $assertionsDisabled;

    private TypeName(String name) {
        name = TypeName.normalizeAndValidate(name);
        int arrayDepth = 0;
        for (int end = name.length(); end > 2 && name.charAt(end - 1) == ']' && name.charAt(end - 2) == '['; end -= 2) {
            ++arrayDepth;
        }
        this.arrayDepth = arrayDepth;
        this.fullClassName = TypeName.erase(name).trim();
        int dot = this.fullClassName.lastIndexOf(46);
        this.packageName = dot < 0 ? DEFAULT_PACKAGE : this.fullClassName.substring(0, dot);
        String base = this.fullClassName.substring(dot + 1);
        this.simpleClassName = base.substring(TypeName.findInnerDivider(base) + 1);
        boolean bl = this.primitive = Character.isLowerCase(this.fullClassName.charAt(0)) && PRIMITIVES.contains(this.fullClassName);
        this.bytecodeName = this.isArray() ? "[" + this.getComponentType().getBytecodeName() : (this.primitive ? String.valueOf(TypeName.primByteCode(this.fullClassName)) : 'L' + this.fullClassName.replace('.', '/') + ';');
        if (name.indexOf(60) >= 0) {
            this.fullTypeName = name;
            StringBuffer buffer = new StringBuffer(this.getName(2));
            String genericForm = TypeName.findInnerClass(name);
            this.containingClass = genericForm.equals(name) ? null : TypeName.get(name.substring(0, name.length() - genericForm.length() - 1));
            this.genericParameters = TypeName.findTypeParameters(genericForm, buffer, arrayDepth);
            this.simpleTypeName = buffer.toString();
        } else {
            this.fullTypeName = this.fullClassName;
            this.simpleTypeName = this.simpleClassName;
            this.genericParameters = new Wildcard[0];
            int div = TypeName.findInnerDivider(this.fullClassName);
            this.containingClass = div <= this.fullClassName.lastIndexOf(46) + 1 ? null : TypeName.get(this.fullClassName.substring(0, div));
        }
    }

    private static Wildcard[] findTypeParameters(String genericForm, StringBuffer buffer, int arrayDepth) {
        int i;
        buffer.append('<');
        String parameters = genericForm.substring(genericForm.indexOf(60) + 1, genericForm.lastIndexOf(62));
        String[] types = TypeName.splitParams(parameters);
        Wildcard[] genericParameters = new Wildcard[types.length];
        for (i = 0; i < types.length; ++i) {
            if (i > 0) {
                buffer.append(',');
            }
            genericParameters[i] = new Wildcard(types[i]);
            buffer.append(genericParameters[i].getName(12));
        }
        buffer.append('>');
        for (i = 0; i < arrayDepth; ++i) {
            buffer.append("[]");
        }
        return genericParameters;
    }

    private static String normalizeAndValidate(String className) {
        if (className == null) {
            throw new IllegalArgumentException("Class name is null");
        }
        if (className.indexOf(32) >= 0) {
            StringBuffer buf = new StringBuffer(className.length());
            char[] chars = className.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (c == '$' && i > 0 && chars[i - 1] == '$' || c == ' ' && (i == 0 || i + 1 == chars.length || chars[i - 1] == ' ' || chars[i - 1] == ',' || chars[i + 1] == ',')) continue;
                buf.append(c);
            }
            className = buf.toString();
        }
        if (className.endsWith("...")) {
            className = className.substring(0, className.length() - 3) + "[]";
        }
        if (className.length() == 0 || className.charAt(0) == '<' || className.endsWith(".") || className.indexOf(0) >= 0) {
            throw new IllegalArgumentException("Class name is not valid [" + className + "]");
        }
        return className;
    }

    private static String erase(String name) {
        int lt = name.indexOf(60);
        if (lt < 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        int level = 0;
        StringBuffer buf = new StringBuffer();
        block4: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '<': {
                    ++level;
                    continue block4;
                }
                case '>': {
                    --level;
                    continue block4;
                }
                default: {
                    if (level != 0) continue block4;
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeName get(String className) {
        TypeName tn;
        Map map = cache;
        synchronized (map) {
            tn = (TypeName)cache.get(className);
            if (tn == null) {
                tn = new TypeName(className);
                cache.put(className, tn);
            }
        }
        return tn;
    }

    public static TypeName get(Class cls) {
        if (cls.isArray()) {
            int arrayDepth = 0;
            while (cls.isArray()) {
                ++arrayDepth;
                cls = cls.getComponentType();
            }
            StringBuffer buf = new StringBuffer(cls.getName());
            for (int i = 0; i < arrayDepth; ++i) {
                buf.append("[]");
            }
            return TypeName.get(buf.toString());
        }
        return TypeName.get(cls.getName());
    }

    public static TypeName fromBytecode(String bytecodeName) {
        int arrayCount = 0;
        while (bytecodeName.startsWith("[")) {
            ++arrayCount;
            bytecodeName = bytecodeName.substring(1);
        }
        if (bytecodeName.length() == 0) {
            throw new IllegalArgumentException(bytecodeName);
        }
        StringBuffer result = new StringBuffer(bytecodeName.length() + 10);
        switch (bytecodeName.charAt(0)) {
            case 'B': {
                result.append("byte");
                break;
            }
            case 'C': {
                result.append("char");
                break;
            }
            case 'D': {
                result.append("double");
                break;
            }
            case 'F': {
                result.append("float");
                break;
            }
            case 'I': {
                result.append("int");
                break;
            }
            case 'J': {
                result.append("long");
                break;
            }
            case 'S': {
                result.append("short");
                break;
            }
            case 'V': {
                result.append("void");
                break;
            }
            case 'Z': {
                result.append("boolean");
                break;
            }
            case 'L': 
            case 'Q': {
                result.append(bytecodeName.substring(1, bytecodeName.length() - 1).replace('/', '.'));
                break;
            }
            default: {
                throw new IllegalArgumentException(bytecodeName);
            }
        }
        for (int i = 0; i < arrayCount; ++i) {
            result.append('[').append(']');
        }
        return TypeName.get(result.toString());
    }

    public boolean isValid() {
        char[] cn = this.fullClassName.toCharArray();
        if (!Character.isJavaIdentifierStart(cn[0])) {
            return false;
        }
        for (int i = 1; i < cn.length; ++i) {
            if (Character.isJavaIdentifierPart(cn[i]) || cn[i] == '.' && cn[i - 1] != '.') continue;
            return false;
        }
        return true;
    }

    public boolean isArray() {
        return this.arrayDepth > 0;
    }

    public int getArrayDims() {
        return this.arrayDepth;
    }

    public TypeName getComponentType() {
        return this.arrayDepth <= 0 ? null : TypeName.get(this.fullClassName.substring(0, this.fullClassName.length() - 2));
    }

    public TypeName getBaseType() {
        return !this.isArray() && !this.isGeneric() ? this : TypeName.get(this.fullClassName.substring(0, this.fullClassName.length() - 2 * this.arrayDepth));
    }

    public boolean isInnerClass() {
        return this.containingClass != null;
    }

    public boolean isAnonymous() {
        boolean anon = this.simpleClassName.length() == 0 || Character.isDigit(this.simpleClassName.charAt(0));
        TypeName parent = this.getContainingClass();
        return anon || parent != null && parent.isAnonymous();
    }

    public TypeName getContainingClass() {
        return this.containingClass;
    }

    private static int findInnerDivider(String s) {
        return s.lastIndexOf(36);
    }

    public TypeName getOutermostClass() {
        TypeName tn;
        for (tn = this; tn != null && tn.isInnerClass(); tn = tn.getContainingClass()) {
        }
        return tn;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getName(int style) {
        int i;
        switch (style) {
            case 15: {
                return this.fullTypeName;
            }
            case 7: {
                return this.fullClassName;
            }
            case 12: {
                return this.simpleTypeName;
            }
            case 4: {
                return this.simpleClassName;
            }
        }
        StringBuffer buf = new StringBuffer(this.fullTypeName.length());
        if ((style & 2) != 0 && this.containingClass != null) {
            buf.append(this.containingClass.getName(style)).append('$');
        } else if ((style & 1) != 0 && this.packageName != DEFAULT_PACKAGE) {
            buf.append(this.packageName).append('.');
        }
        if (this.isArray()) {
            buf.append(this.simpleClassName.substring(0, this.simpleClassName.length() - this.arrayDepth * 2));
        } else {
            buf.append(this.simpleClassName);
        }
        if ((style & 8) != 0 && this.genericParameters.length > 0) {
            buf.append('<').append(this.genericParameters[0].getName(style));
            for (i = 1; i < this.genericParameters.length; ++i) {
                buf.append(',').append(this.genericParameters[i].getName(style));
            }
            buf.append('>');
        }
        if ((style & 4) != 0) {
            for (i = 0; i < this.arrayDepth; ++i) {
                buf.append("[]");
            }
        }
        return buf.toString();
    }

    public String getBytecodeName() {
        return this.bytecodeName;
    }

    private static char primByteCode(String primName) {
        switch (primName.charAt(0)) {
            case 'i': {
                return 'I';
            }
            case 'b': {
                return primName.charAt(1) == 'o' ? (char)'Z' : 'B';
            }
            case 'v': {
                return 'V';
            }
            case 'c': {
                return 'C';
            }
            case 'l': {
                return 'J';
            }
            case 's': {
                return 'S';
            }
            case 'd': {
                return 'D';
            }
            case 'f': {
                return 'F';
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)primName);
        }
        return 'V';
    }

    public String getClassFileName() {
        return this.getName(3).replace('.', '/') + CLASS_EXTENSION;
    }

    public String getSourceFileName() {
        return this.getSourceFileName(null);
    }

    public String getSourceFileName(String sourceFileAttribute) {
        if (sourceFileAttribute == null) {
            TypeName tn = this;
            while (tn.isInnerClass()) {
                tn = tn.getContainingClass();
            }
            return tn.getName(3).replace('.', '/') + SOURCE_EXTENSION;
        }
        String baseName = new File(sourceFileAttribute).getName();
        return this.packageName.length() > 0 ? this.packageName.replace('.', '/') + '/' + baseName : baseName;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isInstance(Object o) throws ClassNotFoundException {
        if (this.primitive) {
            switch (TypeName.primByteCode(this.fullClassName)) {
                case 'I': {
                    return o instanceof Integer;
                }
                case 'B': {
                    return o instanceof Byte;
                }
                case 'Z': {
                    return o instanceof Boolean;
                }
                case 'V': {
                    return o instanceof Void;
                }
                case 'C': {
                    return o instanceof Character;
                }
                case 'J': {
                    return o instanceof Long;
                }
                case 'S': {
                    return o instanceof Short;
                }
                case 'D': {
                    return o instanceof Double;
                }
                case 'F': {
                    return o instanceof Float;
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return false;
        }
        return this.toClass().isAssignableFrom(o.getClass());
    }

    public String toString() {
        return this.fullTypeName;
    }

    public Class toClass() throws ClassNotFoundException {
        if (this.isPrimitive()) {
            switch (TypeName.primByteCode(this.fullClassName)) {
                case 'I': {
                    return Integer.TYPE;
                }
                case 'B': {
                    return Byte.TYPE;
                }
                case 'Z': {
                    return Boolean.TYPE;
                }
                case 'V': {
                    return Void.TYPE;
                }
                case 'C': {
                    return Character.TYPE;
                }
                case 'J': {
                    return Long.TYPE;
                }
                case 'S': {
                    return Short.TYPE;
                }
                case 'D': {
                    return Double.TYPE;
                }
                case 'F': {
                    return Float.TYPE;
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return Void.TYPE;
        }
        if (this.isArray()) {
            return Array.newInstance(this.getComponentType().toClass(), 0).getClass();
        }
        return Class.forName(this.fullClassName, true, Thread.currentThread().getContextClassLoader());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TypeName) {
            TypeName tn = (TypeName)o;
            return this.fullClassName.equals(tn.fullClassName);
        }
        return false;
    }

    public boolean fuzzyMatch(TypeName tn) {
        if (DEFAULT_PACKAGE.equals(this.packageName) || DEFAULT_PACKAGE.equals(tn.packageName)) {
            return this.simpleClassName.equals(tn.simpleClassName);
        }
        return this.fullClassName.equals(tn.fullClassName);
    }

    public int hashCode() {
        return this.fullTypeName.hashCode();
    }

    public boolean isSameType(TypeName that) {
        return this.fullTypeName.equals(that.fullTypeName);
    }

    public boolean isUnboundGeneric() {
        if (this.isGeneric()) {
            Wildcard[] parameters = this.getParameters();
            if (this.fullTypeName.indexOf(46) < 0) {
                return true;
            }
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i].getConstraintType() != 0 || parameters[i].getConstraint().getPackageName() != DEFAULT_PACKAGE) continue;
                return true;
            }
        }
        return false;
    }

    public int compareTo(Object other) {
        return COMPARE_BY_NAME.compare(this, other);
    }

    private static int compareNames(String n1, String n2) {
        int div2;
        int div1 = TypeName.findInnerDivider(n1);
        if (div1 == (div2 = TypeName.findInnerDivider(n2)) && div1 > -1 && n1.substring(0, div1).equals(n2.substring(0, div2)) && Character.isDigit(n1.charAt(n1.length() - 1)) && Character.isDigit(n2.charAt(n2.length() - 1))) {
            String num1 = n1.substring(div1 + 1);
            String num2 = n2.substring(div1 + 1);
            try {
                return Integer.parseInt(num1) - Integer.parseInt(num2);
            }
            catch (NumberFormatException x) {
                return n1.compareTo(n2);
            }
        }
        return n1.compareTo(n2);
    }

    private static String findInnerClass(String fullName) {
        int nested = 0;
        block5: for (int i = fullName.length() - 1; i >= 0; --i) {
            switch (fullName.charAt(i)) {
                case '<': {
                    ++nested;
                    continue block5;
                }
                case '>': {
                    --nested;
                    continue block5;
                }
                case '$': {
                    if (nested != 0) continue block5;
                    return fullName.substring(i + 1);
                }
            }
        }
        return fullName;
    }

    private static String[] splitParams(String paramBlock) {
        ArrayList<String> params = new ArrayList<String>();
        int nested = 0;
        int start = 0;
        block5: for (int i = 0; i < paramBlock.length(); ++i) {
            switch (paramBlock.charAt(i)) {
                case '<': {
                    ++nested;
                    continue block5;
                }
                case '>': {
                    --nested;
                    continue block5;
                }
                case ',': {
                    if (nested != 0) continue block5;
                    params.add(paramBlock.substring(start, i));
                    start = i + 1;
                }
            }
        }
        if (paramBlock.length() > start) {
            params.add(paramBlock.substring(start));
        }
        return params.toArray(new String[params.size()]);
    }

    public Wildcard[] getParameters() {
        return this.genericParameters;
    }

    public boolean isGeneric() {
        return this.genericParameters.length > 0;
    }

    static {
        $assertionsDisabled = !TypeName.class.desiredAssertionStatus();
        PRIMITIVES = new HashSet<String>(Arrays.asList("int", "long", "short", "byte", "boolean", "float", "double", "char", "void"));
        cache = new HashMap(503);
        OBJECT = TypeName.get("java.lang.Object");
        STRING = TypeName.get("java.lang.String");
        EXCEPTION = TypeName.get("java.lang.Exception");
        THROWABLE = TypeName.get("java.lang.Throwable");
        VOID = TypeName.get("void");
        COMPARE_BY_NAME_WO_PACKAGE = new Comparator(){

            public int compare(Object o1, Object o2) {
                TypeName tn1 = (TypeName)o1;
                TypeName tn2 = (TypeName)o2;
                String n1 = tn1.getName(14);
                String n2 = tn2.getName(14);
                return TypeName.compareNames(n1, n2);
            }
        };
        COMPARE_BY_SIMPLE_NAME = new Comparator(){

            public int compare(Object o1, Object o2) {
                TypeName tn1 = (TypeName)o1;
                TypeName tn2 = (TypeName)o2;
                String n1 = tn1.getName(12);
                String n2 = tn2.getName(12);
                return TypeName.compareNames(n1, n2);
            }
        };
        COMPARE_BY_NAME = new Comparator(){

            public int compare(Object o1, Object o2) {
                TypeName tn1 = (TypeName)o1;
                TypeName tn2 = (TypeName)o2;
                String n1 = tn1.getName(15);
                String n2 = tn2.getName(15);
                return TypeName.compareNames(n1, n2);
            }
        };
    }

    public static class Wildcard {
        public static final int CONSTRAINT_EQUALS = 0;
        public static final int CONSTRAINT_EXTENDS = 1;
        public static final int CONSTRAINT_SUPER = 2;
        private final String var;
        private final TypeName constraint;
        private final int constraintType;

        public Wildcard(String name) {
            if (name.indexOf(" super ") > 0) {
                int index = name.indexOf(" super ");
                this.constraintType = 2;
                this.constraint = TypeName.get(name.substring(index + 7));
                this.var = name.substring(0, index);
            } else if (name.indexOf(" extends ") > 0) {
                int index = name.indexOf(" extends ");
                this.constraintType = 1;
                this.constraint = TypeName.get(name.substring(index + 9));
                this.var = name.substring(0, index);
            } else {
                this.constraintType = 0;
                this.constraint = TypeName.get(name);
                this.var = null;
            }
        }

        public String getVar() {
            return this.var;
        }

        public TypeName getConstraint() {
            return this.constraint;
        }

        public int getConstraintType() {
            return this.constraintType;
        }

        public String getName(int style) {
            switch (this.constraintType) {
                case 0: {
                    return this.constraint.getName(style);
                }
                case 1: {
                    return this.var + " extends " + this.constraint.getName(style);
                }
                case 2: {
                    return this.var + " super " + this.constraint.getName(style);
                }
            }
            throw new IllegalStateException();
        }

        public String toString() {
            return this.getName(15);
        }
    }
}

