/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.types;

import com.agitar.InternalException;
import com.agitar.common.types.ClassName;
import com.agitar.common.types.ClassName5;
import com.agitar.common.util.Assertions;
import com.agitar.common.util.StringUtility;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;

public class MethodSignature {
    private final ClassName className;
    private final String name;
    private final ClassName[] paramTypes;
    private final String[] paramNames;
    private ClassName returnType;
    private final String longForm;
    private final String shortForm;
    private final String compareForm;
    public static final Comparator COMPARE_BY_SHORT_FORM = new Comparator(){

        public int compare(Object o1, Object o2) {
            MethodSignature ms1 = (MethodSignature)o1;
            MethodSignature ms2 = (MethodSignature)o2;
            return ms1.getShortForm().compareTo(ms2.getShortForm());
        }
    };
    public static final Comparator COMPARE_BY_LONG_FORM = new Comparator(){

        public int compare(Object o1, Object o2) {
            MethodSignature ms1 = (MethodSignature)o1;
            MethodSignature ms2 = (MethodSignature)o2;
            return ms1.getLongForm().compareTo(ms2.getLongForm());
        }
    };

    protected MethodSignature(MethodSignature signature) {
        this.className = signature.className;
        this.name = signature.name;
        this.returnType = signature.returnType;
        this.paramTypes = signature.paramTypes;
        this.paramNames = signature.paramNames;
        this.shortForm = signature.shortForm;
        this.longForm = signature.longForm;
        this.compareForm = signature.compareForm;
    }

    public MethodSignature(String longForm) {
        int space = longForm.indexOf(32);
        int paren = longForm.indexOf(40);
        if (paren < 0 || !longForm.endsWith(")")) {
            throw new IllegalArgumentException("Missing paren: " + longForm);
        }
        String paramBlock = longForm.substring(paren + 1, longForm.length() - 1);
        String[] params = this.splitParams(paramBlock);
        this.paramTypes = new ClassName[params.length];
        this.paramNames = new String[params.length];
        this.storeParams(params);
        int dot = longForm.lastIndexOf(46, paren);
        if (space >= 0 && space < dot) {
            this.returnType = ClassName.get(longForm.substring(0, space));
            this.className = ClassName.get(longForm.substring(space + 1, dot));
            longForm = longForm.substring(space + 1);
            paren = paren - space - 1;
            dot = longForm.lastIndexOf(46, paren);
        } else {
            if (dot < 0) {
                throw new IllegalArgumentException("No class name: " + longForm);
            }
            this.returnType = null;
            this.className = ClassName.get(longForm.substring(0, dot));
        }
        StringBuffer longBuf = new StringBuffer();
        StringBuffer compareBuf = new StringBuffer();
        this.buildLongAndCompareForms(longForm, paren, longBuf, compareBuf);
        this.longForm = longBuf.toString();
        this.shortForm = this.longForm.substring(dot + 1);
        this.compareForm = compareBuf.toString();
        this.name = this.shortForm.substring(0, this.shortForm.indexOf(40));
    }

    public MethodSignature(ClassName className, String signature, ClassName returnType) {
        int paren = signature.indexOf(40);
        if (className == null) {
            throw new IllegalArgumentException("null className");
        }
        if (paren < 0 || !signature.endsWith(")")) {
            throw new IllegalArgumentException("Missing paren: " + signature);
        }
        String paramBlock = signature.substring(paren + 1, signature.length() - 1);
        String[] params = this.splitParams(paramBlock);
        this.paramTypes = new ClassName[params.length];
        this.paramNames = new String[params.length];
        this.storeParams(params);
        int space = signature.lastIndexOf(32, paren);
        if (space >= 0 && returnType == null) {
            returnType = ClassName.get(signature.substring(0, space));
            signature = signature.substring(space + 1);
            paren = signature.indexOf(40);
        } else if (space >= 0) {
            throw new IllegalArgumentException("Conflicting returns: " + returnType + ' ' + signature);
        }
        this.className = className;
        this.returnType = returnType;
        StringBuffer longBuf = new StringBuffer();
        StringBuffer compareBuf = new StringBuffer();
        this.buildLongAndCompareForms(className, signature, paren, longBuf, compareBuf);
        this.longForm = longBuf.toString();
        this.shortForm = this.longForm.substring(className.getName().length() + 1);
        this.compareForm = compareBuf.toString();
        this.name = this.shortForm.substring(0, this.shortForm.indexOf(40));
    }

    public MethodSignature(ClassName className, String signature) {
        this(className, signature, (ClassName)null);
    }

    public MethodSignature(ClassName className, String erasureForm, String genericForm) {
        this(className, erasureForm);
        if (!erasureForm.equals(genericForm)) {
            String genericReturnType;
            String erasureReturnType;
            MethodSignature generic = new MethodSignature(className, genericForm);
            if (generic.getParamTypes().length != this.getParamTypes().length) {
                throw new InternalException("Parameters in generic form do not match erasure form");
            }
            for (int i = 0; i < this.paramTypes.length; ++i) {
                String genericParam;
                String erasureParam = this.paramTypes[i].getName();
                if (erasureParam.equals(genericParam = generic.getParamTypes()[i].getFullTypeName())) continue;
                this.paramTypes[i] = new ClassName5(erasureParam, genericParam);
            }
            if (this.returnType != null && !(erasureReturnType = this.returnType.getName()).equals(genericReturnType = generic.getReturnType().getFullTypeName())) {
                this.returnType = new ClassName5(erasureReturnType, genericReturnType);
            }
        }
    }

    public MethodSignature(ClassName className, String name, ClassName[] paramTypes, ClassName returnType) {
        Assertions.assertNotNull("class name is null", className);
        Assertions.assertNotNull("method name is null", name);
        Assertions.assertNotNull("no parameter types", paramTypes);
        this.className = className;
        this.name = name;
        this.paramTypes = paramTypes;
        this.returnType = returnType;
        StringBuffer longBuf = new StringBuffer();
        StringBuffer compareBuf = new StringBuffer();
        longBuf.append(className.getName()).append('.').append(name).append('(');
        compareBuf.append(className.getName()).append('.').append(name).append('(');
        this.paramNames = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            this.paramNames[i] = "param" + (i + 1);
            Assertions.assertNotNull("null parameter type", paramTypes[i]);
            if (i > 0) {
                longBuf.append(',').append(' ');
                compareBuf.append(',');
            }
            longBuf.append(paramTypes[i]).append(' ').append(this.paramNames[i]);
            compareBuf.append(paramTypes[i]);
        }
        longBuf.append(')');
        compareBuf.append(')');
        this.longForm = longBuf.toString();
        this.shortForm = this.longForm.substring(className.getName().length() + 1);
        this.compareForm = compareBuf.toString();
    }

    public MethodSignature(ClassName className, String name, ClassName[] paramTypes, String[] paramNames, ClassName returnType) {
        Assertions.assertNotNull("class name is null", className);
        Assertions.assertNotNull("method name is null", name);
        Assertions.assertNotNull("no parameter types", paramTypes);
        Assertions.assertNotNull("no parameter names", paramNames);
        Assertions.assertEquals("paramTypes.length != paramNames.length", paramTypes.length, paramNames.length);
        this.className = className;
        this.name = name;
        this.paramTypes = paramTypes;
        this.paramNames = paramNames;
        this.returnType = returnType;
        StringBuffer longBuf = new StringBuffer();
        StringBuffer compareBuf = new StringBuffer();
        longBuf.append(className.getName()).append('.').append(name).append('(');
        compareBuf.append(className.getName()).append('.').append(name).append('(');
        for (int i = 0; i < paramNames.length; ++i) {
            Assertions.assertNotNull("null parameter name", paramNames[i]);
            Assertions.assertNotNull("null parameter type", paramTypes[i]);
            if (i > 0) {
                longBuf.append(',').append(' ');
                compareBuf.append(',');
            }
            longBuf.append(paramTypes[i]).append(' ').append(paramNames[i]);
            compareBuf.append(paramTypes[i]);
        }
        longBuf.append(')');
        compareBuf.append(')');
        this.longForm = longBuf.toString();
        this.shortForm = this.longForm.substring(className.getName().length() + 1);
        this.compareForm = compareBuf.toString();
    }

    private void buildLongAndCompareForms(String longForm, int paren, StringBuffer longBuf, StringBuffer compareBuf) {
        longBuf.append(longForm.substring(0, paren)).append('(');
        compareBuf.append(longForm.substring(0, paren)).append('(');
        for (int i = 0; i < this.paramNames.length; ++i) {
            if (i > 0) {
                longBuf.append(',').append(' ');
                compareBuf.append(',');
            }
            longBuf.append(this.paramTypes[i]).append(' ').append(this.paramNames[i]);
            compareBuf.append(this.paramTypes[i]);
        }
        longBuf.append(')');
        compareBuf.append(')');
    }

    private String[] splitParams(String paramBlock) {
        paramBlock = paramBlock.trim();
        ArrayList<String> params = new ArrayList<String>();
        int nested = 0;
        int start = 0;
        block5: for (int i = 0; i < paramBlock.length(); ++i) {
            switch (paramBlock.charAt(i)) {
                case '<': {
                    ++nested;
                    continue block5;
                }
                case '>': {
                    --nested;
                    continue block5;
                }
                case ',': {
                    if (nested != 0) continue block5;
                    params.add(paramBlock.substring(start, i).trim());
                    start = i + 1;
                }
            }
        }
        if (paramBlock.length() > 0) {
            params.add(paramBlock.substring(start).trim());
        }
        String[] arr = new String[params.size()];
        params.toArray(arr);
        return arr;
    }

    private void storeParams(String[] params) {
        for (int i = 0; i < params.length; ++i) {
            String param = params[i].trim();
            int paramSpace = param.lastIndexOf(32);
            if (paramSpace < 0) {
                this.paramTypes[i] = ClassName.get(param.intern());
                this.paramNames[i] = "param" + (i + 1);
                continue;
            }
            this.paramTypes[i] = ClassName.get(param.substring(0, paramSpace).intern());
            this.paramNames[i] = param.substring(paramSpace + 1);
        }
    }

    public static MethodSignature fromFullKey(String fullKey) {
        int dot = fullKey.indexOf(46);
        int paren = fullKey.indexOf(40);
        if (dot < 0 || paren < 0 || dot > paren) {
            throw new IllegalArgumentException(fullKey);
        }
        ClassName className = ClassName.get(fullKey.substring(0, dot).replace('/', '.'));
        String methodName = fullKey.charAt(paren - 1) == '.' ? fullKey.substring(dot + 1, paren - 1) : fullKey.substring(dot + 1, paren);
        if (methodName.indexOf(46) >= 0) {
            throw new IllegalArgumentException(fullKey);
        }
        String signature = fullKey.substring(paren);
        return new MethodSignature(className, methodName, MethodSignature.getParamTypes(signature), MethodSignature.getReturnType(signature));
    }

    public static MethodSignature fromRawForm(String className, String methodName, String rawSignature) {
        return new MethodSignature(ClassName.get(className), methodName, MethodSignature.getParamTypes(rawSignature), MethodSignature.getReturnType(rawSignature));
    }

    public static ClassName[] getParamTypes(String descriptor) {
        int leftIndex = descriptor.indexOf(40);
        int rightIndex = descriptor.indexOf(41);
        if (leftIndex != 0 || rightIndex < 0) {
            throw new IllegalArgumentException(descriptor);
        }
        ArrayList<ClassName> classNames = new ArrayList<ClassName>();
        char[] params = descriptor.substring(leftIndex + 1, rightIndex).toCharArray();
        for (int i = 0; i < params.length; ++i) {
            StringBuffer buf = new StringBuffer(128);
            while (params[i] == '[') {
                buf.append('[');
                ++i;
            }
            buf.append(params[i]);
            int passgenerics = 0;
            if (params[i] == 'L' || params[i] == 'Q' || params[i] == 'T') {
                while (params[++i] != ';' || passgenerics > 0) {
                    if (params[i] == '<') {
                        ++passgenerics;
                    }
                    buf.append(params[i]);
                    if (params[i] != '>') continue;
                    --passgenerics;
                }
                buf.append(';');
            }
            classNames.add(ClassName.fromInternal(buf.toString()));
        }
        return classNames.toArray(new ClassName[classNames.size()]);
    }

    private static ClassName getReturnType(String descriptor) {
        int rightIndex = descriptor.indexOf(41);
        String returnType = descriptor.substring(rightIndex + 1);
        return ClassName.fromInternal(returnType);
    }

    private void buildLongAndCompareForms(ClassName className, String signature, int paren, StringBuffer longBuf, StringBuffer compareBuf) {
        longBuf.append(className.getName()).append('.').append(signature.substring(0, paren)).append('(');
        compareBuf.append(className.getName()).append('.').append(signature.substring(0, paren)).append('(');
        for (int i = 0; i < this.paramNames.length; ++i) {
            if (i > 0) {
                longBuf.append(',').append(' ');
                compareBuf.append(',');
            }
            longBuf.append(this.paramTypes[i]).append(' ').append(this.paramNames[i]);
            compareBuf.append(this.paramTypes[i]);
        }
        longBuf.append(')');
        compareBuf.append(')');
    }

    public String toString() {
        return this.getLongReturnForm();
    }

    public String getLongForm() {
        return this.longForm;
    }

    public String getLongFormNoNames() {
        return this.compareForm;
    }

    public String getLongReturnForm() {
        return this.returnType == null || this.isConstructor() ? this.longForm : this.returnType.getName() + ' ' + this.longForm;
    }

    public String getBytecodeForm() {
        StringBuffer buf = new StringBuffer();
        buf.append('(');
        for (int i = 0; i < this.paramTypes.length; ++i) {
            buf.append(this.paramTypes[i].getBytecodeName());
        }
        buf.append(')');
        buf.append(this.returnType == null || this.isConstructor() ? "V" : this.returnType.getBytecodeName());
        return buf.toString();
    }

    public String getKey() {
        return StringUtility.cat(this.name, '.', this.getBytecodeForm());
    }

    public String getFullKey() {
        return StringUtility.cat(this.className.getName().replace('.', '/'), '.', this.getKey());
    }

    public String getShortForm() {
        return this.shortForm;
    }

    public String getShortFormNoNames() {
        return this.compareForm.substring(this.className.getName().length() + 1);
    }

    public String getShortReturnForm() {
        return this.returnType == null || this.isConstructor() ? this.shortForm : this.returnType.getName() + ' ' + this.shortForm;
    }

    public String getDisplayForm() {
        return this.getDisplayForm(true);
    }

    public String getDisplayForm(boolean includeParamName) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.name).append('(');
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            ClassName paramType = this.paramTypes[i];
            String paramName = this.paramNames[i];
            buf.append(paramType.getSimpleName());
            if (paramName == null || !includeParamName) continue;
            buf.append(' ').append(paramName);
        }
        buf.append(')');
        return buf.toString();
    }

    public String getShortestForm() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.name).append('(');
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            ClassName paramType = this.paramTypes[i];
            buf.append(paramType.getSimpleName());
        }
        buf.append(')');
        return buf.toString();
    }

    public ClassName getReturnType() {
        return this.returnType;
    }

    public ClassName getClassName() {
        return this.className;
    }

    public String getName() {
        return this.name;
    }

    public ClassName[] getParamTypes() {
        return this.paramTypes;
    }

    public String[] getParamNames() {
        return this.paramNames;
    }

    public boolean isConstructor() {
        return "<init>".equals(this.name);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MethodSignature) {
            MethodSignature ms = (MethodSignature)o;
            return ms.compareForm.equals(this.compareForm);
        }
        return false;
    }

    public boolean fuzzyMatch(MethodSignature ms) {
        if (!ms.className.equals(this.className)) {
            return false;
        }
        if (!ms.name.equals(this.name)) {
            return false;
        }
        if (ms.paramTypes.length != this.paramTypes.length) {
            return false;
        }
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (ms.paramTypes[i].fuzzyMatch(this.paramTypes[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.compareForm.hashCode() ^ this.className.hashCode();
    }

    public boolean equalsIgnoreClass(MethodSignature ms) {
        return ms != null && ms.shortForm.equals(this.shortForm) && this.sameReturn(ms);
    }

    private boolean sameReturn(MethodSignature ms) {
        return ms.returnType == this.returnType || ms.returnType != null && ms.returnType.equals(this.returnType);
    }

    public String getGenericDisplayForm() {
        return this.getGenericDisplayForm(true);
    }

    public String getGenericDisplayForm(boolean includeParamName) {
        StringBuffer buffer = new StringBuffer(this.getName());
        buffer.append('(');
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.paramTypes[i].getSimpleTypeName());
            if (!includeParamName) continue;
            buffer.append(" ");
            buffer.append(this.paramNames[i]);
        }
        buffer.append(')');
        return buffer.toString();
    }

    public boolean isGeneric() {
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (!this.paramTypes[i].isGeneric()) continue;
            return true;
        }
        return false;
    }

    public static void convertParams(String methodName, String paramString, StringBuffer result) {
        result.append(methodName).append('(');
        char[] params = paramString.toCharArray();
        for (int i = 0; i < params.length; ++i) {
            StringBuffer buf = new StringBuffer(128);
            while (params[i] == '[') {
                buf.append('[');
                ++i;
            }
            buf.append(params[i]);
            int passgenerics = 0;
            if (params[i] == 'L' || params[i] == 'Q') {
                while (params[++i] != ';' || passgenerics > 0) {
                    if (params[i] == '<') {
                        ++passgenerics;
                    }
                    if (passgenerics == 0) {
                        buf.append(params[i]);
                    }
                    if (params[i] != '>') continue;
                    --passgenerics;
                }
                buf.append(';');
            }
            result.append(MethodSignature.getPrettyTypeName(buf.toString()));
            if (i + 1 >= params.length) continue;
            result.append(',');
        }
        result.append(')');
    }

    private static String getPrettyTypeName(String type) {
        int arrayCount = 0;
        while (type.startsWith("[")) {
            ++arrayCount;
            type = type.substring(1);
        }
        if (type.length() == 0) {
            throw new IllegalArgumentException(type);
        }
        StringBuffer result = new StringBuffer(type.length() + 10);
        switch (type.charAt(0)) {
            case 'B': {
                result.append("byte");
                break;
            }
            case 'C': {
                result.append("char");
                break;
            }
            case 'D': {
                result.append("double");
                break;
            }
            case 'F': {
                result.append("float");
                break;
            }
            case 'I': {
                result.append("int");
                break;
            }
            case 'J': {
                result.append("long");
                break;
            }
            case 'S': {
                result.append("short");
                break;
            }
            case 'V': {
                result.append("void");
                break;
            }
            case 'Z': {
                result.append("boolean");
                break;
            }
            case 'L': 
            case 'Q': {
                result.append(type.substring(1, type.length() - 1).replace('/', '.'));
                break;
            }
            default: {
                throw new IllegalArgumentException(type);
            }
        }
        for (int i = 0; i < arrayCount; ++i) {
            result.append('[').append(']');
        }
        return result.toString();
    }

    public Member toMember() throws SecurityException, NoSuchMethodException, ClassNotFoundException {
        Class clazz = this.className.toClass();
        Class[] paramClasses = new Class[this.paramTypes.length];
        for (int i = 0; i < paramClasses.length; ++i) {
            paramClasses[i] = this.paramTypes[i].toClass();
        }
        if (this.isConstructor()) {
            return clazz.getDeclaredConstructor(paramClasses);
        }
        return clazz.getDeclaredMethod(this.name, paramClasses);
    }

    public static MethodSignature fromMethod(Method method) {
        return MethodSignature.fromMember(method.getDeclaringClass(), method.getName(), method.getParameterTypes(), method.getReturnType());
    }

    public static MethodSignature fromConstructor(Constructor constructor) {
        return MethodSignature.fromMember(constructor.getDeclaringClass(), "<init>", constructor.getParameterTypes(), null);
    }

    private static MethodSignature fromMember(Class cls, String methodName, Class[] params, Class returnTClass) {
        ClassName cname = ClassName.get(cls);
        ClassName retType = returnTClass == null ? null : ClassName.get(returnTClass);
        ClassName[] types = new ClassName[params.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = ClassName.get(params[i].getName());
        }
        return new MethodSignature(cname, methodName, types, retType);
    }
}

