/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.types;

import com.agitar.common.types.ClassName;
import java.lang.reflect.Field;

public class FieldName {
    private final ClassName className;
    private final ClassName type;
    private final String name;

    public FieldName(ClassName type, ClassName declaringClass, String name) {
        if (type == null || declaringClass == null || name == null) {
            throw new IllegalArgumentException();
        }
        this.className = declaringClass;
        this.type = type;
        this.name = name;
    }

    public FieldName(String type, String declaringClass, String name) {
        if (type == null || declaringClass == null || name == null) {
            throw new IllegalArgumentException();
        }
        this.className = ClassName.get(declaringClass);
        this.type = ClassName.get(type);
        this.name = name;
    }

    public ClassName getClassName() {
        return this.className;
    }

    public ClassName getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getLongForm() {
        return this.type.getName() + ' ' + this.className.getName() + '.' + this.name;
    }

    public String getLongFormNoType() {
        return this.className.getName() + '.' + this.name;
    }

    public String getShortForm() {
        return this.type.getSimpleName() + ' ' + this.className.getSimpleName() + '.' + this.name;
    }

    public String getShortFormNoType() {
        return this.className.getSimpleName() + '.' + this.name;
    }

    public String toString() {
        return this.type.toString() + ' ' + this.className.toString() + '.' + this.name;
    }

    public Field toField() throws ClassNotFoundException, NoSuchFieldException {
        Class c = this.className.toClass();
        return this.findField(c, this.name);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FieldName) {
            FieldName that = (FieldName)o;
            return that.className.equals(this.className) && that.name.equals(this.name);
        }
        return false;
    }

    public int hashCode() {
        return this.className.hashCode() ^ this.name.hashCode();
    }

    private Field findField(Class c, String fieldName) throws NoSuchFieldException {
        while (c != null) {
            Field[] flds = c.getDeclaredFields();
            for (int i = 0; i < flds.length; ++i) {
                if (!flds[i].getName().equals(fieldName)) continue;
                return flds[i];
            }
            c = c.getSuperclass();
        }
        throw new NoSuchFieldException(this.className + "." + fieldName);
    }
}

