/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.types;

import com.agitar.common.types.ClassName;
import java.util.ArrayList;

public class ClassName5
extends ClassName {
    private final String fullTypeName;
    private final String simpleTypeName;
    private ClassName[] genericParameters;

    public ClassName5(String erasureForm, String genericForm) {
        super(erasureForm);
        this.fullTypeName = genericForm.trim();
        StringBuffer buffer = this.isArray() ? new StringBuffer(super.getComponentType().getSimpleName()) : new StringBuffer(super.getSimpleName());
        genericForm = this.findInnerClass(genericForm);
        int open = genericForm.indexOf(60);
        int close = genericForm.lastIndexOf(62);
        if (open > 0 && close > open) {
            buffer.append('<');
            String parameters = genericForm.substring(open + 1, close);
            String[] types = this.splitParams(parameters);
            this.genericParameters = new ClassName[types.length];
            for (int i = 0; i < types.length; ++i) {
                if (i > 0) {
                    buffer.append(',');
                }
                this.genericParameters[i] = types[i].startsWith("?") ? new Wildcard(types[i]) : new ClassName5(types[i]);
                buffer.append(this.genericParameters[i].getSimpleTypeName());
            }
            buffer.append('>');
            if (this.isArray()) {
                buffer.append("[]");
            }
            this.simpleTypeName = buffer.toString();
        } else {
            this.simpleTypeName = new ClassName(genericForm).getSimpleName();
            this.genericParameters = new ClassName5[0];
        }
    }

    private String findInnerClass(String fullName) {
        int nested = 0;
        block5: for (int i = fullName.length() - 1; i >= 0; --i) {
            switch (fullName.charAt(i)) {
                case '<': {
                    ++nested;
                    continue block5;
                }
                case '>': {
                    --nested;
                    continue block5;
                }
                case '$': {
                    if (nested != 0) continue block5;
                    return fullName.substring(i + 1);
                }
            }
        }
        return fullName;
    }

    private String[] splitParams(String paramBlock) {
        paramBlock = paramBlock.trim();
        ArrayList<String> params = new ArrayList<String>();
        int nested = 0;
        int start = 0;
        block5: for (int i = 0; i < paramBlock.length(); ++i) {
            switch (paramBlock.charAt(i)) {
                case '<': {
                    ++nested;
                    continue block5;
                }
                case '>': {
                    --nested;
                    continue block5;
                }
                case ',': {
                    if (nested != 0) continue block5;
                    params.add(paramBlock.substring(start, i).trim());
                    start = i + 1;
                }
            }
        }
        if (paramBlock.length() > 0) {
            params.add(paramBlock.substring(start).trim());
        }
        String[] arr = new String[params.size()];
        params.toArray(arr);
        return arr;
    }

    public ClassName5(String name) {
        this(ClassName5.erase(name), name);
    }

    public final String getFullTypeName() {
        return this.fullTypeName;
    }

    public final String getSimpleTypeName() {
        return this.simpleTypeName;
    }

    public ClassName[] getParameters() {
        return this.genericParameters;
    }

    public boolean isSameType(ClassName that) {
        return this.getFullTypeName().equals(that.getFullTypeName());
    }

    public boolean isGeneric() {
        return !this.getName().equals(this.fullTypeName);
    }

    public String getSourceName() {
        return this.getFullTypeName();
    }

    public static String erase(String name) {
        int lt = name.indexOf(60);
        if (lt < 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        int level = 0;
        StringBuffer buf = new StringBuffer();
        block4: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '<': {
                    ++level;
                    continue block4;
                }
                case '>': {
                    --level;
                    continue block4;
                }
                default: {
                    if (level != 0) continue block4;
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public static class Wildcard
    extends ClassName {
        public static final int CONSTRAINT_EXTENDS = 0;
        public static final int CONSTRAINT_SUPER = 1;
        private String simpleName;
        private ClassName constraint;
        private int constraintType;

        public Wildcard(String name) {
            super(name);
            int index = name.indexOf(" super ");
            if (index >= 0) {
                index += 7;
                this.constraintType = 1;
            } else {
                index = name.indexOf(" extends ");
                if (index > 0) {
                    index += 9;
                    this.constraintType = 0;
                }
            }
            if (index > 0) {
                this.constraint = Wildcard.get(name.substring(index));
                this.simpleName = name.substring(0, index) + this.constraint.getSimpleTypeName();
            } else {
                this.simpleName = name;
            }
        }

        public String getSimpleName() {
            return this.simpleName;
        }

        public ClassName getConstraint() {
            return this.constraint;
        }

        public int getConstraintType() {
            return this.constraintType;
        }
    }
}

