/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.types;

import com.agitar.InternalException;
import com.agitar.common.logging.AgitarLevel;
import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.types.ClassName5;
import com.agitar.common.util.ReflectionCache;
import com.agitar.common.util.ReflectionCacheRegistry;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ClassName
implements Comparable,
Serializable,
ReflectionCache {
    public static final String ROOT_PACKAGE = "";
    public static final String CLASS_EXTENSION = ".class";
    public static final String SOURCE_EXTENSION = ".java";
    public static final Set PRIMITIVE_STRINGS;
    public static final Set BOXED_PRIMITIVE_STRINGS;
    private static final Map cache;
    private static boolean java5;
    private static Method getTypeParameters;
    public static final ClassName OBJECT;
    public static final ClassName STRING;
    public static final ClassName CLASS;
    public static final ClassName JL_BOOLEAN;
    public static final ClassName JL_BYTE;
    public static final ClassName JL_CHARACTER;
    public static final ClassName JL_SHORT;
    public static final ClassName JL_INTEGER;
    public static final ClassName JL_LONG;
    public static final ClassName JL_FLOAT;
    public static final ClassName JL_DOUBLE;
    public static final ClassName EXCEPTION;
    public static final ClassName THROWABLE;
    public static final ClassName BOOLEAN;
    public static final ClassName BYTE;
    public static final ClassName CHAR;
    public static final ClassName SHORT;
    public static final ClassName INT;
    public static final ClassName LONG;
    public static final ClassName FLOAT;
    public static final ClassName DOUBLE;
    public static final ClassName VOID;
    private final String fullName;
    private final String name;
    private final String packageName;
    private final String sourceName;
    private final String byteCodeName;
    private final boolean primitive;
    private final int arrayDepth;
    private final boolean isInnerClass;
    Class reflectClass;
    public static Comparator COMPARE_BY_NAME_WO_PACKAGE;
    public static Comparator COMPARE_BY_SIMPLE_NAME;
    public static Comparator COMPARE_BY_NAME;
    static final /* synthetic */ boolean $assertionsDisabled;

    public String getFullTypeName() {
        return this.fullName;
    }

    public String getSimpleTypeName() {
        return this.getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassName get(String name) {
        ClassName cn;
        if (name == null) {
            throw new IllegalArgumentException();
        }
        Map map = cache;
        synchronized (map) {
            cn = (ClassName)cache.get(name);
            if (cn == null) {
                cn = new ClassName5(name);
                cache.put(name, cn);
            }
        }
        return cn;
    }

    public static ClassName[] get(Class[] classes) {
        ClassName[] classNames = new ClassName[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            classNames[i] = ClassName.get(classes[i]);
        }
        return classNames;
    }

    public static ClassName get(Class cls) {
        if (cls.isArray()) {
            return ClassName.fromInternal(cls.getName());
        }
        if (java5) {
            try {
                Object[] typeParams = (Object[])(getTypeParameters == null ? null : getTypeParameters.invoke((Object)cls, null));
                if (typeParams == null || typeParams.length == 0) {
                    return ClassName.get(cls.getName());
                }
                StringBuffer buf = new StringBuffer(50);
                buf.append(cls.getName()).append('<');
                for (int i = 0; i < typeParams.length; ++i) {
                    Object typeParam = typeParams[i];
                    Method getName = typeParam.getClass().getDeclaredMethod("getName", new Class[0]);
                    String name = (String)getName.invoke(typeParam, null);
                    Method getBounds = typeParam.getClass().getDeclaredMethod("getBounds", new Class[0]);
                    Object[] bounds = (Object[])getBounds.invoke(typeParam, null);
                    String boundsStr = bounds[0].toString();
                    if (i > 0) {
                        buf.append(',');
                    }
                    if ("class java.lang.Object".equals(boundsStr)) {
                        buf.append(name);
                        continue;
                    }
                    if (boundsStr.startsWith("class ")) {
                        buf.append(name).append(" extends ").append(boundsStr.substring(6));
                        continue;
                    }
                    buf.append(name).append(" extends ").append(boundsStr);
                }
                buf.append('>');
                return ClassName.get(buf.toString());
            }
            catch (NoSuchMethodException e) {
                java5 = false;
                return ClassName.get(cls.getName());
            }
            catch (Error e) {
                AgitarLogger.getDiagnosticLogger("ClassName").log(AgitarLevel.WARNING, "couldn't get TypeParameters for " + cls.getName(), e);
                return ClassName.get(cls.getName());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return ClassName.get(cls.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseAllReflection() {
        Map map = cache;
        synchronized (map) {
            Iterator iterator = cache.values().iterator();
            while (iterator.hasNext()) {
                ClassName className = (ClassName)iterator.next();
                className.reflectClass = null;
            }
        }
    }

    public void releaseReflection() {
        this.reflectClass = null;
    }

    public static ClassName fromInternal(String iname) {
        return ClassName.get(ClassName.getPrettyTypeName(iname));
    }

    protected ClassName(String fullName) {
        if (fullName == null) {
            throw new IllegalArgumentException("Class name is null");
        }
        if ((fullName = fullName.trim()).length() == 0 || fullName.charAt(0) == '<' || fullName.endsWith(".") && !fullName.endsWith("...") || fullName.indexOf(0) >= 0) {
            throw new IllegalArgumentException("Class name is not valid [" + fullName + "]");
        }
        if (fullName.indexOf(91) == 0) {
            fullName = ClassName.getPrettyTypeName(fullName);
        }
        this.sourceName = fullName = fullName.replace('/', '.');
        if (fullName.endsWith("...")) {
            fullName = fullName.substring(0, fullName.length() - 3) + "[]";
        }
        int angleBracket = fullName.lastIndexOf(60);
        while (angleBracket >= 0) {
            int endAngleBracket = fullName.indexOf(62, angleBracket);
            if (endAngleBracket < 0) {
                throw new IllegalArgumentException(fullName);
            }
            fullName = fullName.substring(0, angleBracket) + fullName.substring(endAngleBracket + 1);
            angleBracket = fullName.lastIndexOf(60);
        }
        this.fullName = fullName.trim();
        this.arrayDepth = ClassName.countArrayDepth(fullName, fullName.indexOf(91));
        int dot = this.fullName.lastIndexOf(46);
        this.packageName = dot < 0 ? ROOT_PACKAGE : this.fullName.substring(0, dot);
        String base = this.fullName.substring(dot + 1);
        this.name = base.substring(ClassName.findInnerDivider(base) + 1);
        this.primitive = Character.isLowerCase(fullName.charAt(0)) & PRIMITIVE_STRINGS.contains(fullName);
        this.byteCodeName = this.isArray() ? "[" + this.getComponentType().getBytecodeName() : (this.primitive ? String.valueOf(ClassName.primByteCode(fullName)) : 'L' + fullName.replace('.', '/') + ';');
        int div = ClassName.findInnerDivider(fullName);
        this.isInnerClass = div > fullName.lastIndexOf(46) + 1 && div < fullName.length() - 1;
    }

    private static int countArrayDepth(String fullName, int bracket) {
        int arrayDepth;
        if (bracket > 0) {
            for (int i = bracket; i < fullName.length(); i += 2) {
                char c2;
                char c1 = fullName.charAt(i);
                char c = c2 = i + 1 < fullName.length() ? fullName.charAt(i + 1) : (char)'\u0000';
                if (c1 == '[' && c2 == ']') continue;
                throw new IllegalArgumentException(fullName);
            }
            arrayDepth = (fullName.length() - bracket) / 2;
        } else {
            arrayDepth = 0;
        }
        ClassName.validateBrackets(fullName, arrayDepth);
        return arrayDepth;
    }

    private static void validateBrackets(String fullName, int arrayDepth) {
        int bracketArea = fullName.length() - 2 * arrayDepth;
        int openBracket = fullName.indexOf(91);
        int closeBracket = fullName.indexOf(93);
        if (openBracket < bracketArea && openBracket >= 0 || closeBracket < bracketArea && closeBracket >= 0) {
            throw new IllegalArgumentException(fullName);
        }
    }

    public boolean isValid() {
        char[] cn = this.fullName.toCharArray();
        if (!Character.isJavaIdentifierStart(cn[0])) {
            return false;
        }
        for (int i = 1; i < cn.length; ++i) {
            if (Character.isJavaIdentifierPart(cn[i]) || cn[i] == '.' && cn[i - 1] != '.') continue;
            return false;
        }
        return true;
    }

    public boolean isArray() {
        return this.arrayDepth > 0;
    }

    public int getArrayDims() {
        return this.arrayDepth;
    }

    public ClassName getComponentType() {
        return this.arrayDepth <= 0 ? null : ClassName.get(this.fullName.substring(0, this.fullName.length() - 2));
    }

    public ClassName getBaseType() {
        return this.arrayDepth <= 0 ? this : new ClassName(this.fullName.substring(0, this.fullName.length() - 2 * this.arrayDepth));
    }

    public String getSimpleName() {
        return this.name;
    }

    public String getSourceSimpleName() {
        String swp = this.getSourceNameWithoutPackage();
        return swp.substring(ClassName.findInnerDivider(swp) + 1);
    }

    public String getNameWithoutPackage() {
        return this.packageName.length() == 0 ? this.fullName : this.fullName.substring(this.packageName.length() + 1);
    }

    public String getSourceNameWithoutPackage() {
        String sourceName = this.getSourceName();
        return this.packageName.length() == 0 ? sourceName : sourceName.substring(this.packageName.length() + 1);
    }

    public boolean isInnerClass() {
        return this.isInnerClass;
    }

    public boolean isAnonymous() {
        boolean anon = this.name.length() > 0 && Character.isDigit(this.name.charAt(0));
        ClassName parent = this.getContainingClass();
        return anon || parent != null && parent.isAnonymous();
    }

    public ClassName getContainingClass() {
        int div;
        for (div = ClassName.findInnerDivider(this.sourceName); div > 0 && this.sourceName.charAt(div - 1) == '$'; --div) {
        }
        return div <= this.sourceName.lastIndexOf(46) + 1 ? null : new ClassName(this.sourceName.substring(0, div));
    }

    private static int findInnerDivider(String s) {
        return Math.max(s.lastIndexOf(36), s.lastIndexOf(43));
    }

    public ClassName getOutermostClass() {
        ClassName cn;
        for (cn = this; cn != null && cn.isInnerClass(); cn = cn.getContainingClass()) {
        }
        return cn;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getName() {
        return this.fullName;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getBytecodeName() {
        return this.byteCodeName;
    }

    private static char primByteCode(String primName) {
        switch (primName.charAt(0)) {
            case 'i': {
                return 'I';
            }
            case 'b': {
                return primName.charAt(1) == 'o' ? (char)'Z' : 'B';
            }
            case 'v': {
                return 'V';
            }
            case 'c': {
                return 'C';
            }
            case 'l': {
                return 'J';
            }
            case 's': {
                return 'S';
            }
            case 'd': {
                return 'D';
            }
            case 'f': {
                return 'F';
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)primName);
        }
        return 'V';
    }

    public String getJClassName() {
        if (this.primitive) {
            return null;
        }
        if (this.isArray()) {
            return this.getBytecodeName().replace('/', '.');
        }
        return this.fullName;
    }

    public String getClassFileName() {
        return this.getBaseType().getName().replace('.', '/') + CLASS_EXTENSION;
    }

    public String getSourceFileName() {
        return this.getSourceFileName(null);
    }

    public String getSourceFileName(String sourceFileAttribute) {
        if (sourceFileAttribute == null) {
            ClassName cn = this;
            while (cn.isInnerClass()) {
                cn = cn.getContainingClass();
            }
            return cn.getName().replace('.', '/') + SOURCE_EXTENSION;
        }
        String baseName = new File(sourceFileAttribute).getName();
        return this.packageName.length() > 0 ? this.packageName.replace('.', '/') + '/' + baseName : baseName;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isInstance(Object o) throws ClassNotFoundException {
        if (this.primitive) {
            switch (ClassName.primByteCode(this.fullName)) {
                case 'I': {
                    return o instanceof Integer;
                }
                case 'B': {
                    return o instanceof Byte;
                }
                case 'Z': {
                    return o instanceof Boolean;
                }
                case 'V': {
                    return o instanceof Void;
                }
                case 'C': {
                    return o instanceof Character;
                }
                case 'J': {
                    return o instanceof Long;
                }
                case 'S': {
                    return o instanceof Short;
                }
                case 'D': {
                    return o instanceof Double;
                }
                case 'F': {
                    return o instanceof Float;
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return false;
        }
        return this.toClass().isAssignableFrom(o.getClass());
    }

    public String toString() {
        return this.fullName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class toClass() throws ClassNotFoundException {
        ClassLoader loader;
        if (this.reflectClass != null) {
            return this.reflectClass;
        }
        if (this.isPrimitive()) {
            this.reflectClass = this.toPrimitiveClass();
            return this.reflectClass;
        }
        Map map = cache;
        synchronized (map) {
            if (cache.get(this.fullName) != this) {
                ReflectionCacheRegistry.registerWeak(this);
            }
        }
        String internalForm = this.isArray() ? this.byteCodeName.replace('/', '.') : this.fullName;
        do {
            try {
                loader = ReflectionCacheRegistry.getContextClassLoader();
                this.reflectClass = Class.forName(internalForm, true, loader);
            }
            catch (NoClassDefFoundError e) {
                throw new ClassNotFoundException(this.fullName, e);
            }
        } while (loader != ReflectionCacheRegistry.getContextClassLoader());
        return this.reflectClass;
    }

    private Class toPrimitiveClass() {
        switch (ClassName.primByteCode(this.fullName)) {
            case 'I': {
                return Integer.TYPE;
            }
            case 'B': {
                return Byte.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
            case 'V': {
                return Void.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return Void.TYPE;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ClassName) {
            ClassName cn = (ClassName)o;
            return this.fullName.equals(cn.fullName);
        }
        return false;
    }

    public boolean fuzzyMatch(ClassName cn) {
        if (ROOT_PACKAGE.equals(this.packageName) || ROOT_PACKAGE.equals(cn.packageName)) {
            return this.name.equals(cn.name);
        }
        return this.fullName.equals(cn.fullName);
    }

    public int hashCode() {
        return this.fullName.hashCode();
    }

    public boolean isSameType(ClassName that) {
        return this.equals(that);
    }

    public boolean isGeneric() {
        return false;
    }

    public boolean isUnboundGeneric() {
        if (this.isGeneric()) {
            ClassName[] parameters = this.getParameters();
            if (this.getFullTypeName().indexOf(46) < 0) {
                return true;
            }
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i].getName().indexOf(46) >= 0) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isVoid() {
        return "void".equals(this.getName());
    }

    public final boolean isFloatingPoint() {
        return this.isDouble() || this.isFloat();
    }

    public final boolean isDouble() {
        String name = this.getName();
        return "double".equals(name) || "java.lang.Double".equals(name);
    }

    public final boolean isFloat() {
        String name = this.getName();
        return "float".equals(name) || "java.lang.Float".equals(name);
    }

    public boolean isIntegral() {
        String name = this.getName();
        if (this.primitive) {
            return "int".equals(name) || "byte".equals(name) || "short".equals(name) || "long".equals(name);
        }
        return "java.lang.Integer".equals(name) || "java.lang.Byte".equals(name) || "java.lang.Long".equals(name) || "java.lang.Short".equals(name);
    }

    public boolean isCategory1Type() {
        return !this.isCategory2Type();
    }

    public boolean isCategory2Type() {
        return this.primitive && ("long".equals(this.name) || "double".equals(this.name));
    }

    public boolean isBoxedPrimitive() {
        return BOXED_PRIMITIVE_STRINGS.contains(this.getName());
    }

    public Class unbox() {
        if (this.isBoxedPrimitive()) {
            switch (this.getName().charAt(10)) {
                case 'I': {
                    return Integer.TYPE;
                }
                case 'B': {
                    if (this.getName().charAt(11) == 'y') {
                        return Byte.TYPE;
                    }
                    return Boolean.TYPE;
                }
                case 'F': {
                    return Float.TYPE;
                }
                case 'D': {
                    return Double.TYPE;
                }
                case 'V': {
                    return Void.TYPE;
                }
                case 'L': {
                    return Long.TYPE;
                }
                case 'C': {
                    return Character.TYPE;
                }
                case 'S': {
                    return Short.TYPE;
                }
            }
        }
        throw new InternalException("tried to unbox not boxed type " + this.getName());
    }

    public Class box() {
        if (this.primitive) {
            switch (this.getName().charAt(0)) {
                case 'b': {
                    if (this.getName().charAt(1) == 'y') {
                        return Byte.class;
                    }
                    return Boolean.class;
                }
                case 'c': {
                    return Character.class;
                }
                case 'd': {
                    return Double.class;
                }
                case 'f': {
                    return Float.class;
                }
                case 'i': {
                    return Integer.class;
                }
                case 'l': {
                    return Long.class;
                }
                case 's': {
                    return Short.class;
                }
                case 'v': {
                    return Void.class;
                }
            }
        }
        throw new InternalException("tried to wrap non-primitive type " + this.fullName);
    }

    public ClassName[] getParameters() {
        return new ClassName[0];
    }

    public int compareTo(Object other) {
        return COMPARE_BY_NAME.compare(this, other);
    }

    private static String getPrettyTypeName(String type) {
        int arrayCount = 0;
        while (type.startsWith("[")) {
            ++arrayCount;
            type = type.substring(1);
        }
        if (type.length() == 0) {
            throw new IllegalArgumentException(type);
        }
        StringBuffer result = new StringBuffer(type.length() + 10);
        switch (type.charAt(0)) {
            case 'B': {
                result.append("byte");
                break;
            }
            case 'C': {
                result.append("char");
                break;
            }
            case 'D': {
                result.append("double");
                break;
            }
            case 'F': {
                result.append("float");
                break;
            }
            case 'I': {
                result.append("int");
                break;
            }
            case 'J': {
                result.append("long");
                break;
            }
            case 'S': {
                result.append("short");
                break;
            }
            case 'V': {
                result.append("void");
                break;
            }
            case 'Z': {
                result.append("boolean");
                break;
            }
            case 'L': 
            case 'Q': 
            case 'T': {
                String className = type.substring(1, type.length() - 1).replace('/', '.');
                if (className.endsWith(">")) {
                    int lt = className.indexOf(60);
                    result.append(className.substring(0, lt + 1));
                    if (className.charAt(lt + 1) == '+') {
                        result.append("? extends ");
                        result.append(ClassName.getPrettyTypeName(className.substring(lt + 2, className.length() - 1)));
                    } else {
                        result.append(ClassName.getPrettyTypeName(className.substring(lt + 1, className.length() - 1)));
                    }
                    result.append('>');
                    break;
                }
                result.append(className);
                break;
            }
            default: {
                throw new IllegalArgumentException(type);
            }
        }
        for (int i = 0; i < arrayCount; ++i) {
            result.append('[').append(']');
        }
        return result.toString();
    }

    private static int compareNames(String n1, String n2) {
        int div2;
        int div1 = ClassName.findInnerDivider(n1);
        if (div1 == (div2 = ClassName.findInnerDivider(n2)) && div1 > -1 && n1.substring(0, div1).equals(n2.substring(0, div2)) && Character.isDigit(n1.charAt(n1.length() - 1)) && Character.isDigit(n2.charAt(n2.length() - 1))) {
            String num1 = n1.substring(div1 + 1);
            String num2 = n2.substring(div1 + 1);
            try {
                return Integer.parseInt(num1) - Integer.parseInt(num2);
            }
            catch (NumberFormatException x) {
                return n1.compareTo(n2);
            }
        }
        return n1.compareTo(n2);
    }

    static {
        $assertionsDisabled = !ClassName.class.desiredAssertionStatus();
        PRIMITIVE_STRINGS = new HashSet<String>(Arrays.asList("int", "long", "short", "byte", "boolean", "float", "double", "char", "void"));
        BOXED_PRIMITIVE_STRINGS = new HashSet<String>(Arrays.asList("java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.Byte", "java.lang.Boolean", "java.lang.Float", "java.lang.Double", "java.lang.Character", "java.lang.Void"));
        cache = new HashMap(503);
        ReflectionCacheRegistry.register(new ReflectionCache(){

            public void releaseReflection() {
                ClassName.releaseAllReflection();
            }
        });
        try {
            getTypeParameters = Class.class.getDeclaredMethod("getTypeParameters", null);
            java5 = true;
        }
        catch (Exception e) {
            getTypeParameters = null;
            java5 = false;
        }
        OBJECT = ClassName.get("java.lang.Object");
        STRING = ClassName.get("java.lang.String");
        CLASS = ClassName.get("java.lang.Class");
        JL_BOOLEAN = ClassName.get("java.lang.Boolean");
        JL_BYTE = ClassName.get("java.lang.Byte");
        JL_CHARACTER = ClassName.get("java.lang.Character");
        JL_SHORT = ClassName.get("java.lang.Short");
        JL_INTEGER = ClassName.get("java.lang.Integer");
        JL_LONG = ClassName.get("java.lang.Long");
        JL_FLOAT = ClassName.get("java.lang.Float");
        JL_DOUBLE = ClassName.get("java.lang.Double");
        EXCEPTION = ClassName.get("java.lang.Exception");
        THROWABLE = ClassName.get("java.lang.Throwable");
        BOOLEAN = ClassName.get("boolean");
        BYTE = ClassName.get("byte");
        CHAR = ClassName.get("char");
        SHORT = ClassName.get("short");
        INT = ClassName.get("int");
        LONG = ClassName.get("long");
        FLOAT = ClassName.get("float");
        DOUBLE = ClassName.get("double");
        VOID = ClassName.get("void");
        COMPARE_BY_NAME_WO_PACKAGE = new Comparator(){

            public int compare(Object o1, Object o2) {
                ClassName cn1 = (ClassName)o1;
                ClassName cn2 = (ClassName)o2;
                String n1 = cn1.getNameWithoutPackage();
                String n2 = cn2.getNameWithoutPackage();
                return ClassName.compareNames(n1, n2);
            }
        };
        COMPARE_BY_SIMPLE_NAME = new Comparator(){

            public int compare(Object o1, Object o2) {
                ClassName cn1 = (ClassName)o1;
                ClassName cn2 = (ClassName)o2;
                String n1 = cn1.getSimpleName();
                String n2 = cn2.getSimpleName();
                return ClassName.compareNames(n1, n2);
            }
        };
        COMPARE_BY_NAME = new Comparator(){

            public int compare(Object o1, Object o2) {
                ClassName cn1 = (ClassName)o1;
                ClassName cn2 = (ClassName)o2;
                String n1 = cn1.getName();
                String n2 = cn2.getName();
                return ClassName.compareNames(n1, n2);
            }
        };
    }
}

