/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.logging;

import com.agitar.common.logging.AgitarLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogOutputStream
extends OutputStream {
    private static final int _MAX_BUF_SIZE = 2048;
    private static final char _LINE_SEP = '\n';
    private static final String notifyMsg = "An unexpected output occurred on the standard out and err stream. It is logged in the diagnostic log.";
    private Logger _theLogger = null;
    private Level _logAsLev = null;
    private StringBuffer _buf = null;
    private int _size = 0;
    private static boolean notified = false;

    public LogOutputStream(Logger logger, Level logAsLev) {
        this._theLogger = logger;
        this._logAsLev = logAsLev;
        this._buf = new StringBuffer(512);
    }

    public synchronized void write(int b) throws IOException {
        if (b == 10) {
            this.flush();
            return;
        }
        this._buf.append((char)b);
        ++this._size;
        if (this._size > 2048) {
            this.flush();
        }
    }

    public void flush() throws IOException {
        Handler[] _handlers;
        int len = this._buf.length();
        if (len > 0) {
            if (!notified) {
                AgitarLogger.getUserLogger().warning(notifyMsg);
                notified = true;
            }
            this._theLogger.log(this._logAsLev, this._buf.toString());
            this._buf.delete(0, len);
            this._size = 0;
        }
        if ((_handlers = this._theLogger.getHandlers()) != null && _handlers.length > 0) {
            for (int i = 0; i < _handlers.length; ++i) {
                _handlers[i].flush();
            }
        }
    }

    public void close() throws IOException {
        this.flush();
        Handler[] _handlers = this._theLogger.getHandlers();
        if (_handlers != null && _handlers.length > 0) {
            for (int i = 0; i < _handlers.length; ++i) {
                _handlers[i].close();
            }
        }
    }
}

