/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.logging;

import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.util.AgitarProperties;
import com.agitar.common.util.EvilTwin;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class DumpableLogManager
extends LogManager {
    private static final boolean OPLA_RUNNING = System.getProperty("OPLA") != null;
    private static IdentityHashMap loggerLockBox;
    private static Logger rootLoggerInSuper;

    public static void dump() {
        if (!EvilTwin.isMe() && OPLA_RUNNING) {
            return;
        }
        ArrayList<String> batchedErrors = new ArrayList<String>();
        Iterator residentLoggers = DumpableLogManager.getResidentLoggers(batchedErrors).values().iterator();
        try {
            Field force = DumpableLogManager.getStaticLogManagerField();
            force.set(null, null);
        }
        catch (Exception e) {
            batchedErrors.add("Could not dump static log manager due to " + e.getClass().getName() + " [" + e.getMessage() + "]");
        }
        try {
            DumpableLogManager.removeLogManagerHooks();
        }
        catch (Exception e) {
            batchedErrors.add("Could not remove LogManager shutdown hooks due to " + e.getClass().getName() + " [" + e.getMessage() + "]");
        }
        DumpableLogManager.init(batchedErrors);
        while (residentLoggers.hasNext()) {
            Logger residentLogger = (Logger)residentLoggers.next();
            LogManager.getLogManager().addLogger(residentLogger);
        }
        DumpableLogManager.logErrors(batchedErrors, null, null);
    }

    private static void logErrors(List batchedErrors, Logger agitarLogger, Class bootstrappedClass) {
        if (batchedErrors != null) {
            Iterator iter = batchedErrors.iterator();
            while (iter.hasNext()) {
                String error = (String)iter.next();
                Logger diagnosticLogger = null;
                if (bootstrappedClass == null) {
                    diagnosticLogger = AgitarLogger.getDiagnosticLogger();
                }
                if (diagnosticLogger == null) {
                    diagnosticLogger = agitarLogger;
                }
                if (diagnosticLogger != null) {
                    diagnosticLogger.info("Error cleaning LogManager: " + error);
                    continue;
                }
                String boostrapErrMessage = bootstrappedClass == null ? "with logging system" : "bootstrapping logger for class " + bootstrappedClass.getName();
                System.err.println("SEVERE error " + boostrapErrMessage + ". Also had error cleaning LogManager: " + error);
            }
        }
    }

    public static void removeLogManagerHooks() throws ClassNotFoundException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Class<?> javaLangShutdownClass = Class.forName("java.lang.Shutdown");
        Field hooksField = javaLangShutdownClass.getDeclaredField("hooks");
        hooksField.setAccessible(true);
        Set hooks = (Set)hooksField.get(null);
        ArrayList<Thread> hooksToRemove = new ArrayList<Thread>(hooks.size());
        Iterator iter = hooks.iterator();
        while (iter.hasNext()) {
            Object wrappedHook = iter.next();
            Field hookField = wrappedHook.getClass().getDeclaredField("hook");
            hookField.setAccessible(true);
            Thread hook = (Thread)hookField.get(wrappedHook);
            if (!hook.getClass().getName().startsWith("java.util.logging.LogManager")) continue;
            hooksToRemove.add(hook);
        }
        iter = hooksToRemove.iterator();
        while (iter.hasNext()) {
            Thread hookToRemove = (Thread)iter.next();
            Runtime.getRuntime().removeShutdownHook(hookToRemove);
        }
    }

    private static Field getStaticLogManagerField() throws NoSuchFieldException {
        Field force = LogManager.class.getDeclaredField("manager");
        force.setAccessible(true);
        return force;
    }

    private static Logger getRootLogger(List batchedErrors) {
        if (rootLoggerInSuper == null) {
            try {
                Field rootLoggerField = DumpableLogManager.getRootLoggerField();
                rootLoggerInSuper = (Logger)rootLoggerField.get(LogManager.getLogManager());
            }
            catch (Exception e) {
                batchedErrors.add("Could not reset rootLogger in LogManager due to " + e.getClass().getName() + " [" + e.getMessage() + "]");
            }
        }
        return rootLoggerInSuper;
    }

    private static Field getRootLoggerField() throws NoSuchFieldException {
        Field rootLoggerField = LogManager.class.getDeclaredField("rootLogger");
        rootLoggerField.setAccessible(true);
        return rootLoggerField;
    }

    private static void init(List batchedErrors) {
        ClassLoader userClassLoader = Thread.currentThread().getContextClassLoader();
        String managerClassName = AgitarProperties.LOGGING_MANAGER;
        LogManager newManager = null;
        if (managerClassName != null) {
            try {
                Class<?> loggingManagerClass = userClassLoader.loadClass(managerClassName);
                newManager = (LogManager)loggingManagerClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                batchedErrors.add("Could not find user-specfied log manager class " + managerClassName);
            }
            catch (InstantiationException e) {
                batchedErrors.add("Could not instantiate user-specfied log manager class " + managerClassName + " [" + e.getMessage() + "]");
            }
            catch (IllegalAccessException e) {
                batchedErrors.add("Could not access user-specfied log manager class " + managerClassName + " [" + e.getMessage() + "]");
            }
        }
        if (newManager == null) {
            newManager = new DumpableLogManager();
        }
        try {
            DumpableLogManager.getStaticLogManagerField().set(null, newManager);
            DumpableLogManager.getRootLoggerField().set(newManager, rootLoggerInSuper);
        }
        catch (Exception e) {
            batchedErrors.add("Could not reset static log manager due to " + e.getClass().getName() + " [" + e.getMessage() + "]");
        }
    }

    private static IdentityHashMap getResidentLoggers(List batchedErrors) {
        if (loggerLockBox == null) {
            loggerLockBox = new IdentityHashMap();
            loggerLockBox.put(Logger.global, Logger.global);
            Logger rootLogger = DumpableLogManager.getRootLogger(batchedErrors);
            if (rootLogger != null) {
                loggerLockBox.put(rootLogger, rootLogger);
            }
        }
        return loggerLockBox;
    }

    public static Logger getAgitarLogger(String name) {
        return DumpableLogManager.getAgitarLoggerInternal(name, null);
    }

    static Logger getBootstrappedAgitarLogger(String logName, Class bootstrappedClass) {
        return DumpableLogManager.getAgitarLoggerInternal(logName, bootstrappedClass);
    }

    private static Logger getAgitarLoggerInternal(String logName, Class bootstrappedClass) {
        ArrayList errors = new ArrayList();
        Logger agitarLogger = Logger.getLogger(logName);
        DumpableLogManager.getResidentLoggers(errors).put(agitarLogger, agitarLogger);
        if (errors.size() > 0) {
            DumpableLogManager.logErrors(errors, agitarLogger, bootstrappedClass);
        }
        return agitarLogger;
    }
}

