/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.logging;

import com.agitar.common.diagnostics.Diagnostics;
import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.util.AgitarProperties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class DiagLogNotifyHandler
extends Handler {
    public static boolean userNotified = false;
    private static String _userMsg = "An internal error occurred. " + AgitarProperties.LINE_SEPARATOR + "          Please " + (AgitarProperties.SERVER_MODE ? "download" : "export") + " a troubleshooting report and send it to support@agitar.com.";

    public void publish(LogRecord record) {
        if (record.getLevel().equals(Level.SEVERE)) {
            Diagnostics.getKey("log.severe.error").addError(record.getMessage(), record.getThrown());
            if (!userNotified) {
                AgitarLogger.getUserLogger().log(Level.SEVERE, _userMsg);
                userNotified = true;
            }
        }
    }

    public void flush() {
    }

    public void close() throws SecurityException {
    }
}

