/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.logging;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import junit.framework.TestCase;

public class BugLogger {
    public static final File BUGS_FILE = new File("output/test/results/bugs.txt");
    public static final String ENCODING = "UTF-8";
    private static BugLogger defaultLogger;
    private PrintWriter out;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bug(int id, TestCase test) throws FileNotFoundException, UnsupportedEncodingException {
        File file = BUGS_FILE;
        synchronized (file) {
            BugLogger.getDefaultLogger().log(id, test);
        }
    }

    public static BugLogger getDefaultLogger() throws FileNotFoundException, UnsupportedEncodingException {
        if (defaultLogger == null) {
            defaultLogger = new BugLogger(BugLogger.openFile());
        }
        return defaultLogger;
    }

    private static OutputStreamWriter openFile() throws FileNotFoundException, UnsupportedEncodingException {
        BUGS_FILE.getParentFile().mkdirs();
        FileOutputStream file = new FileOutputStream(BUGS_FILE, true);
        return new OutputStreamWriter((OutputStream)file, ENCODING);
    }

    public BugLogger(Writer out) {
        this.out = new PrintWriter(out);
    }

    public void log(int id, TestCase test) {
        this.out.println(id + "\t" + test.getClass().getName() + "." + test.getName());
        this.out.flush();
    }

    public void close() {
        this.out.close();
    }
}

