/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.logging;

import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.XMLFormatter;

public class AgitarXMLFormatter
extends XMLFormatter {
    public String format(LogRecord record) {
        record.setMessage(this.escape(record));
        return super.format(record);
    }

    public String getHead(Handler h) {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\"");
        String encoding = "UTF-8";
        sb.append(" encoding=\"");
        sb.append(encoding);
        sb.append("\"");
        sb.append(" standalone=\"no\"?>\n");
        sb.append("<log>\n");
        return sb.toString();
    }

    private String escape(LogRecord record) {
        String before = record.getMessage();
        StringBuffer after = new StringBuffer(before.length());
        for (int i = 0; i < before.length(); ++i) {
            char ch = before.charAt(i);
            if (this.notAPrintableAscii(ch)) {
                after.append("0x");
                after.append(Integer.toHexString(ch));
                continue;
            }
            after.append(ch);
        }
        return after.toString();
    }

    private boolean notAPrintableAscii(char ch) {
        switch (ch) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return false;
            }
        }
        return ch < ' ' || ch >= '\u007f';
    }
}

