/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.logging;

import com.agitar.common.util.AgitarProperties;
import com.agitar.common.util.ExceptionUtility;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class AgitarPlainFormatter
extends Formatter {
    private boolean _onlyPrintableChar = AgitarProperties.LOG_SUPPRESS_MULTIBYTES;
    private static DateFormat dateFormatter = new SimpleDateFormat("HH:mm:ss:SSS");
    private static final int LOGNAME_OFFSET = "com.agitar.logging".length() + 1;

    public synchronized String format(LogRecord record) {
        StringBuffer header = new StringBuffer(48);
        header.append(this.pad('[' + record.getLevel().getLocalizedName() + ']', 10));
        header.append("[" + dateFormatter.format(new Date()) + "] ");
        header.append('<').append(record.getSequenceNumber()).append("> ");
        header.append(this.getLogName(record));
        header.append("  ");
        String formattedMsg = this.formatMessage(record);
        if (formattedMsg == null) {
            formattedMsg = "null";
        }
        StringBuffer msg = new StringBuffer(formattedMsg);
        Throwable t = record.getThrown();
        String lineSeparator = AgitarProperties.LINE_SEPARATOR;
        if (t != null) {
            if (!formattedMsg.endsWith(lineSeparator)) {
                msg.append(lineSeparator);
            }
            msg.append("<stacktrace> ");
            msg.append(ExceptionUtility.finiteTrace(t));
            if (AgitarProperties.PRINT_STACK_TRACE) {
                t.printStackTrace();
            }
        }
        String ret = msg.toString().replaceAll(lineSeparator, lineSeparator + header.toString());
        return header.append(ret).append(lineSeparator).toString();
    }

    private String getLogName(LogRecord rec) {
        String logger = rec.getLoggerName();
        if (logger.length() > LOGNAME_OFFSET) {
            logger = logger.substring(LOGNAME_OFFSET);
        }
        return logger;
    }

    private String pad(String s, int totalWidth) {
        int n = totalWidth - s.length();
        if (n <= 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer(totalWidth).append(s);
        for (int i = 0; i < n; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public synchronized String formatMessage(LogRecord record) {
        if (this._onlyPrintableChar) {
            String msg = record.getMessage();
            if (msg == null) {
                return "";
            }
            int n = msg.length();
            char[] sb = new char[n];
            for (int i = 0; i < n; ++i) {
                int c = msg.charAt(i);
                if (c > 127 || c < 9 || c > 13 && c <= 31) {
                    c = 63;
                }
                sb[i] = c;
            }
            return new String(sb);
        }
        return record.getMessage();
    }
}

