/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.logging;

import com.agitar.common.logging.AgitarConsoleFormatter;
import com.agitar.common.logging.AgitarLevel;
import com.agitar.common.logging.AgitarPlainFormatter;
import com.agitar.common.logging.DiagLogNotifyHandler;
import com.agitar.common.logging.DumpableLogManager;
import com.agitar.common.logging.LogOutputStream;
import com.agitar.common.util.AgitarProperties;
import com.agitar.common.util.EvilTwin;
import com.agitar.common.util.IOUtility;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public final class AgitarLogger {
    public static final String COM_AGITAR_LOGGING_MAXFILESIZE = "com.agitar.logging.maxfilesize";
    public static final String BASE_NAME = "com.agitar.logging";
    public static final String USERLOG = "userlog";
    public static final String DIAGNOSTIC = "diagnostic";
    public static final String DIAG_LOG = "com.agitar.logging.diagnostic";
    public static final String USER_LOG = "com.agitar.logging.userlog";
    private static final String LOG_PROPERTY = "aglog.";
    public static final Level DEF_FILE_LEVEL = AgitarLevel.INFO;
    public static final Level DEF_USER_LEVEL = AgitarLevel.INFO;
    public static final String DEFAULT_LOG_NAME = "AgitarLog";
    private static int _numOfLogs = 5;
    private static int _logsize = AgitarProperties.LOG_UNLIMITED_FILE ? 0 : 5000000;
    private static String _logname = null;
    private static FileHandler _rootLogFileHandler = null;
    private static ConsoleHandler _ch = new ConsoleHandler();
    private static final Logger _rootLog = DumpableLogManager.getBootstrappedAgitarLogger("com.agitar.logging", AgitarLogger.class);
    private static final Logger _diagLog = DumpableLogManager.getBootstrappedAgitarLogger("com.agitar.logging.diagnostic", AgitarLogger.class);
    private static final Logger _userLog = DumpableLogManager.getBootstrappedAgitarLogger("com.agitar.logging.userlog", AgitarLogger.class);
    private static final boolean OPLA_RUNNING = System.getProperty("OPLA") != null;
    private static final String _errStr = "Internal Error Setting up log";

    private static boolean isUnderJUnit() {
        StackTraceElement[] trace = new Exception().getStackTrace();
        if (trace == null) {
            return false;
        }
        for (int i = trace.length - 1; i >= 0; --i) {
            StackTraceElement element = trace[i];
            String className = element.getClassName();
            if (className.startsWith("junit")) {
                return true;
            }
            if (!className.startsWith("com.agitar")) continue;
            return false;
        }
        return false;
    }

    private static void importLogLevels() {
        Iterator propertyIterator = AgitarProperties.keyIterator();
        while (propertyIterator.hasNext()) {
            String key = (String)propertyIterator.next();
            if (!key.startsWith(LOG_PROPERTY)) continue;
            String logName = "com.agitar.logging." + key.substring(LOG_PROPERTY.length());
            Logger log = DumpableLogManager.getBootstrappedAgitarLogger(logName, class$com$agitar$common$logging$AgitarLogger == null ? AgitarLogger.class$("com.agitar.common.logging.AgitarLogger") : class$com$agitar$common$logging$AgitarLogger);
            Level level = AgitarLevel.getLevelByName(AgitarProperties.get(key));
            if (level == null) continue;
            log.setLevel(level);
        }
    }

    public static void setDiagLogFile(String fName) {
        AgitarLogger.setDiagLogFile(fName, false);
    }

    public static void setDiagLogFile(String fName, boolean fixlogFile) {
        fName = IOUtility.getCanonicalPath(fName);
        Level l = DEF_FILE_LEVEL;
        if (_rootLogFileHandler != null) {
            if (_logname != null && _logname.equals(fName)) {
                return;
            }
            l = _rootLogFileHandler.getLevel();
            AgitarLogger.closeDiagLogFile();
        }
        if ((_rootLogFileHandler = fixlogFile ? AgitarLogger._addLogFile(_rootLog, fName, l, null) : AgitarLogger._addLogFile(_rootLog, fName, l, "txt")) != null) {
            _logname = fName;
        }
    }

    public static void closeDiagLogFile() {
        if (_rootLogFileHandler != null) {
            _rootLogFileHandler.close();
            _rootLog.removeHandler(_rootLogFileHandler);
            _rootLogFileHandler = null;
            _logname = null;
        }
    }

    public static void setDefaultDiagLogFile(File logDir) {
        AgitarLogger.setDiagLogFile(AgitarLogger._getDefaultLogName(logDir));
    }

    public static void setUserLoggingLevel(Level l) {
        _ch.setLevel(l);
    }

    public static void setDiagnosticFileLoggingLevel(Level l) {
        if (EvilTwin.isMe() && !OPLA_RUNNING) {
            return;
        }
        if (_rootLogFileHandler == null) {
            throw new NullPointerException("Diagnostic File is not set: use AgitarLogger.setDiagLogFile(String) or AgitarLogger.setDefautDiagLogFile(Project) to set diagnostic file.");
        }
        _rootLogFileHandler.setLevel(l);
    }

    public static void setUserLoggingLevel(String level) {
        Level lev = AgitarLevel.getLevelByName(level);
        if (lev != null) {
            _ch.setLevel(lev);
        }
    }

    public static void setDiagnosticFileLoggingLevel(String level) {
        if (EvilTwin.isMe() && !OPLA_RUNNING) {
            return;
        }
        if (_rootLogFileHandler == null) {
            throw new NullPointerException("Diagnostic File is not set: use AgitarLogger.setDiagLogFile(String) or AgitarLogger.setDefautDiagLogFile(Project) to set diagnostic file.");
        }
        Level lev = AgitarLevel.getLevelByName(level);
        if (lev != null) {
            _rootLogFileHandler.setLevel(lev);
        }
    }

    public static Level getDiagnosticFileLoggingLevel() {
        if (_rootLogFileHandler != null) {
            return _rootLogFileHandler.getLevel();
        }
        return null;
    }

    public static Level getUserLoggingLevel() {
        return _ch.getLevel();
    }

    public static Handler getConsoleHandler() {
        return _ch;
    }

    public static String getRootLogFileName() {
        return _logname;
    }

    public static Logger getDiagnosticLogger() {
        return _diagLog;
    }

    public static Logger getUserLogger() {
        return _userLog;
    }

    public static Logger getRootLogger() {
        return _rootLog;
    }

    public static Logger getDiagnosticLogger(String name) {
        Logger ret = AgitarLogger._safeGetLogger("com.agitar.logging.diagnostic." + name);
        return ret == null ? _diagLog : ret;
    }

    public static Logger getUserLogger(String name) {
        Logger ret = AgitarLogger._safeGetLogger("com.agitar.logging.userlog." + name);
        return ret == null ? _userLog : ret;
    }

    private static Logger _safeGetLogger(String name) {
        try {
            return DumpableLogManager.getAgitarLogger(name);
        }
        catch (Exception tryAgain) {
            if (LogManager.getLogManager() == null) {
                DumpableLogManager.dump();
                try {
                    return DumpableLogManager.getAgitarLogger(name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private static FileHandler _addLogFile(Logger log, String logName, Level logLevel, String extension) {
        if (EvilTwin.isMe() && !OPLA_RUNNING) {
            return null;
        }
        if (logLevel == null) {
            logLevel = DEF_FILE_LEVEL;
        }
        try {
            File logFile = new File(logName);
            File p = logFile.getParentFile();
            if (p != null && !p.exists()) {
                p.mkdirs();
            }
            FileHandler f = extension != null ? new FileHandler(logName + ".%g." + extension, _logsize, _numOfLogs) : new FileHandler(logName, 0, 1);
            f.setLevel(logLevel);
            f.setFormatter(new AgitarPlainFormatter());
            log.addHandler(f);
            return f;
        }
        catch (IOException e) {
            _userLog.log(Level.SEVERE, _errStr, e);
            return null;
        }
    }

    public static void addLogFile(Logger log, File logDir, String logName, Level logLevel, String ext) {
        String logfile = new File(logDir, logName).getAbsolutePath();
        AgitarLogger._addLogFile(log, logfile, logLevel, ext);
    }

    public static void addLogFile(Logger log, File logDir, String logName, Level logLevel) {
        AgitarLogger.addLogFile(log, logDir, logName, logLevel, "txt");
    }

    public static void addLogFile(Logger log, String logName, Level logLevel) {
        AgitarLogger._addLogFile(log, logName, logLevel, "txt");
    }

    private static String _getDefaultLogName(File logDir) {
        return logDir + File.separator + DEFAULT_LOG_NAME;
    }

    public static void refreshConsoleStream() {
        _userLog.removeHandler(_ch);
        _ch = new ConsoleHandler();
        _ch.setFormatter(new AgitarConsoleFormatter());
        _userLog.addHandler(_ch);
    }

    public static OutputStream getUserLoggerAsOutputStream(String logName, Level lev) {
        return new LogOutputStream(AgitarLogger.getUserLogger(logName), lev);
    }

    public static OutputStream getDiagnosticLoggerAsOutputStream(String logName, Level lev) {
        return new LogOutputStream(AgitarLogger.getDiagnosticLogger(logName), lev);
    }

    public static void removeConsoleHandler() {
        _userLog.removeHandler(_ch);
    }

    public static void setLogsize(int logsize) {
        _logsize = logsize;
    }

    public static int getLogsize() {
        return _logsize;
    }

    public static void setNumOfLogs(int numOfLogs) {
        _numOfLogs = numOfLogs;
    }

    public static int getNumOfLogs() {
        return _numOfLogs;
    }

    static {
        _rootLog.setUseParentHandlers(false);
        _rootLog.setLevel(AgitarLevel.ALL);
        _userLog.setLevel(AgitarLevel.ALL);
        _diagLog.setLevel(AgitarLevel.ALL);
        _ch.setLevel(AgitarLevel.INFO);
        _ch.setFormatter(new AgitarConsoleFormatter(false, true));
        if (AgitarProperties.getBoolean("agitar.server.mode")) {
            try {
                _ch.setEncoding("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        _userLog.addHandler(_ch);
        _diagLog.addHandler(new DiagLogNotifyHandler());
        if (AgitarLogger.isUnderJUnit()) {
            ConsoleHandler dch = new ConsoleHandler();
            dch.setLevel(AgitarLevel.WARNING);
            _diagLog.addHandler(dch);
        }
        AgitarLogger.importLogLevels();
        String maxLogSize = System.getProperty(COM_AGITAR_LOGGING_MAXFILESIZE);
        if (maxLogSize != null) {
            try {
                int sz = Integer.parseInt(maxLogSize);
                if (sz > -1) {
                    _logsize = sz;
                }
            }
            catch (NumberFormatException nfe) {
                _userLog.warning("Trying to set an invalid max log file size: " + maxLogSize + "\n" + _logsize + " (bytes) used instead.");
            }
        }
        AgitarLogger.getUserLogger("xmlerrlog").setUseParentHandlers(false);
    }
}

