/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.logging;

import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class AgitarHTMLFormatter
extends Formatter {
    private void escape(StringBuffer sb, String text) {
        if (text == null) {
            text = "<null>";
        }
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '<') {
                sb.append("&lt;");
                continue;
            }
            if (ch == '>') {
                sb.append("&gt;");
                continue;
            }
            if (ch == '&') {
                sb.append("&amp;");
                continue;
            }
            sb.append(ch);
        }
    }

    public String format(LogRecord record) {
        StringBuffer sb = new StringBuffer(500);
        sb.append("<tr>");
        sb.append("<td class='seq'>");
        sb.append(record.getSequenceNumber());
        sb.append("</td>\n");
        String name = record.getLoggerName();
        sb.append("<td class='logger'>");
        this.escape(sb, name == null ? "(Unknown)" : name);
        sb.append("</td>\n");
        sb.append("<td class='level'>");
        this.escape(sb, record.getLevel().toString());
        sb.append("</td>\n");
        String message = this.formatMessage(record);
        sb.append("<td class='message'>");
        this.escape(sb, message);
        if (record.getThrown() != null) {
            Throwable th = record.getThrown();
            this.escape(sb, th.toString());
            StackTraceElement[] trace = th.getStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                StackTraceElement frame = trace[i];
                this.escape(sb, frame.getClassName());
                sb.append('.');
                this.escape(sb, frame.getMethodName());
                if (frame.getLineNumber() < 0) continue;
                sb.append(": ");
                sb.append(frame.getLineNumber());
            }
            sb.append("<br />");
        }
        sb.append("</td>\n");
        sb.append("</tr>\n");
        return sb.toString();
    }

    public String getHead(Handler h) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html><head>");
        sb.append("<title>Log</title>");
        sb.append("<style>");
        sb.append("td, th {border: thin solid black}");
        sb.append("th {background-color: #cccccc}");
        sb.append(".seq {background-color: #cccccc; text-align: right; width: 4em}");
        sb.append(".logger {background-color: #ccffcc; width: 20em}");
        sb.append(".level {background-color: #ccccff; width: 6em}");
        sb.append(".message {background-color: #ffffff}");
        sb.append("</style>");
        sb.append("</head><body><table cellspacing='0' cellpadding='2'>");
        sb.append("<tr><th>#</th><th>Logger</th><th>Level</th><th>Message</th></tr>");
        return sb.toString();
    }

    public String getTail(Handler h) {
        return "</table></body></html>\n";
    }
}

