/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.logging;

import com.agitar.common.logging.AgitarLevel;
import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.util.AgitarProperties;
import java.security.AccessController;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import sun.security.action.GetPropertyAction;

public class AgitarConsoleFormatter
extends Formatter {
    public static final int LEVEL_COLUMN = 10;
    private boolean _severeDetails = true;
    private boolean _onlyPrintableChar = AgitarProperties.LOG_SUPPRESS_MULTIBYTES;
    private static DateFormat dateFormatter = new SimpleDateFormat("HH:mm:ss:SSS");
    private String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    private boolean _includeDate;

    private String pad(String s) {
        String padded = s + "      ";
        return padded.substring(0, 10);
    }

    public AgitarConsoleFormatter() {
        this(true, true);
    }

    public AgitarConsoleFormatter(boolean severeDetails) {
        this(severeDetails, true);
    }

    public AgitarConsoleFormatter(boolean severeDetails, boolean includeDate) {
        this._severeDetails = severeDetails;
        this._includeDate = includeDate;
    }

    public synchronized String formatMessage(LogRecord record) {
        if (this._onlyPrintableChar) {
            String msg = record.getMessage();
            int n = msg != null ? msg.length() : 0;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                char c = msg.charAt(i);
                if (c > '\u007f' || c < '\t' || c > '\r' && c <= '\u001f') {
                    c = '?';
                }
                sb.append(c);
            }
            return sb.toString();
        }
        return record.getMessage();
    }

    public synchronized String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        String message = this.formatMessage(record);
        if (message == null) {
            message = "null";
        }
        String tag = this.pad("[" + record.getLevel().getLocalizedName() + "]");
        sb.append(tag);
        if (this._includeDate) {
            sb.append("[" + dateFormatter.format(new Date()) + "] ");
        }
        sb.append(message);
        if (this._severeDetails && (record.getLevel().equals(AgitarLevel.SEVERE) || record.getLevel().equals(AgitarLevel.WARNING) && record.getThrown() != null)) {
            sb.append(this.lineSeparator).append(tag);
            sb.append(this.getPointer(record));
        }
        sb.append(this.lineSeparator);
        return sb.toString();
    }

    private String getPointer(LogRecord record) {
        return "FILE: " + AgitarLogger.getRootLogFileName() + ", LOGGER: " + record.getLoggerName() + ", SEQUENCE: " + record.getSequenceNumber();
    }
}

