/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.logging;

import com.agitar.common.diagnostics.Diagnostics;
import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.types.ClassName;
import com.agitar.common.util.AgitarProperties;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

public class AgProcessTimer {
    public static final String MSG_START = "Timing: <START> ";
    public static final String MSG_END = "Timing: <END> ";
    public static final String MSG_NET = "Timing: <NET> ";
    public static final String MSG_MARK = "Timing: Step ";
    public static final String REFRESH_EVERYTHING = "Refresh Everything";
    public static final String SHOWING_FACTORIES = "Updating Factories";
    public static final String LAUNCHING = "Launch Agitator";
    public static final String RELOAD_AFTER_AGITATE = "Reload after Agitation";
    public static final String EXPAND_PKG = "Expand a Package";
    public static final String EXPAND_CLASS = "Expand a Class";
    public static final String OPENING_FAC_ASSIGNMENT = "Open Factory Assignment Dialog";
    public static final String LOADING_PROJECT = "Load Project";
    public static final String LOADING_CLASS = "Load Class Node";
    public static final String LOADING_PKG = "Load Package Node";
    public static final String INSTRUMENTATION = "Instrumentation";
    public static final String INSTR_CHECK = "Check";
    public static final String INSTR_PROCESS = "Process";
    public static final String CLASSLOADING = "Classloading";
    private static final Map nameToTimer = new HashMap();
    private long startTime;
    private long endTime;
    private long accumulatedTime;
    private int cycles;
    private int min = Integer.MAX_VALUE;
    private int max;
    private String nameOfProcess;
    private boolean started = false;
    private boolean showStartAndEnd;
    private int stepNum;
    private long stepTime;
    private Map subProcesses = new HashMap();

    public static final Logger getLogger() {
        return AgitarLogger.getDiagnosticLogger("timing");
    }

    public String getNameOfProcess() {
        return this.nameOfProcess;
    }

    public int getCycles() {
        return this.cycles;
    }

    public AgProcessTimer(boolean startAndEnd) {
        this.showStartAndEnd = startAndEnd;
        this.stepNum = 0;
    }

    private AgProcessTimer(String name, boolean startAndEnd) {
        this.showStartAndEnd = startAndEnd;
        this.stepNum = 0;
        this.nameOfProcess = name;
    }

    public static AgProcessTimer create(String name, boolean startAndEnd) {
        return AgitarProperties.DUMP_TIMES ? new AgProcessTimer(name, startAndEnd) : null;
    }

    public AgProcessTimer start() {
        this.started = true;
        this.stepTime = this.startTime = System.currentTimeMillis();
        this.endTime = System.currentTimeMillis();
        if (this.showStartAndEnd && AgitarProperties.DUMP_TIMES) {
            AgProcessTimer.getLogger().info(this.getStartMessage());
        }
        return this;
    }

    public static void start(AgProcessTimer timer) {
        if (timer != null) {
            timer.start();
        }
    }

    public static void stop(AgProcessTimer timer) {
        if (timer != null) {
            timer.stop();
        }
    }

    public static void log(AgProcessTimer timer) {
        if (timer != null) {
            timer.log();
        }
    }

    public static void cache(AgProcessTimer timer) {
        if (timer != null) {
            nameToTimer.put(timer.nameOfProcess, timer);
        }
    }

    public void cache() {
        AgProcessTimer.cache(this);
    }

    public static void removeFromCache(AgProcessTimer timer) {
        if (timer != null) {
            nameToTimer.remove(timer.nameOfProcess);
        }
    }

    public void removeFromCache() {
        AgProcessTimer.removeFromCache(this);
    }

    public static AgProcessTimer get(String name, boolean startAndEnd) {
        if (AgitarProperties.DUMP_TIMES) {
            AgProcessTimer timer = (AgProcessTimer)nameToTimer.get(name);
            if (timer == null) {
                timer = AgProcessTimer.create(name, startAndEnd);
                AgProcessTimer.cache(timer);
            }
            return timer;
        }
        return null;
    }

    public void start(String nameOfProcess) {
        if (this.started) {
            this.markProcess(nameOfProcess);
        } else {
            this.nameOfProcess = nameOfProcess;
            this.start();
        }
    }

    public AgProcessTimer createSubProcess(String name) {
        String subName = this.nameOfProcess + "." + name;
        AgProcessTimer subProcess = (AgProcessTimer)this.subProcesses.get(subName);
        if (subProcess == null) {
            subProcess = new AgProcessTimer(subName, this.showStartAndEnd);
            this.subProcesses.put(subName, subProcess);
        }
        return subProcess;
    }

    public void markProcess(String interimMsg) {
        if (!this.started && AgitarProperties.DUMP_TIMES) {
            AgProcessTimer.getLogger().info("Cannot mark process when nothing is running: " + interimMsg);
        }
        ++this.stepNum;
        if (AgitarProperties.DUMP_TIMES) {
            long currTime = System.currentTimeMillis();
            long diff = currTime - this.stepTime;
            AgProcessTimer.getLogger().info(this.getMarkMessage(interimMsg, diff));
            this.stepTime = currTime;
        }
    }

    private String getMarkMessage(String interimMsg, long diff) {
        StringBuffer buff = new StringBuffer(MSG_MARK);
        buff.append("#");
        buff.append(this.stepNum);
        buff.append(": ");
        buff.append(interimMsg);
        buff.append(" of ");
        buff.append(this.nameOfProcess);
        buff.append(". Took ");
        buff.append(diff);
        buff.append(" (ms)");
        return buff.toString();
    }

    public AgProcessTimer stop() {
        if (this.started) {
            this.endTime = System.currentTimeMillis();
            int cycleTime = (int)(this.endTime - this.startTime);
            this.accumulatedTime += (long)cycleTime;
            this.min = Math.min(cycleTime, this.min);
            this.max = Math.max(cycleTime, this.max);
            if (AgitarProperties.DUMP_TIMES && this.showStartAndEnd) {
                AgProcessTimer.getLogger().info(this.getEndMessage());
            }
            this.started = false;
            ++this.cycles;
        }
        return this;
    }

    public void log() {
        this.logDiagnostics();
        if (AgitarProperties.DUMP_TIMES && this.accumulatedTime >= (long)AgitarProperties.DUMP_TIMES_THRESHOLD) {
            AgProcessTimer.getLogger().info(this.getNetMessage());
            if (!this.subProcesses.isEmpty()) {
                long subProcessTotal = 0L;
                Iterator iter = this.subProcesses.values().iterator();
                while (iter.hasNext()) {
                    AgProcessTimer subProcess = (AgProcessTimer)iter.next();
                    subProcessTotal += subProcess.getNetTime();
                    subProcess.log();
                }
                AgProcessTimer.getLogger().info(this.getSubtotalMessage(subProcessTotal));
            }
        }
    }

    private void logDiagnostics() {
        if (this.accumulatedTime >= 10L) {
            ClassName className;
            String process;
            int colon;
            int n = colon = this.nameOfProcess == null ? -1 : this.nameOfProcess.indexOf(58);
            if (colon > 0) {
                process = this.nameOfProcess.substring(0, colon);
                try {
                    className = ClassName.get(this.nameOfProcess.substring(colon + 1));
                }
                catch (IllegalArgumentException ex) {
                    className = null;
                }
            } else {
                process = this.nameOfProcess;
                className = null;
            }
            Diagnostics.getKey("timer." + process + ".total").set(className, (double)this.accumulatedTime);
            if (this.cycles > 1) {
                double avg = (double)this.accumulatedTime / (double)this.cycles;
                Diagnostics.getKey("timer." + process + ".min").set(className, (double)this.min);
                Diagnostics.getKey("timer." + process + ".max").set(className, (double)this.max);
                Diagnostics.getKey("timer." + process + ".avg").set(className, avg);
            }
            if (!this.subProcesses.isEmpty()) {
                Iterator iter = this.subProcesses.values().iterator();
                while (iter.hasNext()) {
                    AgProcessTimer subProcess = (AgProcessTimer)iter.next();
                    subProcess.logDiagnostics();
                }
            }
        }
    }

    public static void logAndReset(AgProcessTimer timer) {
        if (timer != null) {
            timer.log();
            timer.reset();
        }
    }

    public void reset() {
        this.startTime = 0L;
        this.endTime = 0L;
        this.accumulatedTime = 0L;
        this.cycles = 0;
        this.min = Integer.MAX_VALUE;
        this.max = 0;
        this.started = false;
        this.stepNum = 0;
        this.stepTime = 0L;
    }

    public void stopAndLog() {
        this.stop();
        this.log();
    }

    public long getNetTime() {
        return this.accumulatedTime;
    }

    private String getEndTime() {
        try {
            return DateFormat.getTimeInstance(0).format(new Date(this.endTime)).toString();
        }
        catch (Exception e) {
            return "" + this.endTime;
        }
    }

    private String getStartTime() {
        try {
            return DateFormat.getTimeInstance(0).format(new Date(this.startTime)).toString();
        }
        catch (Exception e) {
            return "" + this.startTime;
        }
    }

    private String getEndMessage() {
        StringBuffer buff = new StringBuffer(MSG_END);
        buff.append(this.nameOfProcess);
        buff.append(" ");
        buff.append(this.getEndTime());
        return buff.toString();
    }

    private String getStartMessage() {
        StringBuffer buff = new StringBuffer(MSG_START);
        buff.append(this.nameOfProcess);
        buff.append(" ");
        buff.append(this.getStartTime());
        return buff.toString();
    }

    private String getNetMessage() {
        StringBuffer buff = new StringBuffer(MSG_NET);
        buff.append(this.nameOfProcess);
        buff.append(" ");
        buff.append(this.getNetTime());
        buff.append(" (ms)");
        if (this.cycles > 1) {
            double avg = (double)this.accumulatedTime / (double)this.cycles;
            buff.append(" in ").append(this.cycles).append(" segments: min=").append(this.min);
            buff.append(" max=").append(this.max).append(" avg=").append(avg);
        }
        return buff.toString();
    }

    private String getSubtotalMessage(long time) {
        StringBuffer buff = new StringBuffer(MSG_NET);
        buff.append(this.nameOfProcess);
        buff.append(" subprocess total ");
        buff.append(time);
        buff.append(" (ms)");
        return buff.toString();
    }
}

