/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.diagnostics;

import com.agitar.common.diagnostics.Diagnostic;
import com.agitar.common.diagnostics.ErrorDiagnostic;
import com.agitar.common.types.ClassName;
import com.agitar.common.util.StringEscape;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestDiagnostic
implements Diagnostic {
    public static final String TYPE = "test";
    private static final String SOURCE_ELEMENT_NAME = "source";
    private static final String REASON_ATTR = "reason";
    private static final String MOCK_LEVEL_ATTR = "mocklevel";
    private static final String OPERATION_ATTR = "operation";
    private static final String COVERAGE_ATTR = "coverage";
    private static final String OUTCOME_ATTR = "outcome";
    private ClassName outcome = ClassName.get("Unknown");
    private String sourceCode;
    private String failingReason;
    private ErrorDiagnostic failingCause;
    private String failingOperation;
    private String coverage;
    private int mockLevel;

    public String toString() {
        return this.outcome.getNameWithoutPackage() + ": " + this.failingReason;
    }

    public Element toElement(Document doc) {
        Element element = doc.createElement("diagnostic");
        element.setAttribute("type", TYPE);
        element.setAttribute("string", TestDiagnostic.encode(this.toString()));
        element.setAttribute(MOCK_LEVEL_ATTR, Integer.toString(this.mockLevel));
        if (this.sourceCode != null) {
            Element sourceElement = doc.createElement(SOURCE_ELEMENT_NAME);
            sourceElement.appendChild(doc.createTextNode(TestDiagnostic.encode(this.sourceCode)));
            element.appendChild(sourceElement);
        }
        if (this.failingReason != null) {
            element.setAttribute(REASON_ATTR, TestDiagnostic.encode(this.failingReason));
        }
        if (this.failingOperation != null) {
            element.setAttribute(OPERATION_ATTR, TestDiagnostic.encode(this.failingOperation));
        }
        if (this.coverage != null) {
            element.setAttribute(COVERAGE_ATTR, TestDiagnostic.encode(this.coverage));
        }
        if (this.outcome != null) {
            element.setAttribute(OUTCOME_ATTR, TestDiagnostic.encode(this.outcome.toString()));
        }
        if (this.failingCause != null) {
            element.appendChild(this.failingCause.toElement(doc));
        }
        return element;
    }

    public static TestDiagnostic parseElement(Element element) {
        NodeList causeChildren;
        TestDiagnostic diagnostic = new TestDiagnostic();
        try {
            diagnostic.setMockLevel(Integer.parseInt(element.getAttribute(MOCK_LEVEL_ATTR)));
        }
        catch (Exception e) {
            diagnostic.setMockLevel(0);
        }
        NodeList sourceChildren = element.getElementsByTagName(SOURCE_ELEMENT_NAME);
        if (sourceChildren != null && sourceChildren.getLength() > 0) {
            Node text = ((Element)sourceChildren.item(0)).getFirstChild();
            diagnostic.setSourceCode(text.getNodeValue());
        }
        diagnostic.setFailingReason(element.getAttribute(REASON_ATTR));
        diagnostic.setFailingOperation(element.getAttribute(OPERATION_ATTR));
        diagnostic.setCoverage(element.getAttribute(COVERAGE_ATTR));
        if (element.getAttribute(OUTCOME_ATTR).length() > 0) {
            diagnostic.setOutcome(ClassName.get(element.getAttribute(OUTCOME_ATTR)));
        }
        if ((causeChildren = element.getElementsByTagName("diagnostic")) != null && causeChildren.getLength() > 0) {
            diagnostic.setFailingCause(ErrorDiagnostic.parseElement((Element)causeChildren.item(0)));
        }
        return diagnostic;
    }

    private static String encode(String string) {
        return StringEscape.encodeUndefinedUnicodeChar(string);
    }

    public List toList() {
        return Collections.singletonList(this);
    }

    public double toNumber() {
        return Double.NaN;
    }

    public String getCoverage() {
        return this.coverage;
    }

    public void setCoverage(String coverage) {
        this.coverage = coverage;
    }

    public ErrorDiagnostic getFailingCause() {
        return this.failingCause;
    }

    public void setFailingCause(ErrorDiagnostic failingCause) {
        this.failingCause = failingCause;
    }

    public String getFailingOperation() {
        return this.failingOperation;
    }

    public void setFailingOperation(String failingOperation) {
        this.failingOperation = failingOperation;
    }

    public String getFailingReason() {
        return this.failingReason;
    }

    public void setFailingReason(String failingReason) {
        this.failingReason = failingReason;
    }

    public int getMockLevel() {
        return this.mockLevel;
    }

    public void setMockLevel(int mockLevel) {
        this.mockLevel = mockLevel;
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public ClassName getOutcome() {
        return this.outcome;
    }

    public void setOutcome(ClassName outcome) {
        this.outcome = outcome;
    }

    public boolean isPlural() {
        return false;
    }
}

