/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.diagnostics;

import com.agitar.common.diagnostics.Diagnostic;
import com.agitar.common.util.StringEscape;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StringDiagnostic
implements Diagnostic {
    public static final String TYPE = "string";
    private final String value;

    public StringDiagnostic(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public double toNumber() {
        return 0.0;
    }

    public List toList() {
        return Collections.singletonList(this);
    }

    public Element toElement(Document doc) {
        Element element = doc.createElement("diagnostic");
        element.setAttribute("type", TYPE);
        element.setAttribute(TYPE, StringEscape.encodeUndefinedUnicodeChar(this.value));
        return element;
    }

    public static Diagnostic parseElement(Element element) {
        return new StringDiagnostic(element.getAttribute(TYPE));
    }

    public boolean isPlural() {
        return false;
    }
}

