/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.diagnostics;

import com.agitar.common.diagnostics.Diagnostic;
import com.agitar.common.diagnostics.DiagnosticResources;
import com.agitar.common.types.ClassName;
import com.agitar.common.types.MethodSignature;
import java.util.ArrayList;
import java.util.List;

public class Solution {
    public static final int HIGHLY_RECOMMENDED = 3;
    public static final int RECOMMENDED = 2;
    public static final int SUGGESTED = 1;
    private final int rating;
    private final String messageKey;
    private final ClassName className;
    private final MethodSignature methodSignature;
    private final List diagnostics = new ArrayList();

    public Solution(int rating, String messageKey, Diagnostic diagnostic) {
        if (messageKey == null) {
            throw new NullPointerException();
        }
        this.rating = rating;
        this.messageKey = messageKey;
        this.addDiagnostic(diagnostic);
        this.className = null;
        this.methodSignature = null;
    }

    public Solution(int rating, String messageKey, ClassName className, Diagnostic diagnostic) {
        if (messageKey == null) {
            throw new NullPointerException();
        }
        this.rating = rating;
        this.messageKey = messageKey;
        this.addDiagnostic(diagnostic);
        this.className = className;
        this.methodSignature = null;
    }

    public Solution(int rating, String messageKey, MethodSignature methodSignature, Diagnostic diagnostic) {
        if (messageKey == null) {
            throw new NullPointerException();
        }
        this.rating = rating;
        this.messageKey = messageKey;
        this.addDiagnostic(diagnostic);
        this.className = methodSignature.getClassName();
        this.methodSignature = methodSignature;
    }

    public void addDiagnostic(Diagnostic diagnostic) {
        if (diagnostic != null) {
            this.diagnostics.add(diagnostic);
        }
    }

    public int getRating() {
        return this.rating;
    }

    public Diagnostic[] getDiagnostics() {
        return this.diagnostics.toArray(new Diagnostic[this.diagnostics.size()]);
    }

    public String getMessage() {
        return DiagnosticResources.getResource(this.messageKey, this.methodSignature, this.className, this.diagnostics);
    }

    public ClassName getClassName() {
        return this.className;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public MethodSignature getMethodSignature() {
        return this.methodSignature;
    }
}

