/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.diagnostics;

import com.agitar.common.diagnostics.Diagnostic;
import com.agitar.common.diagnostics.DiagnosticResources;
import com.agitar.common.diagnostics.Solution;
import com.agitar.common.types.ClassName;
import com.agitar.common.types.MethodSignature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Problem {
    public static final int CRITICAL = 900;
    public static final int SEVERE = 700;
    public static final int SERIOUS = 500;
    public static final int MODERATE = 300;
    public static final int MINOR = 100;
    private final int id;
    private final int priority;
    private final String messageKey;
    private final List diagnostics = new ArrayList();
    private MethodSignature methodSignature;
    private ClassName className;
    private final List solutions = new ArrayList();
    private static int masterID;
    public static final Comparator COMPARE_BY_PRIORITY;

    public Problem(int priority, String messageKey, Diagnostic diagnostic) {
        if (messageKey == null) {
            throw new NullPointerException();
        }
        this.id = ++masterID;
        this.priority = priority;
        this.messageKey = messageKey;
        this.addDiagnostic(diagnostic);
    }

    public Problem(int priority, String messageKey, ClassName className, Diagnostic diagnostic) {
        this(priority, messageKey, diagnostic);
        this.className = className;
    }

    public Problem(int priority, String messageKey, MethodSignature methodSignature, Diagnostic diagnostic) {
        this(priority, messageKey, diagnostic);
        this.className = methodSignature.getClassName();
        this.methodSignature = methodSignature;
    }

    public void addDiagnostic(Diagnostic diagnostic) {
        if (diagnostic != null) {
            this.diagnostics.add(diagnostic);
        }
    }

    public void addSolution(Solution solution) {
        this.solutions.add(solution);
    }

    public List getSolutions() {
        return Collections.unmodifiableList(this.solutions);
    }

    public int getID() {
        return this.id;
    }

    public int getPriority() {
        return this.priority;
    }

    public Diagnostic[] getDiagnostics() {
        return this.diagnostics.toArray(new Diagnostic[this.diagnostics.size()]);
    }

    public String getMessage() {
        return DiagnosticResources.getResource(this.messageKey, this.methodSignature, this.className, this.diagnostics);
    }

    public ClassName getClassName() {
        return this.className;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public MethodSignature getMethodSignature() {
        return this.methodSignature;
    }

    static {
        COMPARE_BY_PRIORITY = new Comparator(){

            public int compare(Object o1, Object o2) {
                Problem p1 = (Problem)o1;
                Problem p2 = (Problem)o2;
                return p2.getPriority() - p1.getPriority();
            }
        };
    }
}

