/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.diagnostics;

import com.agitar.common.diagnostics.Diagnostic;
import com.agitar.common.diagnostics.StringDiagnostic;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NumberDiagnostic
implements Diagnostic {
    public static final String TYPE = "number";
    private static final NumberFormat FORMAT = new DecimalFormat("#.##");
    private final double value;

    public NumberDiagnostic(double value) {
        this.value = value;
    }

    public String toString() {
        return FORMAT.format(this.value);
    }

    public double toNumber() {
        return this.value;
    }

    public List toList() {
        return Collections.singletonList(this);
    }

    public Element toElement(Document doc) {
        Element element = doc.createElement("diagnostic");
        element.setAttribute("type", TYPE);
        element.setAttribute(TYPE, String.valueOf(this.toNumber()));
        element.setAttribute("string", this.toString());
        return element;
    }

    public static Diagnostic parseElement(Element element) {
        try {
            return new NumberDiagnostic(Double.parseDouble(element.getAttribute(TYPE)));
        }
        catch (Exception e) {
            return new StringDiagnostic("Unparseable number: " + element.getAttribute(TYPE));
        }
    }

    public boolean isPlural() {
        return this.value >= 2.0;
    }
}

