/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.diagnostics;

import com.agitar.common.diagnostics.Diagnostic;
import com.agitar.common.diagnostics.DiagnosticResources;
import com.agitar.common.diagnostics.Diagnostics;
import com.agitar.common.logging.AgitarLevel;
import com.agitar.common.logging.AgitarLogger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class ListDiagnostic
implements Diagnostic {
    public static final String TYPE = "list";
    private final List diagnostics = new ArrayList();

    ListDiagnostic() {
    }

    public void add(Diagnostic diagnostic) {
        if (diagnostic != null) {
            this.diagnostics.add(diagnostic);
        } else {
            AgitarLogger.getDiagnosticLogger("ListDiagnostic").log(AgitarLevel.WARNING, "null entry added", new Exception());
        }
    }

    public String toString() {
        switch (this.diagnostics.size()) {
            case 0: {
                return DiagnosticResources.getResource("list.zero");
            }
            case 1: {
                return MessageFormat.format(DiagnosticResources.getResource("list.one"), this.diagnostics.get(0));
            }
            case 2: {
                return MessageFormat.format(DiagnosticResources.getResource("list.two"), this.diagnostics.get(0), this.diagnostics.get(1));
            }
            case 3: {
                return MessageFormat.format(DiagnosticResources.getResource("list.three"), this.diagnostics.get(0), this.diagnostics.get(1), this.diagnostics.get(2));
            }
        }
        return MessageFormat.format(DiagnosticResources.getResource("list.many"), this.diagnostics.get(0), this.diagnostics.get(1), this.diagnostics.get(2));
    }

    public double toNumber() {
        return this.diagnostics.size();
    }

    public List toList() {
        return this.diagnostics;
    }

    public Element toElement(Document doc) {
        Element element = doc.createElement("diagnostic");
        element.setAttribute("type", TYPE);
        Iterator iter = this.diagnostics.iterator();
        while (iter.hasNext()) {
            Diagnostic d = (Diagnostic)iter.next();
            element.appendChild(d.toElement(doc));
        }
        return element;
    }

    public static Diagnostic parseElement(Element element) {
        ListDiagnostic list = new ListDiagnostic();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element child = (Element)children.item(i);
            list.add(Diagnostics.parseElement(child));
        }
        return list;
    }

    public boolean isPlural() {
        return this.diagnostics.size() != 1;
    }
}

