/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.diagnostics;

import com.agitar.common.diagnostics.Diagnostic;
import com.agitar.common.diagnostics.StringDiagnostic;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FractionDiagnostic
implements Diagnostic {
    public static final String TYPE = "fraction";
    private static final NumberFormat FORMAT = new DecimalFormat("###.##%");
    private final int numerator;
    private final int denominator;

    public FractionDiagnostic(int numerator, int denominator) {
        if (numerator < 0 || denominator < 0 || numerator > denominator) {
            throw new IllegalArgumentException(numerator + " " + denominator);
        }
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public String toString() {
        return this.numerator + "/" + this.denominator + " (" + FORMAT.format(this.toNumber()) + ")";
    }

    public double toNumber() {
        return this.denominator == 0 ? 0.0 : (double)this.numerator / (double)this.denominator;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public List toList() {
        return Collections.singletonList(this);
    }

    public Element toElement(Document doc) {
        Element element = doc.createElement("diagnostic");
        element.setAttribute("type", TYPE);
        element.setAttribute("numerator", String.valueOf(this.numerator));
        element.setAttribute("denominator", String.valueOf(this.denominator));
        element.setAttribute("number", String.valueOf(this.toNumber()));
        element.setAttribute("string", this.toString());
        return element;
    }

    public static Diagnostic parseElement(Element element) {
        String ns = element.getAttribute("numerator");
        String ds = element.getAttribute("denominator");
        try {
            int ni = Integer.parseInt(ns);
            int di = Integer.parseInt(ds);
            return new FractionDiagnostic(ni, di);
        }
        catch (Exception e) {
            return new StringDiagnostic("Unparseable fraction: " + ns + "/" + ds);
        }
    }

    public boolean isPlural() {
        return false;
    }
}

