/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.diagnostics;

import com.agitar.common.diagnostics.Diagnostic;
import com.agitar.common.types.ClassName;
import com.agitar.common.util.StringEscape;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ErrorDiagnostic
implements Diagnostic {
    public static final String TYPE = "error";
    private static final String EXCEPTION_MESSAGE_ATTR = "exception-message";
    private static final String EXCEPTION_CLASS_ATTR = "exception-class";
    private static final String LOG_MESSAGE_ATTR = "log-message";
    private static final String TRACE_ELEMENT = "trace";
    private static final String TRACE_CLASS_ATTR = "class";
    private static final String TRACE_METHOD_ATTR = "method";
    private static final String TRACE_LINE_ATTR = "line";
    private final String logMessage;
    private final ClassName exceptionClass;
    private final String exceptionMessage;
    private final TraceElement[] trace;
    private final ErrorDiagnostic cause;

    public ErrorDiagnostic(String logMessage) {
        this(logMessage, (Throwable)null);
    }

    public ErrorDiagnostic(String logMessage, Throwable value) {
        this.logMessage = logMessage;
        if (value == null) {
            this.exceptionClass = null;
            this.exceptionMessage = null;
            this.trace = new TraceElement[0];
            this.cause = null;
        } else {
            this.exceptionClass = ClassName.get(value.getClass());
            this.exceptionMessage = value.getLocalizedMessage();
            this.trace = ErrorDiagnostic.convertTrace(value.getStackTrace());
            this.cause = value.getCause() == null ? null : new ErrorDiagnostic(null, value.getCause());
        }
    }

    public ErrorDiagnostic(String logMessage, StackTraceElement[] stackTrace) {
        this.logMessage = logMessage;
        if (stackTrace == null) {
            this.exceptionClass = null;
            this.trace = new TraceElement[0];
        } else {
            this.exceptionClass = ClassName.get("StackTrace");
            this.trace = ErrorDiagnostic.convertTrace(stackTrace);
        }
        this.exceptionMessage = null;
        this.cause = null;
    }

    private static TraceElement[] convertTrace(StackTraceElement[] stackTrace) {
        if (stackTrace != null) {
            TraceElement[] trace = new TraceElement[stackTrace.length];
            for (int i = 0; i < trace.length; ++i) {
                StackTraceElement element = stackTrace[i];
                trace[i] = new TraceElement(element.getClassName(), element.getMethodName(), element.getLineNumber());
            }
            return trace;
        }
        return new TraceElement[0];
    }

    private ErrorDiagnostic(String logMessage, String exceptionClass, String exceptionMessage, TraceElement[] trace, ErrorDiagnostic cause) {
        this.logMessage = logMessage;
        this.exceptionClass = exceptionClass == null ? null : ClassName.get(exceptionClass);
        this.exceptionMessage = exceptionMessage;
        this.trace = trace;
        this.cause = cause;
    }

    public String toString() {
        if (this.exceptionClass != null) {
            StringBuffer buf = new StringBuffer();
            if (this.logMessage != null) {
                buf.append(this.logMessage).append(" (");
            }
            buf.append(this.exceptionClass.getNameWithoutPackage());
            if (this.exceptionMessage != null) {
                buf.append(": \"").append(this.exceptionMessage).append('\"');
            }
            if (this.trace != null && this.trace.length >= 1) {
                buf.append(" at ").append(this.trace[0]);
                if (this.trace.length >= 2) {
                    buf.append(" at ").append(this.trace[1]);
                }
            }
            if (this.cause != null) {
                buf.append(", caused by ").append(this.cause);
            }
            if (this.logMessage != null) {
                buf.append(")");
            }
            return buf.toString();
        }
        if (this.logMessage != null) {
            return this.logMessage;
        }
        return "(Unknown Exception)";
    }

    public double toNumber() {
        return Double.NaN;
    }

    public List toList() {
        return Collections.singletonList(this);
    }

    public Element toElement(Document doc) {
        Element element = doc.createElement("diagnostic");
        element.setAttribute("type", TYPE);
        if (this.logMessage != null) {
            element.setAttribute(LOG_MESSAGE_ATTR, StringEscape.encodeUndefinedUnicodeChar(this.logMessage));
        }
        if (this.exceptionClass != null) {
            element.setAttribute(EXCEPTION_CLASS_ATTR, StringEscape.encodeUndefinedUnicodeChar(this.exceptionClass.getName()));
            if (this.exceptionMessage != null) {
                element.setAttribute(EXCEPTION_MESSAGE_ATTR, StringEscape.encodeUndefinedUnicodeChar(this.exceptionMessage));
            }
        }
        for (int i = 0; i < this.trace.length; ++i) {
            Element traceElement = doc.createElement(TRACE_ELEMENT);
            if (this.trace[i].className != null) {
                traceElement.setAttribute(TRACE_CLASS_ATTR, this.trace[i].className.getName());
            }
            if (this.trace[i].methodName != null) {
                traceElement.setAttribute(TRACE_METHOD_ATTR, this.trace[i].methodName);
            }
            if (this.trace[i].lineNumber > 0) {
                traceElement.setAttribute(TRACE_LINE_ATTR, String.valueOf(this.trace[i].lineNumber));
            }
            element.appendChild(traceElement);
        }
        element.setAttribute("string", StringEscape.encodeUndefinedUnicodeChar(this.toString()));
        if (this.cause != null) {
            element.appendChild(this.cause.toElement(doc));
        }
        return element;
    }

    public static ErrorDiagnostic parseElement(Element element) {
        TraceElement[] trace;
        NodeList children = element.getElementsByTagName("diagnostic");
        ErrorDiagnostic cause = children != null && children.getLength() > 0 ? ErrorDiagnostic.parseElement((Element)children.item(0)) : null;
        NodeList traceChildren = element.getElementsByTagName(TRACE_ELEMENT);
        if (traceChildren != null) {
            trace = new TraceElement[traceChildren.getLength()];
            for (int i = 0; i < trace.length; ++i) {
                Element traceElement = (Element)traceChildren.item(i);
                String className = ErrorDiagnostic.parseStringAttribute(traceElement.getAttribute(TRACE_CLASS_ATTR));
                String methodName = ErrorDiagnostic.parseStringAttribute(traceElement.getAttribute(TRACE_METHOD_ATTR));
                int lineNumber = ErrorDiagnostic.parseIntAttribute(traceElement.getAttribute(TRACE_LINE_ATTR));
                trace[i] = new TraceElement(className, methodName, lineNumber);
            }
        } else {
            trace = new TraceElement[]{};
        }
        return new ErrorDiagnostic(ErrorDiagnostic.parseStringAttribute(element.getAttribute(LOG_MESSAGE_ATTR)), ErrorDiagnostic.parseStringAttribute(element.getAttribute(EXCEPTION_CLASS_ATTR)), ErrorDiagnostic.parseStringAttribute(element.getAttribute(EXCEPTION_MESSAGE_ATTR)), trace, cause);
    }

    private static String parseStringAttribute(String s) {
        return s == null || s.length() == 0 ? null : s;
    }

    private static int parseIntAttribute(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public ErrorDiagnostic getCause() {
        return this.cause;
    }

    public ClassName getExceptionClass() {
        return this.exceptionClass;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public String getLogMessage() {
        return this.logMessage;
    }

    public TraceElement[] getTrace() {
        return this.trace;
    }

    public boolean isPlural() {
        return false;
    }

    public static class TraceElement {
        public final ClassName className;
        public final String methodName;
        public final int lineNumber;

        public TraceElement(String className, String methodName, int lineNumber) {
            this.className = ClassName.get(className);
            this.methodName = methodName;
            this.lineNumber = lineNumber;
        }

        public String toString() {
            if (this.lineNumber > 0) {
                return this.className.getNameWithoutPackage() + '.' + this.methodName + "() line " + this.lineNumber;
            }
            return this.className.getNameWithoutPackage() + '.' + this.methodName + "()";
        }
    }
}

