/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.diagnostics;

import com.agitar.common.diagnostics.Diagnostic;
import com.agitar.common.diagnostics.Diagnostics;
import com.agitar.common.diagnostics.DiagnosticsMap;
import com.agitar.common.diagnostics.Problem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DiagnosticsReport {
    private final List problems;
    private final String html;
    private final int maxPriority;
    private final DiagnosticsMap diagnostics;

    public DiagnosticsReport(Collection problems, String html, DiagnosticsMap diagnostics) {
        this.problems = new ArrayList(problems);
        this.html = html;
        this.diagnostics = diagnostics;
        if (problems.isEmpty()) {
            this.maxPriority = 0;
        } else {
            Collections.sort(this.problems, Problem.COMPARE_BY_PRIORITY);
            Problem first = (Problem)this.problems.get(0);
            this.maxPriority = first.getPriority();
        }
    }

    public String getHtml() {
        return this.html;
    }

    public List getProblems(int maxCount, int minPriority) {
        if (minPriority <= 0 && maxCount >= this.problems.size()) {
            return this.problems;
        }
        if (minPriority <= 0) {
            return this.problems.subList(0, maxCount);
        }
        ArrayList<Problem> result = new ArrayList<Problem>();
        Iterator iter = this.problems.iterator();
        while (iter.hasNext() && result.size() < maxCount) {
            Problem problem = (Problem)iter.next();
            if (problem.getPriority() < minPriority) continue;
            result.add(problem);
        }
        return result;
    }

    public Diagnostics getKey(String key) {
        return this.diagnostics.getKey(key);
    }

    public DiagnosticsMap getDiagnostics() {
        return this.diagnostics;
    }

    public int getMaxPriority() {
        return this.maxPriority;
    }

    public String getUserLog() {
        Diagnostic log = this.getKey("log.user").get();
        if (log == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        List messages = log.toList();
        Iterator iter = messages.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next().toString());
        }
        return buf.toString();
    }
}

