/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.diagnostics;

import com.agitar.common.diagnostics.Diagnostic;
import com.agitar.common.diagnostics.DiagnosticGeneralLookupKey;
import com.agitar.common.diagnostics.DiagnosticKey;
import com.agitar.common.diagnostics.DiagnosticLookupKey;
import com.agitar.common.diagnostics.DiagnosticMethodLookupKey;
import com.agitar.common.diagnostics.Diagnostics;
import com.agitar.common.types.ClassName;
import com.agitar.common.types.MethodSignature;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DiagnosticsMap {
    private final Map values = new HashMap();

    public Diagnostics getKey(String key) {
        return new Diagnostics(key, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(DiagnosticKey key, Diagnostic value) {
        Map map = this.values;
        synchronized (map) {
            this.values.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Diagnostic get(DiagnosticKey key) {
        Map map = this.values;
        synchronized (map) {
            return (Diagnostic)this.values.get(key);
        }
    }

    public Map getAll() {
        return Collections.unmodifiableMap(this.values);
    }

    public Map getAll(String name) {
        return this.getMatches(new DiagnosticGeneralLookupKey(name));
    }

    public Map getAll(ClassName className) {
        return this.getMatches(new DiagnosticGeneralLookupKey(className));
    }

    public Map getAllMethodsIn(String name, ClassName className) {
        return this.getMatches(new DiagnosticMethodLookupKey(name, className));
    }

    public Map getAll(MethodSignature methodSignature) {
        return this.getMatches(new DiagnosticGeneralLookupKey(methodSignature));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getMatches(DiagnosticLookupKey lookup) {
        HashMap matches = new HashMap();
        Map map = this.values;
        synchronized (map) {
            Iterator iter = this.values.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                DiagnosticKey key = (DiagnosticKey)entry.getKey();
                if (!lookup.matches(key)) continue;
                matches.put(key, entry.getValue());
            }
        }
        return matches;
    }

    public void mergeFrom(DiagnosticsMap other) {
        this.values.putAll(other.values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map map = this.values;
        synchronized (map) {
            this.values.clear();
        }
    }
}

