/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.diagnostics;

import com.agitar.common.diagnostics.Diagnostic;
import com.agitar.common.diagnostics.DiagnosticKey;
import com.agitar.common.diagnostics.DiagnosticsMap;
import com.agitar.common.diagnostics.ErrorDiagnostic;
import com.agitar.common.diagnostics.FractionDiagnostic;
import com.agitar.common.diagnostics.ListDiagnostic;
import com.agitar.common.diagnostics.NumberDiagnostic;
import com.agitar.common.diagnostics.StringDiagnostic;
import com.agitar.common.diagnostics.TestDiagnostic;
import com.agitar.common.types.ClassName;
import com.agitar.common.types.MethodSignature;
import java.util.Map;
import org.w3c.dom.Element;

public class Diagnostics {
    public static final Diagnostic ZERO = new NumberDiagnostic(0.0);
    static final DiagnosticsMap SINGLETON = new DiagnosticsMap();
    private final DiagnosticsMap values;
    private final String key;
    public static final String XML_REPORT_FILE_NAME = "diagnostics.xml";
    public static final String HTML_REPORT_FILE_NAME = "diagnostics.html";

    public static Diagnostics getKey(String key) {
        return SINGLETON.getKey(key);
    }

    public String getKey() {
        return this.key;
    }

    public void set(Diagnostic value) {
        this.values.put(new DiagnosticKey(this.key), value);
    }

    public void set(double value) {
        this.set(new NumberDiagnostic(value));
    }

    public void set(String value) {
        if (value != null) {
            this.set(new StringDiagnostic(value));
        }
    }

    public void setError(String logMessage, Throwable value) {
        this.set(new ErrorDiagnostic(logMessage, value));
    }

    public void setFraction(int numerator, int denominator) {
        this.set(new FractionDiagnostic(numerator, denominator));
    }

    public void set(ClassName className, Diagnostic value) {
        if (className != null) {
            this.values.put(new DiagnosticKey(this.key, className), value);
        } else {
            this.set(value);
        }
    }

    public void set(ClassName className, double value) {
        this.set(className, (Diagnostic)new NumberDiagnostic(value));
    }

    public void set(ClassName className, String value) {
        if (value != null) {
            this.set(className, (Diagnostic)new StringDiagnostic(value));
        }
    }

    public void setError(ClassName className, String logMessage, Throwable value) {
        this.set(className, (Diagnostic)new ErrorDiagnostic(logMessage, value));
    }

    public void setFraction(ClassName className, int numerator, int denominator) {
        this.set(className, (Diagnostic)new FractionDiagnostic(numerator, denominator));
    }

    public void set(MethodSignature methodSignature, Diagnostic value) {
        if (methodSignature != null) {
            this.values.put(new DiagnosticKey(this.key, methodSignature), value);
        } else {
            this.set(value);
        }
    }

    public void set(MethodSignature methodSignature, double value) {
        this.set(methodSignature, (Diagnostic)new NumberDiagnostic(value));
    }

    public void set(MethodSignature methodSignature, String value) {
        if (value != null) {
            this.set(methodSignature, (Diagnostic)new StringDiagnostic(value));
        }
    }

    public void setError(MethodSignature methodSignature, String logMessage, Throwable value) {
        this.set(methodSignature, (Diagnostic)new ErrorDiagnostic(logMessage, value));
    }

    public void setFraction(MethodSignature methodSignature, int numerator, int denominator) {
        this.set(methodSignature, (Diagnostic)new FractionDiagnostic(numerator, denominator));
    }

    private void add(DiagnosticKey diagnosticKey, Diagnostic value) {
        Diagnostic diagnostic = this.values.get(diagnosticKey);
        if (diagnostic == null) {
            this.values.put(diagnosticKey, value);
        } else if (diagnostic instanceof ListDiagnostic) {
            ((ListDiagnostic)diagnostic).add(value);
        } else {
            ListDiagnostic list = new ListDiagnostic();
            list.add(diagnostic);
            list.add(value);
            this.values.put(diagnosticKey, list);
        }
    }

    public void add(Diagnostic value) {
        this.add(new DiagnosticKey(this.key), value);
    }

    public void add(String value) {
        if (value != null) {
            this.add(new StringDiagnostic(value));
        }
    }

    public void addError(String logMessage, Throwable value) {
        this.add(new ErrorDiagnostic(logMessage, value));
    }

    public void add(ClassName className, Diagnostic value) {
        this.add(new DiagnosticKey(this.key, className), value);
    }

    public void add(ClassName className, String value) {
        if (value != null) {
            this.add(className, (Diagnostic)new StringDiagnostic(value));
        }
    }

    public void addError(ClassName className, String logMessage, Throwable value) {
        this.add(className, (Diagnostic)new ErrorDiagnostic(logMessage, value));
    }

    public void add(MethodSignature methodSignature, Diagnostic value) {
        this.add(new DiagnosticKey(this.key, methodSignature), value);
    }

    public void add(MethodSignature methodSignature, String value) {
        if (value != null) {
            this.add(methodSignature, (Diagnostic)new StringDiagnostic(value));
        }
    }

    public void addError(MethodSignature methodSignature, String logMessage, Throwable value) {
        this.add(methodSignature, (Diagnostic)new ErrorDiagnostic(logMessage, value));
    }

    public Diagnostic get() {
        return this.values.get(new DiagnosticKey(this.key));
    }

    public Diagnostic get(ClassName className) {
        return this.values.get(new DiagnosticKey(this.key, className));
    }

    public Diagnostic get(MethodSignature methodSignature) {
        return this.values.get(new DiagnosticKey(this.key, methodSignature));
    }

    Diagnostics(String key, DiagnosticsMap values) {
        this.key = key;
        this.values = values;
    }

    public static DiagnosticsMap getSingleton() {
        return SINGLETON;
    }

    public static Map getAll() {
        return SINGLETON.getAll();
    }

    public static Map getAll(String name) {
        return SINGLETON.getAll(name);
    }

    public static Map getAll(ClassName className) {
        return SINGLETON.getAll(className);
    }

    public static Map getAllMethodsIn(String name, ClassName className) {
        return SINGLETON.getAllMethodsIn(name, className);
    }

    public static Map getAll(MethodSignature methodSignature) {
        return SINGLETON.getAll(methodSignature);
    }

    public static void clear() {
        SINGLETON.clear();
    }

    public static Diagnostic getDiagnostic(String value) {
        return value == null ? null : new StringDiagnostic(value);
    }

    public static Diagnostic getDiagnostic(double value) {
        return new NumberDiagnostic(value);
    }

    public static Diagnostic parseElement(Element element) {
        String type = element.getAttribute("type");
        if (type == null) {
            return new StringDiagnostic("Diagnostic with no type");
        }
        if (type.equals("string")) {
            return StringDiagnostic.parseElement(element);
        }
        if (type.equals("number")) {
            return NumberDiagnostic.parseElement(element);
        }
        if (type.equals("fraction")) {
            return FractionDiagnostic.parseElement(element);
        }
        if (type.equals("error")) {
            return ErrorDiagnostic.parseElement(element);
        }
        if (type.equals("list")) {
            return ListDiagnostic.parseElement(element);
        }
        if (type.equals("fraction")) {
            return FractionDiagnostic.parseElement(element);
        }
        if (type.equals("test")) {
            return TestDiagnostic.parseElement(element);
        }
        return new StringDiagnostic("Diagnostic with unknown type: " + type);
    }
}

