/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.diagnostics;

import com.agitar.common.diagnostics.Diagnostic;
import com.agitar.common.types.ClassName;
import com.agitar.common.types.MethodSignature;
import com.agitar.common.util.AgitarProperties;
import com.agitar.common.util.StringUtility;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DiagnosticResources {
    private static String MISSING = "Missing resource: ";
    private static ResourceBundle resources;
    private static final String productName;

    public static String getResource(String key) {
        try {
            if (resources == null) {
                resources = ResourceBundle.getBundle("com.agitar.common.diagnostics.problems");
            }
            return StringUtility.plainReplaceAll(resources.getString(key), "$product", productName);
        }
        catch (MissingResourceException e) {
            return MISSING + key;
        }
    }

    public static String getResource(String key, Object[] params) {
        try {
            if (resources == null) {
                resources = ResourceBundle.getBundle("com.agitar.common.diagnostics.problems");
            }
            String resource = StringUtility.plainReplaceAll(resources.getString(key), "$product", productName);
            return MessageFormat.format(resource, params);
        }
        catch (MissingResourceException e) {
            return MISSING + key + " " + (params == null ? null : Arrays.asList(params));
        }
    }

    public static String getResource(String messageKey, MethodSignature methodSignature, ClassName className, List diagnostics) {
        Object[] messageParams = new Object[]{};
        try {
            String message;
            messageParams = new Object[5 + diagnostics.size()];
            Arrays.fill(messageParams, "N/A");
            if (className != null) {
                messageParams[0] = className.getName();
                messageParams[1] = className.getNameWithoutPackage();
                messageParams[2] = className.getPackageName();
            }
            if (methodSignature != null) {
                messageParams[3] = methodSignature.getShortestForm();
                messageParams[4] = methodSignature.getName();
            }
            if (diagnostics.isEmpty()) {
                message = DiagnosticResources.getResource(messageKey);
            } else {
                boolean plural = ((Diagnostic)diagnostics.get(0)).isPlural();
                if (plural) {
                    message = DiagnosticResources.getResource(messageKey + ".plural");
                    if (message.startsWith(MISSING)) {
                        message = DiagnosticResources.getResource(messageKey);
                    }
                } else {
                    message = DiagnosticResources.getResource(messageKey);
                }
            }
            for (int i = 0; i < diagnostics.size(); ++i) {
                Diagnostic d = (Diagnostic)diagnostics.get(i);
                int varIndex = 5 + i;
                messageParams[varIndex] = message.indexOf("{" + varIndex + ",number") >= 0 ? new Double(d.toNumber()) : ((Object)d).toString();
            }
            return MessageFormat.format(message, messageParams);
        }
        catch (Exception e) {
            return e.toString() + ": " + messageKey + " " + (messageParams == null ? null : Arrays.asList(messageParams));
        }
    }

    static {
        productName = AgitarProperties.LOCKDOWN ? "JUnit Factory" : "AgitarOne";
    }
}

