/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.diagnostics;

import com.agitar.common.diagnostics.Diagnostic;
import com.agitar.common.diagnostics.DiagnosticKey;
import com.agitar.common.diagnostics.Diagnostics;
import com.agitar.common.diagnostics.DiagnosticsMap;
import com.agitar.common.diagnostics.DiagnosticsReport;
import com.agitar.common.diagnostics.Problem;
import com.agitar.common.diagnostics.ReportException;
import com.agitar.common.diagnostics.Solution;
import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.types.ClassName;
import com.agitar.common.types.MethodSignature;
import com.agitar.common.util.XMLParsers;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DiagnosticReportGenerator {
    private static final String DIAGNOSTICS_ELEMENT = "diagnostics";
    private static final String MESSAGE_ATTR = "message";
    private static final String METHOD_ATTR = "method";
    private static final String FULL_METHOD_ATTR = "fullmethod";
    private static final String CLASS_ATTR = "class";
    private static final String PACKAGE_ATTR = "package";
    private static final String KEY_ATTR = "key";
    private static final String RATING = "rating";
    private static final String SOLUTION_PROBLEM_ID = "problemid";
    private static final String SOLUTION_ELEMENT = "solution";
    private static final String SEVERITY = "severity";
    private static final String PROBLEM_PROBLEM_ID = "id";
    private static final String PROBLEM_ELEMENT = "problem";
    private final List problems = new ArrayList();
    private Document doc;
    private Writer xmlOutput;
    private Writer htmlOutput;
    private DiagnosticsMap diagnostics;

    public DiagnosticReportGenerator() {
        this.diagnostics = Diagnostics.SINGLETON;
    }

    public DiagnosticReportGenerator(DiagnosticsReport report) {
        this.diagnostics = report.getDiagnostics();
        this.problems.addAll(report.getProblems(Integer.MAX_VALUE, 0));
    }

    public void addProblem(Problem problem) {
        this.problems.add(problem);
    }

    void setXmlOutput(Writer output) {
        this.xmlOutput = output;
    }

    private void setHtmlOutput(Writer output) {
        this.htmlOutput = output;
    }

    void run() throws ReportException {
        long start = System.currentTimeMillis();
        this.generateReport();
        AgitarLogger.getDiagnosticLogger().info("Report took " + (System.currentTimeMillis() - start) + " ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DiagnosticsReport parse(File file) throws ReportException, IOException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            DiagnosticsReport diagnosticsReport = DiagnosticReportGenerator.parse(stream);
            return diagnosticsReport;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static DiagnosticsReport parse(InputStream input) throws ReportException {
        try {
            DocumentBuilder db = XMLParsers.getDocumentBuilderFactory().newDocumentBuilder();
            InputSource source = new InputSource(new InputStreamReader(input, "UTF-8"));
            Document doc = db.parse(source);
            HashMap idToProblem = new HashMap();
            DiagnosticReportGenerator.parseProblems(doc.getElementsByTagName(PROBLEM_ELEMENT), idToProblem);
            DiagnosticReportGenerator.parseSolutions(doc.getElementsByTagName(SOLUTION_ELEMENT), idToProblem);
            DiagnosticsMap dmap = DiagnosticReportGenerator.parseDiagnostics(((Element)doc.getElementsByTagName(DIAGNOSTICS_ELEMENT).item(0)).getChildNodes());
            String html = DiagnosticReportGenerator.generateSupportHTML(doc);
            return new DiagnosticsReport(idToProblem.values(), html, dmap);
        }
        catch (ParserConfigurationException e) {
            throw new ReportException("Could not initialize XML parser", e);
        }
        catch (SAXException e) {
            throw new ReportException("Could not parse file", e);
        }
        catch (IOException e) {
            throw new ReportException("Could not read file", e);
        }
    }

    private static String generateSupportHTML(Document doc) throws ReportException {
        try {
            InputStream xslt = DiagnosticReportGenerator.class.getResourceAsStream("xhtml-support.xslt");
            if (xslt == null) {
                throw new ReportException("could not find xhtml-support.xslt resource");
            }
            Transformer trans = XMLParsers.newTransformer(xslt);
            StringWriter output = new StringWriter();
            trans.transform(new DOMSource(doc), new StreamResult(output));
            return output.toString();
        }
        catch (Exception e) {
            throw new ReportException("Could not serialize DOM", e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new ReportException("Could not serialize DOM", e);
        }
    }

    private static DiagnosticsMap parseDiagnostics(NodeList diagnostics) {
        DiagnosticsMap dmap = new DiagnosticsMap();
        for (int i = 0; i < diagnostics.getLength(); ++i) {
            Element element = (Element)diagnostics.item(i);
            Diagnostic diagnostic = Diagnostics.parseElement(element);
            String key = element.getAttribute(KEY_ATTR);
            if (key.length() <= 0) continue;
            String packageName = element.getAttribute(PACKAGE_ATTR);
            String className = packageName.length() > 0 ? packageName + '.' + element.getAttribute(CLASS_ATTR) : element.getAttribute(CLASS_ATTR);
            String methodSignature = className.length() > 0 && element.getAttribute(FULL_METHOD_ATTR).length() > 0 ? className + '.' + element.getAttribute(FULL_METHOD_ATTR) : element.getAttribute(FULL_METHOD_ATTR);
            if (key == null) continue;
            if (methodSignature.length() > 0) {
                dmap.getKey(key).set(new MethodSignature(methodSignature), diagnostic);
                continue;
            }
            if (className.length() > 0) {
                dmap.getKey(key).set(ClassName.get(className), diagnostic);
                continue;
            }
            dmap.getKey(key).set(diagnostic);
        }
        return dmap;
    }

    private static void parseSolutions(NodeList solutions, Map idToProblem) {
        for (int i = 0; i < solutions.getLength(); ++i) {
            Element element = (Element)solutions.item(i);
            String id = element.getAttribute(SOLUTION_PROBLEM_ID);
            int rating = DiagnosticReportGenerator.parseInt(element.getAttribute(RATING));
            String messageKey = element.getAttribute(MESSAGE_ATTR);
            String className = element.getAttribute(CLASS_ATTR);
            String methodSignature = element.getAttribute(METHOD_ATTR);
            Solution solution = methodSignature.length() > 0 ? new Solution(rating, messageKey, new MethodSignature(className + '.' + methodSignature), null) : (className.length() > 0 ? new Solution(rating, messageKey, ClassName.get(className), null) : new Solution(rating, messageKey, null));
            NodeList children = element.getElementsByTagName("diagnostic");
            for (int j = 0; j < children.getLength(); ++j) {
                solution.addDiagnostic(Diagnostics.parseElement((Element)children.item(j)));
            }
            Problem problem = (Problem)idToProblem.get(id);
            if (problem == null) continue;
            problem.addSolution(solution);
        }
    }

    private static void parseProblems(NodeList problems, Map idToProblem) {
        for (int i = 0; i < problems.getLength(); ++i) {
            Element element = (Element)problems.item(i);
            String id = element.getAttribute(PROBLEM_PROBLEM_ID);
            int severity = DiagnosticReportGenerator.parseInt(element.getAttribute(SEVERITY));
            String messageKey = element.getAttribute(MESSAGE_ATTR);
            String className = element.getAttribute(CLASS_ATTR);
            String methodSignature = element.getAttribute(METHOD_ATTR);
            Problem problem = methodSignature.length() > 0 ? new Problem(severity, messageKey, new MethodSignature(className + '.' + methodSignature), null) : (className.length() > 0 ? new Problem(severity, messageKey, ClassName.get(className), null) : new Problem(severity, messageKey, null));
            NodeList children = element.getElementsByTagName("diagnostic");
            for (int j = 0; j < children.getLength(); ++j) {
                problem.addDiagnostic(Diagnostics.parseElement((Element)children.item(j)));
            }
            idToProblem.put(id, problem);
        }
    }

    private static int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private void generateReport() throws FactoryConfigurationError, ReportException {
        this.doc = this.createDocument();
        Element root = this.doc.createElement("report");
        DiagnosticReportGenerator.setAttribute(root, "date", new Date().toString());
        this.doc.appendChild(root);
        root.appendChild(this.createProblemsElement());
        root.appendChild(this.createSolutionsElement());
        root.appendChild(this.createDiagnosticsElement());
        if (this.xmlOutput != null) {
            this.writeXML();
        }
        if (this.htmlOutput != null) {
            this.writeHTML();
        }
    }

    private Document createDocument() throws ReportException {
        try {
            return XMLParsers.getDocumentBuilderFactory().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new ReportException("Could not create DOM", e);
        }
    }

    private void writeXML() throws ReportException {
        try {
            Transformer t = XMLParsers.getTransformerFactory().newTransformer();
            t.transform(new DOMSource(this.doc), new StreamResult(this.xmlOutput));
            this.xmlOutput.flush();
        }
        catch (TransformerConfigurationException e) {
            throw new ReportException("Could not serialize DOM", e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new ReportException("Could not serialize DOM", e);
        }
        catch (TransformerException e) {
            throw new ReportException("Could not serialize DOM", e);
        }
        catch (IOException e) {
            throw new ReportException("Could not write to file", e);
        }
    }

    private void writeHTML() throws ReportException {
        try {
            InputStream xslt = this.getClass().getResourceAsStream("xhtml-report.xslt");
            if (xslt == null) {
                throw new IOException("could not find xhtml-report.xslt resource");
            }
            Transformer trans = XMLParsers.newTransformer(xslt);
            trans.transform(new DOMSource(this.doc), new StreamResult(this.htmlOutput));
            this.htmlOutput.flush();
        }
        catch (Exception e) {
            throw new ReportException("Could not serialize DOM", e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new ReportException("Could not serialize DOM", e);
        }
    }

    private Node createProblemsElement() {
        Collections.sort(this.problems, Problem.COMPARE_BY_PRIORITY);
        Element element = this.doc.createElement("problems");
        Iterator iter = this.problems.iterator();
        while (iter.hasNext()) {
            Problem problem = (Problem)iter.next();
            element.appendChild(this.createProblemElement(problem));
        }
        return element;
    }

    private Node createProblemElement(Problem problem) {
        Element element = this.doc.createElement(PROBLEM_ELEMENT);
        DiagnosticReportGenerator.setAttribute(element, PROBLEM_PROBLEM_ID, String.valueOf(problem.getID()));
        DiagnosticReportGenerator.setAttribute(element, SEVERITY, String.valueOf(problem.getPriority()));
        DiagnosticReportGenerator.setAttribute(element, MESSAGE_ATTR, problem.getMessageKey());
        if (problem.getMethodSignature() != null) {
            DiagnosticReportGenerator.setAttribute(element, METHOD_ATTR, problem.getMethodSignature().getShortForm());
        }
        if (problem.getClassName() != null) {
            DiagnosticReportGenerator.setAttribute(element, CLASS_ATTR, problem.getClassName().toString());
        }
        element.appendChild(this.doc.createTextNode(problem.getMessage()));
        Diagnostic[] diagnostics = problem.getDiagnostics();
        for (int i = 0; i < diagnostics.length; ++i) {
            element.appendChild(diagnostics[i].toElement(this.doc));
        }
        return element;
    }

    private Node createSolutionsElement() {
        Element element = this.doc.createElement("solutions");
        Iterator problemIter = this.problems.iterator();
        while (problemIter.hasNext()) {
            Problem problem = (Problem)problemIter.next();
            Iterator solutionIter = problem.getSolutions().iterator();
            while (solutionIter.hasNext()) {
                Solution solution = (Solution)solutionIter.next();
                element.appendChild(this.createSolutionElement(problem, solution));
            }
        }
        return element;
    }

    private Node createSolutionElement(Problem problem, Solution solution) {
        Element element = this.doc.createElement(SOLUTION_ELEMENT);
        DiagnosticReportGenerator.setAttribute(element, RATING, String.valueOf(solution.getRating()));
        DiagnosticReportGenerator.setAttribute(element, SOLUTION_PROBLEM_ID, String.valueOf(problem.getID()));
        DiagnosticReportGenerator.setAttribute(element, MESSAGE_ATTR, solution.getMessageKey());
        if (solution.getMethodSignature() != null) {
            DiagnosticReportGenerator.setAttribute(element, METHOD_ATTR, solution.getMethodSignature().getShortForm());
        }
        if (solution.getClassName() != null) {
            DiagnosticReportGenerator.setAttribute(element, CLASS_ATTR, solution.getClassName().toString());
        }
        element.appendChild(this.doc.createTextNode(solution.getMessage()));
        Diagnostic[] diagnostics = solution.getDiagnostics();
        for (int i = 0; i < diagnostics.length; ++i) {
            element.appendChild(diagnostics[i].toElement(this.doc));
        }
        return element;
    }

    private Node createDiagnosticsElement() {
        Element element = this.doc.createElement(DIAGNOSTICS_ELEMENT);
        Map diagnostics = this.diagnostics.getAll();
        Iterator iter = diagnostics.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            DiagnosticKey key = (DiagnosticKey)entry.getKey();
            Diagnostic value = (Diagnostic)entry.getValue();
            element.appendChild(this.createDiagnosticElement(key, value));
        }
        return element;
    }

    private Node createDiagnosticElement(DiagnosticKey key, Diagnostic value) {
        Element element = value.toElement(this.doc);
        DiagnosticReportGenerator.setAttribute(element, KEY_ATTR, key.getName());
        if (key.getMethodSignature() != null) {
            DiagnosticReportGenerator.setAttribute(element, FULL_METHOD_ATTR, key.getMethodSignature().getShortForm());
            DiagnosticReportGenerator.setAttribute(element, METHOD_ATTR, key.getMethodSignature().getShortestForm());
            DiagnosticReportGenerator.setAttribute(element, CLASS_ATTR, key.getMethodSignature().getClassName().getNameWithoutPackage());
            DiagnosticReportGenerator.setAttribute(element, PACKAGE_ATTR, key.getMethodSignature().getClassName().getPackageName());
        } else if (key.getClassName() != null) {
            DiagnosticReportGenerator.setAttribute(element, CLASS_ATTR, key.getClassName().getNameWithoutPackage());
            DiagnosticReportGenerator.setAttribute(element, PACKAGE_ATTR, key.getClassName().getPackageName());
        }
        return element;
    }

    private static void setAttribute(Element element, String name, String value) {
        if (name == null || value == null) {
            AgitarLogger.getDiagnosticLogger("DiagnosticReportGenerator").warning("null attribute: " + element.getNodeName() + " name=" + name + " value=" + value);
        } else {
            element.setAttribute(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFiles(File xmlOutputFile, File htmlOutputFile) throws IOException, ReportException {
        Writer htmlOutputWriter;
        block7: {
            Writer xmlOutputWriter = null;
            htmlOutputWriter = null;
            try {
                if (xmlOutputFile != null) {
                    xmlOutputWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(xmlOutputFile), "UTF-8"));
                    this.setXmlOutput(xmlOutputWriter);
                }
                if (htmlOutputFile != null) {
                    htmlOutputWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlOutputFile), "UTF-8"));
                    this.setHtmlOutput(htmlOutputWriter);
                }
                this.run();
                Object var6_5 = null;
                if (xmlOutputWriter == null) break block7;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (xmlOutputWriter != null) {
                    xmlOutputWriter.close();
                }
                if (htmlOutputWriter != null) {
                    htmlOutputWriter.close();
                }
                throw throwable;
            }
            xmlOutputWriter.close();
        }
        if (htmlOutputWriter != null) {
            htmlOutputWriter.close();
        }
    }
}

