/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.diagnostics;

import com.agitar.common.types.ClassName;
import com.agitar.common.types.MethodSignature;

public class DiagnosticKey {
    private final String name;
    private final ClassName className;
    private final MethodSignature methodSignature;

    public DiagnosticKey(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.className = null;
        this.methodSignature = null;
    }

    public DiagnosticKey(String name, ClassName className) {
        if (name == null || className == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.className = className;
        this.methodSignature = null;
    }

    public DiagnosticKey(String name, MethodSignature methodSignature) {
        if (name == null || methodSignature == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.className = null;
        this.methodSignature = methodSignature;
    }

    public String getName() {
        return this.name;
    }

    public ClassName getClassName() {
        return this.className;
    }

    public MethodSignature getMethodSignature() {
        return this.methodSignature;
    }

    public boolean equals(Object o) {
        if (o instanceof DiagnosticKey) {
            DiagnosticKey that = (DiagnosticKey)o;
            return this.name.equals(that.name) && (this.className == null && that.className == null || this.className.equals(that.className)) && (this.methodSignature == null && that.methodSignature == null || this.methodSignature.equals(that.methodSignature));
        }
        return false;
    }

    public int hashCode() {
        if (this.className != null) {
            return this.name.hashCode() ^ this.className.hashCode();
        }
        if (this.methodSignature != null) {
            return this.name.hashCode() ^ this.methodSignature.hashCode();
        }
        return this.name.hashCode();
    }

    public String toString() {
        if (this.className != null) {
            return this.name + '[' + this.className + ']';
        }
        if (this.methodSignature != null) {
            return this.name + '[' + this.methodSignature + ']';
        }
        return this.name;
    }
}

