/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.diagnostics;

import com.agitar.common.diagnostics.Diagnostic;
import com.agitar.common.diagnostics.DiagnosticReportGenerator;
import com.agitar.common.diagnostics.DiagnosticsReport;
import com.agitar.common.diagnostics.FractionDiagnostic;
import com.agitar.common.diagnostics.ReportException;
import com.agitar.common.diagnostics.TestDiagnostic;
import com.agitar.common.types.ClassName;
import com.agitar.common.util.IOUtility;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class DiagnosticAnalyzer {
    private int targets = 0;
    private int tests = 0;
    private int coveredPoints;
    private int totalPoints;
    private Map failureToClasses = new HashMap();
    private static final Pattern[] templates = new Pattern[]{Pattern.compile("did not expect exception No recording found for method: .*"), Pattern.compile("did not expect exception .*"), Pattern.compile("no value for reference .*"), Pattern.compile("for ref\\[.*\\] expected .*"), Pattern.compile("boundary conditions don't match: .*"), Pattern.compile("coverage changed: .*"), Pattern.compile("expected exception .*"), Pattern.compile("No recording found .*"), Pattern.compile(".* calls expected: .* actual: .*"), Pattern.compile("Mockingbird object used for this object .*"), Pattern.compile("#[0-9].*"), Pattern.compile("The final field .* cannot be assigned"), Pattern.compile("return value identifier is different .*"), Pattern.compile(".*Could not look up live method"), Pattern.compile("com.agitar.tbe.recorder.*"), Pattern.compile("[01]\\,.*")};

    public static void main(String[] args) {
        final DiagnosticAnalyzer analyzer = new DiagnosticAnalyzer();
        IOUtility.traverse(new File("."), new IOUtility.Callback(){

            public boolean doAction(File f) {
                if (f.getName().endsWith(".xml") && !f.getName().equals("ops.xml")) {
                    try {
                        analyzer.addReport(f);
                    }
                    catch (Exception e) {
                        System.out.println(f);
                        e.printStackTrace();
                    }
                }
                return true;
            }
        });
        analyzer.reportTopFailures();
    }

    private void reportTopFailures() {
        System.out.println(this.targets + " classes, " + this.tests + " tests");
        ArrayList failureList = new ArrayList(this.failureToClasses.entrySet());
        Collections.sort(failureList, new Comparator(){

            public int compare(Object o1, Object o2) {
                Map.Entry e1 = (Map.Entry)o1;
                Map.Entry e2 = (Map.Entry)o2;
                Set s1 = (Set)e1.getValue();
                Set s2 = (Set)e2.getValue();
                return s2.size() - s1.size();
            }
        });
        Iterator iter = failureList.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            String message = (String)entry.getKey();
            Set classes = (Set)entry.getValue();
            System.out.println(classes.size() + " " + message);
            System.out.println("  " + classes);
        }
    }

    public void addReport(File xml) throws ReportException, IOException {
        FractionDiagnostic coverage;
        DiagnosticsReport report = DiagnosticReportGenerator.parse(xml);
        ClassName target = ClassName.get(String.valueOf(report.getKey("target.class.name").get()));
        Map failingTests = report.getDiagnostics().getAll("test.failing");
        Map allTests = report.getDiagnostics().getAll("test.created");
        this.tests += allTests.size();
        System.out.print(".");
        ++this.targets;
        if (this.targets % 100 == 0) {
            System.out.println();
        }
        if ((coverage = (FractionDiagnostic)report.getDiagnostics().getKey("coverage.testgen").get(target)) != null) {
            this.totalPoints += coverage.getDenominator();
            this.coveredPoints += coverage.getNumerator();
        }
        Iterator iter = failingTests.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Diagnostic value = (Diagnostic)entry.getValue();
            List tests = value.toList();
            Iterator iterator = tests.iterator();
            while (iterator.hasNext()) {
                HashSet<ClassName> classes;
                Object next = iterator.next();
                if (!(next instanceof TestDiagnostic)) continue;
                TestDiagnostic failingTest = (TestDiagnostic)next;
                String reason = failingTest.getFailingReason();
                for (int i = 0; i < templates.length; ++i) {
                    if (!templates[i].matcher(reason).matches()) continue;
                    reason = templates[i].pattern();
                    break;
                }
                if ((classes = (HashSet<ClassName>)this.failureToClasses.get(reason)) == null) {
                    classes = new HashSet<ClassName>();
                    this.failureToClasses.put(reason, classes);
                }
                classes.add(target);
            }
        }
    }
}

