/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.asm;

import com.agitar.common.asm.GettersAndSetters;
import com.agitar.common.types.MethodSignature;
import java.lang.reflect.Modifier;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.CodeAdapter;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public class SimpleGetterSetterDetector
extends ClassAdapter {
    private final GettersAndSetters gettersAndSetters;
    private String className;

    public SimpleGetterSetterDetector(ClassVisitor cv, GettersAndSetters gettersAndSetters) {
        super(cv);
        this.gettersAndSetters = gettersAndSetters;
    }

    public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
        super.visit(version, access, name, superName, interfaces, sourceFile);
        this.className = name;
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        CodeVisitor cv = super.visitMethod(access, name, desc, exceptions, attrs);
        Type[] descTypes = Type.getArgumentTypes((String)desc);
        if (!Modifier.isPrivate(access) && descTypes.length == 0 && !desc.endsWith("V")) {
            return new SimpleGetterCodeVisitor(cv, MethodSignature.fromRawForm(this.className, name, desc));
        }
        if (!Modifier.isPrivate(access) && descTypes.length == 1 && desc.endsWith("V") && name.startsWith("set")) {
            return new SimpleSetterCodeVisitor(cv, MethodSignature.fromRawForm(this.className, name, desc));
        }
        return cv;
    }

    private class SimpleSetterCodeVisitor
    extends CodeAdapter {
        private boolean simpleSetter;
        private final MethodSignature signature;

        public SimpleSetterCodeVisitor(CodeVisitor cv, MethodSignature signature) {
            super(cv);
            this.simpleSetter = true;
            this.signature = signature;
        }

        public void visitIincInsn(int var, int increment) {
            this.simpleSetter = false;
            super.visitIincInsn(var, increment);
        }

        public void visitInsn(int opcode) {
            if (opcode != 177) {
                this.simpleSetter = false;
            }
            super.visitInsn(opcode);
        }

        public void visitIntInsn(int opcode, int operand) {
            this.simpleSetter = false;
            super.visitIntInsn(opcode, operand);
        }

        public void visitJumpInsn(int opcode, Label label) {
            this.simpleSetter = false;
            super.visitJumpInsn(opcode, label);
        }

        public void visitLdcInsn(Object cst) {
            this.simpleSetter = false;
            super.visitLdcInsn(cst);
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            this.simpleSetter = false;
            super.visitLookupSwitchInsn(dflt, keys, labels);
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            if (this.simpleSetter) {
                SimpleGetterSetterDetector.this.gettersAndSetters.addSetter(this.signature.getClassName().getName(), this.signature.getName() + this.signature.getBytecodeForm());
            }
            super.visitMaxs(maxStack, maxLocals);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            this.simpleSetter = false;
            super.visitMethodInsn(opcode, owner, name, desc);
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            this.simpleSetter = false;
            super.visitMultiANewArrayInsn(desc, dims);
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
            this.simpleSetter = false;
            super.visitTableSwitchInsn(min, max, dflt, labels);
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            this.simpleSetter = false;
            super.visitTryCatchBlock(start, end, handler, type);
        }

        public void visitTypeInsn(int opcode, String desc) {
            this.simpleSetter = false;
            super.visitTypeInsn(opcode, desc);
        }
    }

    private class SimpleGetterCodeVisitor
    extends CodeAdapter {
        private boolean simpleGetter;
        private final MethodSignature signature;

        public SimpleGetterCodeVisitor(CodeVisitor cv, MethodSignature signature) {
            super(cv);
            this.simpleGetter = true;
            this.signature = signature;
        }

        public void visitIincInsn(int var, int increment) {
            this.simpleGetter = false;
            super.visitIincInsn(var, increment);
        }

        public void visitInsn(int opcode) {
            if (opcode < 172 || opcode > 177) {
                this.simpleGetter = false;
            }
            super.visitInsn(opcode);
        }

        public void visitIntInsn(int opcode, int operand) {
            this.simpleGetter = false;
            super.visitIntInsn(opcode, operand);
        }

        public void visitJumpInsn(int opcode, Label label) {
            this.simpleGetter = false;
            super.visitJumpInsn(opcode, label);
        }

        public void visitLdcInsn(Object cst) {
            this.simpleGetter = false;
            super.visitLdcInsn(cst);
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            this.simpleGetter = false;
            super.visitLookupSwitchInsn(dflt, keys, labels);
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            if (this.simpleGetter) {
                SimpleGetterSetterDetector.this.gettersAndSetters.addGetter(this.signature.getClassName().getName(), this.signature.getName() + this.signature.getBytecodeForm());
            }
            super.visitMaxs(maxStack, maxLocals);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            this.simpleGetter = false;
            super.visitMethodInsn(opcode, owner, name, desc);
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            this.simpleGetter = false;
            super.visitMultiANewArrayInsn(desc, dims);
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
            this.simpleGetter = false;
            super.visitTableSwitchInsn(min, max, dflt, labels);
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            this.simpleGetter = false;
            super.visitTryCatchBlock(start, end, handler, type);
        }

        public void visitTypeInsn(int opcode, String desc) {
            this.simpleGetter = false;
            super.visitTypeInsn(opcode, desc);
        }
    }
}

