/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.asm;

import com.agitar.common.asm.AbstractClassInstrumenter;
import com.agitar.common.asm.SerialMember;
import com.agitar.common.logging.AgitarLevel;
import com.agitar.common.logging.AgitarLogger;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.CodeVisitor;

public class SerialIDInstrumenter
extends AbstractClassInstrumenter {
    private int access;
    private String name;
    private String[] interfaces;
    private boolean hasStaticInit;
    private boolean hasSerialID;
    private List fields;
    private List constructors;
    private List methods;
    protected static final int CLASS_MODIFIERS = 1553;
    private static final int MEMBER_MODIFIERS = 31;
    protected static final int METHOD_MODIFIERS = 3391;
    protected static final int FIELD_MODIFIERS = 223;

    public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
        super.visit(version, access, name, superName, interfaces, sourceFile);
        this.access = access;
        this.name = name.replace('/', '.');
        if (interfaces != null) {
            this.interfaces = new String[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                this.interfaces[i] = interfaces[i].replace('/', '.');
            }
        } else {
            this.interfaces = null;
        }
        this.hasSerialID = false;
        this.hasStaticInit = false;
        this.fields = new ArrayList();
        this.constructors = new ArrayList();
        this.methods = new ArrayList();
    }

    public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
        super.visitField(access, name, desc, value, attrs);
        this.fields.add(new SerialMember(access & 0xDF, name, desc));
        if ("serialVersionUID".equals(name)) {
            this.hasSerialID = true;
        }
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        if ("<clinit>".equals(name)) {
            this.hasStaticInit = true;
        } else if ("<init>".equals(name)) {
            this.constructors.add(new SerialMember(access & 0xD3F, name, desc));
        } else {
            this.methods.add(new SerialMember(access & 0xD3F, name, desc));
        }
        return super.visitMethod(access, name, desc, exceptions, attrs);
    }

    public void visitEnd() {
        super.visitEnd();
        if (!this.hasSerialID && !Modifier.isInterface(this.access)) {
            long uid = this.calculateUID();
            int access = 26;
            this.getNextVisitor().visitField(access, "serialVersionUID", "J", (Object)new Long(uid), null);
        }
    }

    protected long calculateUID() {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeUTF(this.name);
            this.writeModifiers(dout);
            this.writeInterfaces(dout);
            this.writeFields(dout);
            this.writeStaticInit(dout);
            this.writeMethods(dout, this.constructors);
            this.writeMethods(dout, this.methods);
            dout.flush();
            return this.hash(bout.toByteArray());
        }
        catch (IOException ex) {
            throw new InternalError();
        }
        catch (NoSuchAlgorithmException ex) {
            AgitarLogger.getDiagnosticLogger("SerialIDInstrumenter").log(AgitarLevel.WARNING, "Could not compute Serialization UID", ex);
            return 0L;
        }
    }

    private void writeModifiers(DataOutputStream dout) throws IOException {
        int classMods = this.access & 0x611;
        if ((classMods & 0x200) != 0) {
            classMods = this.methods.size() > 0 ? classMods | 0x400 : classMods & 0xFFFFFBFF;
        }
        dout.writeInt(classMods);
    }

    private void writeInterfaces(DataOutputStream dout) throws IOException {
        Arrays.sort(this.interfaces);
        for (int i = 0; i < this.interfaces.length; ++i) {
            dout.writeUTF(this.interfaces[i]);
        }
    }

    private void writeStaticInit(DataOutputStream dout) throws IOException {
        if (this.hasStaticInit) {
            dout.writeUTF("<clinit>");
            dout.writeInt(8);
            dout.writeUTF("()V");
        }
    }

    private void writeFields(DataOutputStream dout) throws IOException {
        Collections.sort(this.fields);
        Iterator iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            SerialMember sm = (SerialMember)iterator.next();
            int mods = sm.getModifiers();
            if ((mods & 2) != 0 && (mods & 0x88) != 0) continue;
            dout.writeUTF(sm.getName());
            dout.writeInt(mods);
            dout.writeUTF(sm.getSignature());
        }
    }

    private void writeMethods(DataOutputStream dout, List mocs) throws IOException {
        Collections.sort(mocs);
        Iterator iterator = mocs.iterator();
        while (iterator.hasNext()) {
            SerialMember sm = (SerialMember)iterator.next();
            int mods = sm.getModifiers();
            if ((mods & 2) != 0) continue;
            dout.writeUTF(sm.getName());
            dout.writeInt(mods);
            dout.writeUTF(sm.getSignature().replace('/', '.'));
        }
    }

    private long hash(byte[] bytes) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA");
        byte[] hashBytes = md.digest(bytes);
        long hash = 0L;
        for (int i = Math.min(hashBytes.length, 8) - 1; i >= 0; --i) {
            hash = hash << 8 | (long)(hashBytes[i] & 0xFF);
        }
        return hash;
    }
}

