/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.asm;

public class LightClassReader {
    public String className;
    public String superClass;
    public String[] interfaces;
    public int modifiers;
    public boolean isInterface;
    private static final String[] NONE = new String[0];

    public LightClassReader(byte[] all) {
        int cpc = LightClassReader.u2(all, 8);
        int[] cpi = new int[cpc];
        int idx = 10;
        block5: for (int i = 1; i < cpc; ++i) {
            cpi[i] = idx;
            byte tag = all[idx];
            switch (tag) {
                case 1: {
                    int ct = LightClassReader.u2(all, idx + 1);
                    idx += 3 + ct;
                    continue block5;
                }
                case 7: 
                case 8: {
                    idx += 3;
                    continue block5;
                }
                case 5: 
                case 6: {
                    idx += 9;
                    ++i;
                    continue block5;
                }
                default: {
                    idx += 5;
                }
            }
        }
        this.modifiers = LightClassReader.u2(all, idx);
        boolean isInterface = (this.modifiers & 0x200) != 0;
        int ti = LightClassReader.u2(all, idx + 2);
        this.className = LightClassReader.cname(all, cpi, ti);
        int si = LightClassReader.u2(all, idx + 4);
        this.superClass = isInterface ? null : LightClassReader.cname(all, cpi, si);
        int ict = LightClassReader.u2(all, idx + 6);
        idx += 8;
        this.interfaces = ict == 0 ? NONE : new String[ict];
        for (int i = 0; i < ict; ++i) {
            int ii = LightClassReader.u2(all, idx + i * 2);
            this.interfaces[i] = LightClassReader.cname(all, cpi, ii);
        }
        idx += ict * 2;
    }

    private static int u2(byte[] bs, int idx) {
        return (bs[idx] & 0xFF) << 8 | bs[idx + 1] & 0xFF;
    }

    private static String cname(byte[] bs, int[] cps, int cpe) {
        if (cpe == 0) {
            return null;
        }
        int utf = cps[LightClassReader.u2(bs, cps[cpe] + 1)];
        return LightClassReader.str(bs, utf, true);
    }

    private static String str(byte[] bs, int utf, boolean sldot) {
        int blen = LightClassReader.u2(bs, utf + 1);
        char[] str = new char[blen];
        int stri = 0;
        int count = utf + 3;
        int endu = utf + 3 + blen;
        block4: while (count < endu) {
            int c = bs[count] & 0xFF;
            switch (c >> 4) {
                case 12: 
                case 13: {
                    byte char2 = bs[(count += 2) - 1];
                    str[stri++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block4;
                }
                case 14: {
                    byte char2 = bs[(count += 3) - 2];
                    byte char3 = bs[count - 1];
                    str[stri++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block4;
                }
            }
            ++count;
            str[stri++] = (char)c;
        }
        String orig = new String(str, 0, stri);
        if (sldot) {
            return orig.replace('/', '.');
        }
        return orig;
    }
}

