/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.asm;

import org.objectweb.asm.attrs.Annotation;

public class JUnit4Annotation {
    private static Boolean HAS_JUNIT_4;
    private static final String JUNIT_4_TEST_ANNOTATION = "Lorg/junit/Test;";
    private static final String JUNIT_4_IGNORE_ANNOTATION = "Lorg/junit/Ignore;";
    public static final String[] JUNIT_4_ANNOTATIONS;
    public static final String[] JUNIT_4_CLASSES;

    public static boolean isJUnit4Method(Annotation annotation) {
        if (annotation != null && annotation.type != null) {
            return JUnit4Annotation.isJUnit4Method(annotation.type);
        }
        return false;
    }

    public static boolean isJUnit4Method(String type) {
        if (type != null) {
            for (int i = 0; i < JUNIT_4_ANNOTATIONS.length; ++i) {
                String name = JUNIT_4_ANNOTATIONS[i];
                if (!name.startsWith(type.trim())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isJUnit4TestMethod(Annotation annotation) {
        if (annotation != null && annotation.type != null) {
            return JUNIT_4_TEST_ANNOTATION.equals(annotation.type.trim());
        }
        return false;
    }

    public static boolean isJUnit4IgnoreAnnotation(Annotation annotation) {
        if (annotation != null && annotation.type != null) {
            return JUNIT_4_IGNORE_ANNOTATION.equals(annotation.type.trim());
        }
        return false;
    }

    public static boolean hasJunit4() {
        if (HAS_JUNIT_4 == null) {
            try {
                Class.forName("org.junit.Test");
                HAS_JUNIT_4 = Boolean.TRUE;
            }
            catch (ClassNotFoundException e) {
                HAS_JUNIT_4 = Boolean.FALSE;
            }
        }
        return HAS_JUNIT_4;
    }

    private JUnit4Annotation() {
    }

    static {
        JUNIT_4_ANNOTATIONS = new String[]{"Lorg/junit/After;", "Lorg/junit/AfterClass;", "Lorg/junit/Before;", "Lorg/junit/BeforeClass;", JUNIT_4_IGNORE_ANNOTATION, JUNIT_4_TEST_ANNOTATION};
        JUNIT_4_CLASSES = new String[]{"org.junit.After", "org.junit.AfterClass", "org.junit.Before", "org.junit.BeforeClass", "org.junit.Ignore", "org.junit.Test"};
    }
}

