/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.asm;

import com.agitar.common.types.MethodSignature;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class GettersAndSetters {
    private static GettersAndSetters instance = new GettersAndSetters();
    private final Map getters = new HashMap();
    private final Map setters = new HashMap();

    public static GettersAndSetters getInstance() {
        return instance;
    }

    void addGetter(String className, String descriptor) {
        this.add(this.getters, className, descriptor);
    }

    private void add(Map map, String className, String descriptor) {
        HashSet<String> set = (HashSet<String>)map.get(className);
        if (set == null) {
            set = new HashSet<String>();
            map.put(className, set);
        }
        set.add(descriptor);
    }

    void addSetter(String className, String descriptor) {
        this.add(this.setters, className, descriptor);
    }

    public boolean isGetter(String className, String descriptor) {
        return this.isIn(this.getters, className, descriptor);
    }

    public boolean isGetter(String className, Method method) {
        MethodSignature msig = MethodSignature.fromMethod(method);
        return this.isIn(this.getters, className, msig.getName() + msig.getBytecodeForm());
    }

    private boolean isIn(Map map, String className, String descriptor) {
        Set set = (Set)map.get(className);
        return set != null && set.contains(descriptor);
    }

    public boolean isSetter(String className, String descriptor) {
        return this.isIn(this.setters, className, descriptor);
    }

    public boolean isSetter(String className, Method method) {
        MethodSignature msig = MethodSignature.fromMethod(method);
        return this.isIn(this.setters, className, msig.getName() + msig.getBytecodeForm());
    }
}

