/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.asm;

import com.agitar.lib.NoObfuscation;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;

public class ClassLoaderResources
implements NoObfuscation {
    private static String checkResource(String resource) {
        String res = null;
        res = resource.startsWith("/") ? resource : (resource.equals(".") ? "/" : "/" + resource);
        return res;
    }

    public static final URL getSystemResource(String resource, ClassLoader agitarClassLoader) {
        URL url = agitarClassLoader.getResource(ClassLoaderResources.checkResource(resource));
        if (url != null) {
            return url;
        }
        return ClassLoader.getSystemResource(resource);
    }

    public static final InputStream getSystemResourceAsStream(String resource, ClassLoader agitarClassLoader) {
        InputStream is = agitarClassLoader.getResourceAsStream(ClassLoaderResources.checkResource(resource));
        if (is != null) {
            return is;
        }
        return ClassLoader.getSystemResourceAsStream(resource);
    }

    public static final Enumeration getSystemResources(String resource, ClassLoader agitarClassLoader) throws IOException {
        try {
            return agitarClassLoader.getResources(ClassLoaderResources.checkResource(resource));
        }
        catch (IOException iOException) {
            return ClassLoader.getSystemResources(resource);
        }
    }

    public static final URL getResource(ClassLoader targetClassLoader, String resource, ClassLoader agitarClassLoader) {
        URL url;
        if (targetClassLoader == ClassLoader.getSystemClassLoader() && (url = agitarClassLoader.getResource(ClassLoaderResources.checkResource(resource))) != null) {
            return url;
        }
        return targetClassLoader.getResource(resource);
    }

    public static final InputStream getResourceAsStream(ClassLoader targetClassLoader, String resource, ClassLoader agitarClassLoader) {
        InputStream is;
        if (targetClassLoader == ClassLoader.getSystemClassLoader() && (is = agitarClassLoader.getResourceAsStream(ClassLoaderResources.checkResource(resource))) != null) {
            return is;
        }
        return targetClassLoader.getResourceAsStream(resource);
    }

    public static final Enumeration getResources(ClassLoader targetClassLoader, String resource, ClassLoader agitarClassLoader) throws IOException {
        if (targetClassLoader == ClassLoader.getSystemClassLoader()) {
            try {
                return agitarClassLoader.getResources(ClassLoaderResources.checkResource(resource));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return targetClassLoader.getResources(resource);
    }
}

