/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.asm;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.CodeWriter;

public abstract class BytecodeSizeChecker {
    private static Map map = new HashMap();
    public static final int METHOD_SIZE_LIMIT = 63487;
    public static final int QUARTER_METHOD_SIZE_LIMIT = 16384;

    public static void check(CodeVisitor cv, String className, String methodName, String methodDescriptor, boolean useFull, boolean throwExceptiion) {
        CodeWriter cw;
        int codeSize;
        if (cv instanceof CodeWriter && (codeSize = (cw = (CodeWriter)cv).getCodeSize()) > (useFull ? 63487 : 16384)) {
            CodeSizeException exception = new CodeSizeException(className, methodName, methodDescriptor, codeSize);
            if (throwExceptiion) {
                throw exception;
            }
            exception.fillInStackTrace();
            map.put(exception.getClassName(), exception);
        }
    }

    public static void clear() {
        map.clear();
    }

    public static CodeSizeException getException(String className) {
        return (CodeSizeException)map.get(CodeSizeException.convertClassName(className));
    }

    private BytecodeSizeChecker() {
    }

    public static class CodeSizeException
    extends RuntimeException {
        private final String className;

        public static String convertClassName(String name) {
            return name.replace('/', '.');
        }

        public CodeSizeException(String className, String methodSignature, int codeSize) {
            super(methodSignature + " in " + CodeSizeException.convertClassName(className) + " (size: " + codeSize + ")");
            this.className = CodeSizeException.convertClassName(className);
        }

        public CodeSizeException(String className, String methodName, String methodDescriptor, int codeSize) {
            this(className, methodName + methodDescriptor, codeSize);
        }

        public String getClassName() {
            return this.className;
        }
    }
}

