/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.asm;

import com.agitar.common.util.ClassCacheMap;
import java.util.Map;

public class ByteClassLoader
extends ClassLoader {
    private final Map nameToBytes = new ClassCacheMap();

    public ByteClassLoader() {
        super(ByteClassLoader.class.getClassLoader());
    }

    public void putBytes(String className, byte[] bytes) {
        this.nameToBytes.put(className, bytes);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        Class<?> loaded = this.findLoadedClass(name);
        if (loaded == null) {
            byte[] bytes = (byte[])this.nameToBytes.get(name);
            if (bytes == null) {
                return this.getParent().loadClass(name);
            }
            return this.defineClass(name, bytes, 0, bytes.length);
        }
        return loaded;
    }
}

