/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.asm;

import com.agitar.common.types.ClassName;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.attrs.Attributes;
import org.objectweb.asm.attrs.EnclosingMethodAttribute;
import org.objectweb.asm.attrs.SignatureAttribute;

public class AsmUtil {
    private static final String JAVA_LANG_OBJECT = "java/lang/Object";
    private static final String[] WRAPPER_CLASSES;
    public static final String CLASS_LOADER_FIELD_NAME = "$agitar_classloader";
    public static final String CONSTRUCTOR_NAME = "<init>";
    public static final String CLASS_INIT_NAME = "<clinit>";
    public static final Type JAVA_LANG_OBJECT_TYPE;
    public static final Type JAVA_LANG_CLASS_TYPE;
    public static final Type JAVA_LANG_CLASS_LOADER_TYPE;
    public static final Attribute[] AttrProtos;
    private static final String CLASS_FOR_NAME_DESC;
    private static final String GET_CLASS_LOADER_DESC;
    static final /* synthetic */ boolean $assertionsDisabled;

    private AsmUtil() {
    }

    public static Attribute[] getDefaultAttributes() {
        HashSet<Attribute> attrSet = new HashSet<Attribute>();
        attrSet.addAll(Arrays.asList(AttrProtos));
        attrSet.addAll(Arrays.asList(Attributes.getDefaultAttributes()));
        return attrSet.toArray(new Attribute[attrSet.size()]);
    }

    public static void visitShortestInt(CodeVisitor cv, int n) {
        if (n >= 0 && n <= 5) {
            cv.visitInsn(3 + n);
        } else if (n <= 127) {
            cv.visitIntInsn(16, n);
        } else if (n <= Short.MAX_VALUE) {
            cv.visitIntInsn(17, n);
        } else {
            cv.visitIntInsn(17, n & Short.MAX_VALUE);
            cv.visitIntInsn(17, n >> 15 & Short.MAX_VALUE);
            cv.visitIntInsn(16, 15);
            cv.visitInsn(120);
            cv.visitInsn(128);
        }
    }

    public static void loadZero(CodeVisitor cv, Type type) {
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                cv.visitInsn(3);
                break;
            }
            case 7: {
                cv.visitInsn(9);
                break;
            }
            case 6: {
                cv.visitInsn(11);
                break;
            }
            case 8: {
                cv.visitInsn(14);
                break;
            }
            case 9: 
            case 10: {
                cv.visitInsn(1);
                break;
            }
            case 0: {
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"unknown type");
                }
                break;
            }
        }
    }

    public static void unbox(CodeVisitor visitor, Type returnType) {
        switch (returnType.getSort()) {
            case 0: {
                visitor.visitInsn(87);
                break;
            }
            case 10: {
                if (JAVA_LANG_OBJECT.equals(returnType.getInternalName())) break;
                visitor.visitTypeInsn(192, returnType.getInternalName());
                break;
            }
            case 9: {
                visitor.visitTypeInsn(192, returnType.getDescriptor());
                break;
            }
            default: {
                String wrapper = WRAPPER_CLASSES[returnType.getSort()];
                visitor.visitTypeInsn(192, wrapper);
                String method = returnType.getClassName() + "Value";
                visitor.visitMethodInsn(182, wrapper, method, "()" + returnType.getDescriptor());
            }
        }
    }

    public static void createArgumentArray(CodeVisitor visitor, String desc, int localOffset) {
        Type[] argTypes = Type.getArgumentTypes((String)desc);
        AsmUtil.visitShortestInt(visitor, argTypes.length);
        visitor.visitTypeInsn(189, JAVA_LANG_OBJECT);
        int local = localOffset;
        for (int i = 0; i < argTypes.length; ++i) {
            Type type = argTypes[i];
            visitor.visitInsn(89);
            AsmUtil.visitShortestInt(visitor, i);
            AsmUtil.box(visitor, type, local);
            visitor.visitInsn(83);
            local += type.getSize();
        }
    }

    public static void box(CodeVisitor visitor, Type type, int local) {
        if (type.getSort() == 10 || type.getSort() == 9) {
            visitor.visitVarInsn(25, local);
        } else {
            String wrapperName = WRAPPER_CLASSES[type.getSort()];
            visitor.visitTypeInsn(187, wrapperName);
            visitor.visitInsn(89);
            visitor.visitVarInsn(type.getOpcode(21), local);
            visitor.visitMethodInsn(183, wrapperName, CONSTRUCTOR_NAME, "(" + type.getDescriptor() + ")V");
        }
    }

    public static void boxStack(CodeVisitor visitor, Type type) {
        int sort = type.getSort();
        switch (sort) {
            case 0: {
                visitor.visitInsn(1);
            }
            case 9: 
            case 10: {
                visitor.visitInsn(89);
                break;
            }
            case 7: 
            case 8: {
                visitor.visitInsn(92);
                visitor.visitTypeInsn(187, WRAPPER_CLASSES[sort]);
                visitor.visitInsn(89);
                visitor.visitInsn(94);
                visitor.visitInsn(88);
                visitor.visitMethodInsn(183, WRAPPER_CLASSES[sort], CONSTRUCTOR_NAME, "(" + type.getDescriptor() + ")V");
                break;
            }
            default: {
                visitor.visitInsn(89);
                visitor.visitTypeInsn(187, WRAPPER_CLASSES[sort]);
                visitor.visitInsn(89);
                visitor.visitInsn(93);
                visitor.visitInsn(88);
                visitor.visitMethodInsn(183, WRAPPER_CLASSES[sort], CONSTRUCTOR_NAME, "(" + type.getDescriptor() + ")V");
            }
        }
    }

    public static String getWrapperClassName(Type type) {
        if (type.getSort() == 10 || type.getSort() == 9) {
            return type.getInternalName();
        }
        return WRAPPER_CLASSES[type.getSort()].replace('/', '.');
    }

    public static void addAgitarClassLoaderField(ClassVisitor classWriter, boolean isInterface) {
        int pss = (isInterface ? 1 : 2) | 8 | 0x1000 | 0x10;
        classWriter.visitField(pss, CLASS_LOADER_FIELD_NAME, JAVA_LANG_CLASS_LOADER_TYPE.getDescriptor(), null, null);
    }

    public static void initAgitarClassLoaderField(CodeVisitor cv, String className) {
        cv.visitInsn(1);
        cv.visitFieldInsn(179, className, CLASS_LOADER_FIELD_NAME, JAVA_LANG_CLASS_LOADER_TYPE.getDescriptor());
        Label ehStartLabel = new Label();
        cv.visitLabel(ehStartLabel);
        cv.visitLdcInsn((Object)className.replace('/', '.'));
        cv.visitMethodInsn(184, JAVA_LANG_CLASS_TYPE.getInternalName(), "forName", CLASS_FOR_NAME_DESC);
        cv.visitMethodInsn(182, JAVA_LANG_CLASS_TYPE.getInternalName(), "getClassLoader", GET_CLASS_LOADER_DESC);
        cv.visitFieldInsn(179, className, CLASS_LOADER_FIELD_NAME, JAVA_LANG_CLASS_LOADER_TYPE.getDescriptor());
        Label gotoLabel = new Label();
        cv.visitJumpInsn(167, gotoLabel);
        Label ehEndLabel = new Label();
        cv.visitLabel(ehEndLabel);
        cv.visitVarInsn(58, 0);
        cv.visitLabel(gotoLabel);
        cv.visitTryCatchBlock(ehStartLabel, ehEndLabel, ehEndLabel, Type.getType((Class)ClassNotFoundException.class).getInternalName());
    }

    public static void addClinit(ClassVisitor classWriter, String className) {
        CodeVisitor cv = classWriter.visitMethod(8, CLASS_INIT_NAME, "()V", null, null);
        AsmUtil.initAgitarClassLoaderField(cv, className);
        cv.visitInsn(177);
        cv.visitMaxs(0, 0);
    }

    public static boolean canMock(String owner, String name, String methodName) {
        if (name != null && (name.startsWith("$agitar") || name.startsWith("catTwoSynth$")) || methodName != null && methodName.equals(CLASS_INIT_NAME)) {
            return false;
        }
        if (owner == null) {
            return true;
        }
        if (owner.startsWith("com/agitar/") || owner.equals(Type.getType((Class)AssertionError.class).getInternalName())) {
            return false;
        }
        if (name != null && owner.endsWith("java/lang/Class")) {
            return false;
        }
        if (owner.startsWith("java/lang/reflect")) {
            return false;
        }
        if (owner.endsWith("java/lang/ClassLoader")) {
            return false;
        }
        return !ClassName.BOXED_PRIMITIVE_STRINGS.contains(owner.replace('/', '.')) || name != null && !name.equals(CONSTRUCTOR_NAME);
    }

    static {
        $assertionsDisabled = !AsmUtil.class.desiredAssertionStatus();
        WRAPPER_CLASSES = new String[]{"java/lang/Void", "java/lang/Boolean", "java/lang/Character", "java/lang/Byte", "java/lang/Short", "java/lang/Integer", "java/lang/Float", "java/lang/Long", "java/lang/Double"};
        JAVA_LANG_OBJECT_TYPE = Type.getType((Class)Object.class);
        JAVA_LANG_CLASS_TYPE = Type.getType((Class)Class.class);
        JAVA_LANG_CLASS_LOADER_TYPE = Type.getType((Class)ClassLoader.class);
        AttrProtos = new Attribute[]{new SignatureAttribute(), new EnclosingMethodAttribute(), new Attribute("Varargs"){}};
        CLASS_FOR_NAME_DESC = MethodDescription.getDescriptor(new Class[]{String.class}, Class.class);
        GET_CLASS_LOADER_DESC = MethodDescription.getDescriptor(new Class[]{}, ClassLoader.class);
    }

    public static class MethodDescription {
        public final String methodName;
        public final String description;
        public final Type type;
        private final int invokeType;

        public static String getDescriptor(Class[] parameters, Class returnType) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("(");
            for (int i = 0; i < parameters.length; ++i) {
                Class type = parameters[i];
                buffer.append(Type.getType((Class)type).getDescriptor());
            }
            buffer.append(")");
            buffer.append(Type.getType((Class)returnType).getDescriptor());
            return buffer.toString();
        }

        public void visitMethod(CodeVisitor cv) {
            cv.visitMethodInsn(this.invokeType, this.type.getInternalName(), this.methodName, this.description);
        }

        public MethodDescription(Class type, Class[] params) {
            this(type, AsmUtil.CONSTRUCTOR_NAME, params, Void.TYPE, 183);
        }

        public MethodDescription(Class type, String methodName, Class[] params, Class returnType) {
            this(type, methodName, params, returnType, 184);
        }

        public MethodDescription(Class type, String methodName, Class[] params, Class returnType, int invokeType) {
            this.type = Type.getType((Class)type);
            this.methodName = methodName;
            this.description = MethodDescription.getDescriptor(params, returnType);
            this.invokeType = invokeType;
            if (methodName.equals(AsmUtil.CLASS_INIT_NAME)) {
                if (methodName.equals(AsmUtil.CONSTRUCTOR_NAME)) {
                    try {
                        type.getConstructor(params);
                    }
                    catch (Throwable e) {
                        throw new Error(e);
                    }
                }
                try {
                    Method declaredMethod = type.getDeclaredMethod(methodName, params);
                    if (!declaredMethod.getReturnType().equals(returnType)) {
                        throw new Error("Return type mismatch. Expected: '" + declaredMethod.getReturnType().getName() + "' Actual: '" + returnType.getName() + "'");
                    }
                }
                catch (Throwable e) {
                    throw new Error(e);
                }
            }
        }
    }
}

