/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.asm;

import com.agitar.common.asm.ClassInstrumenter;
import com.agitar.common.types.TypeName;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.CodeVisitor;

public class AbstractClassInstrumenter
implements ClassInstrumenter {
    private int access;
    private ClassVisitor next;
    private String className;
    private boolean isEnum;
    private static final int CANT = 5376;

    public void setNext(ClassVisitor next) {
        this.next = next;
    }

    public final void visit(int access, String name, String superName, String[] interfaces, String sourceFile) {
        throw new Error("bad method");
    }

    public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
        this.next.visit(version, access, name, superName, interfaces, sourceFile);
        this.isEnum = superName != null && superName.equals("java/lang/Enum");
        this.className = name;
        this.access = access;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.next.visitInnerClass(name, outerName, innerName, access);
    }

    public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
        this.next.visitField(access, name, desc, value, attrs);
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        return this.next.visitMethod(access, name, desc, exceptions, attrs);
    }

    public void visitAttribute(Attribute attr) {
        this.next.visitAttribute(attr);
    }

    public void visitEnd() {
        this.next.visitEnd();
    }

    protected ClassVisitor getNextVisitor() {
        return this.next;
    }

    protected ClassInstrumenter getNextInstrumenter() {
        return (ClassInstrumenter)this.next;
    }

    protected String getSlashedClassName() {
        return this.className;
    }

    protected String getDottedClassName() {
        return this.className.replace('/', '.');
    }

    protected boolean isInstrumentable(int access, String methodName) {
        return (0x1500 & access) == 0 && !"<clinit>".equals(methodName) && (!"<init>".equals(methodName) || !TypeName.get(this.className).isAnonymous()) && (!this.isEnum || !"values".equals(methodName) && !"valueOf".equals(methodName));
    }

    protected int getAccess() {
        return this.access;
    }
}

