/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils.ilsdb;

import com.vs.ils.ilsdb.Domain;
import com.vs.ils.ilsdb.Product;
import com.vs.wdo.rtl.WdoBaseClass;
import com.vs.wdo.rtl.WdoBaseException;
import com.vs.wdo.rtl.WdoBaseFirstClass;
import com.vs.wdo.rtl.WdoCacheContainer;
import com.vs.wdo.rtl.WdoObjectChangedOrDeletedException;
import com.vs.wdo.rtl.WdoReadIterator;
import com.vs.wdo.rtl.WdoSeq;
import com.vs.wdo.rtl.WdoStmt;
import com.vs.wdo.rtl.WdoTransaction;
import com.vs.wdo.rtl.WdoXmlUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DomLicPCache
implements WdoBaseFirstClass,
Cloneable {
    private static final String readStateSqlText = "select domainName, licenseLimit, highWatermark, checkoutHiWatermark, checkoutActualHiWatermark, disabledUserHiWatermark, peakUsageSample, anonDomain, productId, productName, updateTs from t_DomLicPCache where domainId = ? ";
    private static final String writeStateSqlText = "update t_DomLicPCache set domainName = ?, licenseLimit = ?, highWatermark = ?, checkoutHiWatermark = ?, checkoutActualHiWatermark = ?, disabledUserHiWatermark = ?, peakUsageSample = ?, anonDomain = ?, productId = ?, productName = ?, updateTs = ? where domainId = ? ";
    private static final String CreateSqlText = "insert into t_DomLicPCache ( domainId, domainName, licenseLimit, highWatermark, checkoutHiWatermark, checkoutActualHiWatermark, disabledUserHiWatermark, peakUsageSample, anonDomain, productId, productName, updateTs ) values ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String DropSqlText = "delete from t_DomLicPCache where domainId  = ?";
    private static final String GetListSqlText = "select domainId, domainName, licenseLimit, highWatermark, checkoutHiWatermark, checkoutActualHiWatermark, disabledUserHiWatermark, peakUsageSample, anonDomain, productId, productName, updateTs from t_DomLicPCache";
    private static final String CreateEntitySqlText = "create cached table t_DomLicPCache( \t\tdomainId bigint not null,  \t\tdomainName varchar(50) not null,         licenseLimit bigint default 0 not null,         highWatermark bigint default 0 not null,         checkoutHiWatermark bigint default 0 not null,         checkoutActualHiWatermark bigint default 0 not null,         disabledUserHiWatermark bigint default 0 not null,         peakUsageSample bigint default 0 not null,         anonDomain char default '0' not null,  \t\tproductId bigint not null,  \t\tproductName varchar(50) not null,  \t\tupdateTs bigint not null,  \t\tconstraint pk_t_DomLicPCache primary key (domainId),         constraint fk_t_DomLicPCache_t_Domain foreign key (domainId) references t_Domain(domainId) on delete cascade,         constraint fk_t_DomLicPCache_t_Product foreign key (productId) references t_Product(productId) on delete cascade) ";
    private static final String AddEntrySqlText = "insert into t_DomLicPCache(domainId, domainName, productId, productName, anonDomain, updateTs) values (?,?,?,?,?,?)";
    protected Long domainId = null;
    protected String domainName = null;
    protected boolean domainName_isDirty = false;
    protected Long licenseLimit = new Long(0L);
    protected boolean licenseLimit_isDirty = false;
    protected Long highWatermark = new Long(0L);
    protected boolean highWatermark_isDirty = false;
    protected Long checkoutHiWatermark = new Long(0L);
    protected boolean checkoutHiWatermark_isDirty = false;
    protected Long checkoutActualHiWatermark = new Long(0L);
    protected boolean checkoutActualHiWatermark_isDirty = false;
    protected Long disabledUserHiWatermark = new Long(0L);
    protected boolean disabledUserHiWatermark_isDirty = false;
    protected Long peakUsageSample = new Long(0L);
    protected boolean peakUsageSample_isDirty = false;
    protected String anonDomain = "0";
    protected boolean anonDomain_isDirty = false;
    protected Long productId = null;
    protected boolean productId_isDirty = false;
    protected String productName = null;
    protected boolean productName_isDirty = false;
    protected Long updateTs = null;
    protected boolean updateTs_isDirty = false;
    protected boolean isValid = false;
    protected boolean isDirty = false;
    protected WdoCacheContainer cacheContainer = null;
    protected WdoTransaction transactionObject = null;

    public static DomLicPCache Load(long l, long l2) throws WdoBaseException {
        DomLicPCache domLicPCache = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            domLicPCache = DomLicPCache.GetDomLicPCache(l);
            domLicPCache.getLicenseLimit();
        }
        catch (WdoObjectChangedOrDeletedException wdoObjectChangedOrDeletedException) {
            bl = true;
        }
        catch (WdoBaseException wdoBaseException) {
            bl2 = true;
            bl = true;
        }
        if (bl2) {
            DomLicPCache.CreateEntity();
        }
        if (bl) {
            Domain domain = Domain.GetDomain(l);
            Product product = Product.GetProduct(domain.getProductId());
            DomLicPCache.AddEntry(l, domain.getName(), product.getProductId(), product.getName(), domain.getLicenseModel().equals("NUSER"), l2);
            domLicPCache = DomLicPCache.GetDomLicPCache(l);
        }
        return domLicPCache;
    }

    public long getDomainId() throws WdoBaseException {
        if (this.domainId == null && !this.getIsValid()) {
            this.readStateSync();
        }
        if (this.domainId == null) {
            WdoBaseException.ThrowProxyWdoException((int)10, (String)"Attempt to access undefined attribute 'domainId' of class 'DomLicPCache'");
        }
        return this.domainId;
    }

    public void setDomainId(long l) throws WdoBaseException {
        if (this.domainId != null && this.domainId.intValue() != 0) {
            WdoBaseException.ThrowProxyWdoException((int)10, (String)"Attempt to mutate defined and non-updateable unique attribute 'domainId' of class 'DomLicPCache'");
        }
        this.domainId = new Long(l);
    }

    public boolean domainIdIsDefined() throws WdoBaseException {
        return this.domainId != null;
    }

    public void domainIdUndefine() throws WdoBaseException {
        this.domainId = null;
    }

    public String getDomainName() throws WdoBaseException {
        if (this.domainName == null && !this.getIsValid()) {
            this.readStateSync();
        }
        if (this.domainName == null) {
            WdoBaseException.ThrowProxyWdoException((int)10, (String)"Attempt to access undefined attribute 'domainName' of class 'DomLicPCache'");
        }
        return this.domainName;
    }

    public void setDomainName(String string) throws WdoBaseException {
        if (!this.getIsValid()) {
            this.readStateSync();
        }
        this.domainName = string;
        this.domainName_isDirty = true;
        WdoTransaction wdoTransaction = this.getTransaction();
        wdoTransaction.inTransaction();
        WdoTransaction.ReturnTransactionObjectRef((WdoTransaction)wdoTransaction);
        this.setIsDirty(true);
    }

    public boolean domainNameIsDefined() throws WdoBaseException {
        if (!this.getIsValid()) {
            this.readStateSync();
        }
        return this.domainName != null;
    }

    public void domainNameUndefine() throws WdoBaseException {
        this.domainName = null;
    }

    public boolean domainNameIsDirty() {
        return this.domainName_isDirty;
    }

    public long getLicenseLimit() throws WdoBaseException {
        if ((this.licenseLimit == null || this.licenseLimit.equals(new Long(0L))) && !this.getIsValid()) {
            this.readStateSync();
        }
        if (this.licenseLimit == null) {
            WdoBaseException.ThrowProxyWdoException((int)10, (String)"Attempt to access undefined attribute 'licenseLimit' of class 'DomLicPCache'");
        }
        return this.licenseLimit;
    }

    public void setLicenseLimit(long l) throws WdoBaseException {
        if (!this.getIsValid()) {
            this.readStateSync();
        }
        this.licenseLimit = new Long(l);
        this.licenseLimit_isDirty = true;
        WdoTransaction wdoTransaction = this.getTransaction();
        wdoTransaction.inTransaction();
        WdoTransaction.ReturnTransactionObjectRef((WdoTransaction)wdoTransaction);
        this.setIsDirty(true);
    }

    public boolean licenseLimitIsDefined() throws WdoBaseException {
        if (!this.getIsValid()) {
            this.readStateSync();
        }
        return this.licenseLimit != null;
    }

    public void licenseLimitUndefine() throws WdoBaseException {
        this.licenseLimit = null;
    }

    public boolean licenseLimitIsDirty() {
        return this.licenseLimit_isDirty;
    }

    public long getHighWatermark() throws WdoBaseException {
        if ((this.highWatermark == null || this.highWatermark.equals(new Long(0L))) && !this.getIsValid()) {
            this.readStateSync();
        }
        if (this.highWatermark == null) {
            WdoBaseException.ThrowProxyWdoException((int)10, (String)"Attempt to access undefined attribute 'highWatermark' of class 'DomLicPCache'");
        }
        return this.highWatermark;
    }

    public void setHighWatermark(long l) throws WdoBaseException {
        if (!this.getIsValid()) {
            this.readStateSync();
        }
        this.highWatermark = new Long(l);
        this.highWatermark_isDirty = true;
        WdoTransaction wdoTransaction = this.getTransaction();
        wdoTransaction.inTransaction();
        WdoTransaction.ReturnTransactionObjectRef((WdoTransaction)wdoTransaction);
        this.setIsDirty(true);
    }

    public boolean highWatermarkIsDefined() throws WdoBaseException {
        if (!this.getIsValid()) {
            this.readStateSync();
        }
        return this.highWatermark != null;
    }

    public void highWatermarkUndefine() throws WdoBaseException {
        this.highWatermark = null;
    }

    public boolean highWatermarkIsDirty() {
        return this.highWatermark_isDirty;
    }

    public long getCheckoutHiWatermark() throws WdoBaseException {
        if ((this.checkoutHiWatermark == null || this.checkoutHiWatermark.equals(new Long(0L))) && !this.getIsValid()) {
            this.readStateSync();
        }
        if (this.checkoutHiWatermark == null) {
            WdoBaseException.ThrowProxyWdoException((int)10, (String)"Attempt to access undefined attribute 'checkoutHiWatermark' of class 'DomLicPCache'");
        }
        return this.checkoutHiWatermark;
    }

    public void setCheckoutHiWatermark(long l) throws WdoBaseException {
        if (!this.getIsValid()) {
            this.readStateSync();
        }
        this.checkoutHiWatermark = new Long(l);
        this.checkoutHiWatermark_isDirty = true;
        WdoTransaction wdoTransaction = this.getTransaction();
        wdoTransaction.inTransaction();
        WdoTransaction.ReturnTransactionObjectRef((WdoTransaction)wdoTransaction);
        this.setIsDirty(true);
    }

    public boolean checkoutHiWatermarkIsDefined() throws WdoBaseException {
        if (!this.getIsValid()) {
            this.readStateSync();
        }
        return this.checkoutHiWatermark != null;
    }

    public void checkoutHiWatermarkUndefine() throws WdoBaseException {
        this.checkoutHiWatermark = null;
    }

    public boolean checkoutHiWatermarkIsDirty() {
        return this.checkoutHiWatermark_isDirty;
    }

    public long getCheckoutActualHiWatermark() throws WdoBaseException {
        if ((this.checkoutActualHiWatermark == null || this.checkoutActualHiWatermark.equals(new Long(0L))) && !this.getIsValid()) {
            this.readStateSync();
        }
        if (this.checkoutActualHiWatermark == null) {
            WdoBaseException.ThrowProxyWdoException((int)10, (String)"Attempt to access undefined attribute 'checkoutActualHiWatermark' of class 'DomLicPCache'");
        }
        return this.checkoutActualHiWatermark;
    }

    public void setCheckoutActualHiWatermark(long l) throws WdoBaseException {
        if (!this.getIsValid()) {
            this.readStateSync();
        }
        this.checkoutActualHiWatermark = new Long(l);
        this.checkoutActualHiWatermark_isDirty = true;
        WdoTransaction wdoTransaction = this.getTransaction();
        wdoTransaction.inTransaction();
        WdoTransaction.ReturnTransactionObjectRef((WdoTransaction)wdoTransaction);
        this.setIsDirty(true);
    }

    public boolean checkoutActualHiWatermarkIsDefined() throws WdoBaseException {
        if (!this.getIsValid()) {
            this.readStateSync();
        }
        return this.checkoutActualHiWatermark != null;
    }

    public void checkoutActualHiWatermarkUndefine() throws WdoBaseException {
        this.checkoutActualHiWatermark = null;
    }

    public boolean checkoutActualHiWatermarkIsDirty() {
        return this.checkoutActualHiWatermark_isDirty;
    }

    public long getDisabledUserHiWatermark() throws WdoBaseException {
        if ((this.disabledUserHiWatermark == null || this.disabledUserHiWatermark.equals(new Long(0L))) && !this.getIsValid()) {
            this.readStateSync();
        }
        if (this.disabledUserHiWatermark == null) {
            WdoBaseException.ThrowProxyWdoException((int)10, (String)"Attempt to access undefined attribute 'disabledUserHiWatermark' of class 'DomLicPCache'");
        }
        return this.disabledUserHiWatermark;
    }

    public void setDisabledUserHiWatermark(long l) throws WdoBaseException {
        if (!this.getIsValid()) {
            this.readStateSync();
        }
        this.disabledUserHiWatermark = new Long(l);
        this.disabledUserHiWatermark_isDirty = true;
        WdoTransaction wdoTransaction = this.getTransaction();
        wdoTransaction.inTransaction();
        WdoTransaction.ReturnTransactionObjectRef((WdoTransaction)wdoTransaction);
        this.setIsDirty(true);
    }

    public boolean disabledUserHiWatermarkIsDefined() throws WdoBaseException {
        if (!this.getIsValid()) {
            this.readStateSync();
        }
        return this.disabledUserHiWatermark != null;
    }

    public void disabledUserHiWatermarkUndefine() throws WdoBaseException {
        this.disabledUserHiWatermark = null;
    }

    public boolean disabledUserHiWatermarkIsDirty() {
        return this.disabledUserHiWatermark_isDirty;
    }

    public long getPeakUsageSample() throws WdoBaseException {
        if ((this.peakUsageSample == null || this.peakUsageSample.equals(new Long(0L))) && !this.getIsValid()) {
            this.readStateSync();
        }
        if (this.peakUsageSample == null) {
            WdoBaseException.ThrowProxyWdoException((int)10, (String)"Attempt to access undefined attribute 'peakUsageSample' of class 'DomLicPCache'");
        }
        return this.peakUsageSample;
    }

    public void setPeakUsageSample(long l) throws WdoBaseException {
        if (!this.getIsValid()) {
            this.readStateSync();
        }
        this.peakUsageSample = new Long(l);
        this.peakUsageSample_isDirty = true;
        WdoTransaction wdoTransaction = this.getTransaction();
        wdoTransaction.inTransaction();
        WdoTransaction.ReturnTransactionObjectRef((WdoTransaction)wdoTransaction);
        this.setIsDirty(true);
    }

    public boolean peakUsageSampleIsDefined() throws WdoBaseException {
        if (!this.getIsValid()) {
            this.readStateSync();
        }
        return this.peakUsageSample != null;
    }

    public void peakUsageSampleUndefine() throws WdoBaseException {
        this.peakUsageSample = null;
    }

    public boolean peakUsageSampleIsDirty() {
        return this.peakUsageSample_isDirty;
    }

    public boolean getAnonDomain() throws WdoBaseException {
        if ((this.anonDomain == null || this.anonDomain.equals("0")) && !this.getIsValid()) {
            this.readStateSync();
        }
        if (this.anonDomain == null) {
            WdoBaseException.ThrowProxyWdoException((int)10, (String)"Attempt to access undefined attribute 'anonDomain' of class 'DomLicPCache'");
        }
        return this.anonDomain.charAt(0) == '1';
    }

    public void setAnonDomain(boolean bl) throws WdoBaseException {
        if (!this.getIsValid()) {
            this.readStateSync();
        }
        this.anonDomain = new String(String.valueOf(bl ? (char)'1' : '0'));
        this.anonDomain_isDirty = true;
        WdoTransaction wdoTransaction = this.getTransaction();
        wdoTransaction.inTransaction();
        WdoTransaction.ReturnTransactionObjectRef((WdoTransaction)wdoTransaction);
        this.setIsDirty(true);
    }

    public boolean anonDomainIsDefined() throws WdoBaseException {
        if (!this.getIsValid()) {
            this.readStateSync();
        }
        return this.anonDomain != null;
    }

    public void anonDomainUndefine() throws WdoBaseException {
        this.anonDomain = null;
    }

    public boolean anonDomainIsDirty() {
        return this.anonDomain_isDirty;
    }

    public long getProductId() throws WdoBaseException {
        if (this.productId == null && !this.getIsValid()) {
            this.readStateSync();
        }
        if (this.productId == null) {
            WdoBaseException.ThrowProxyWdoException((int)10, (String)"Attempt to access undefined attribute 'productId' of class 'DomLicPCache'");
        }
        return this.productId;
    }

    public void setProductId(long l) throws WdoBaseException {
        if (!this.getIsValid()) {
            this.readStateSync();
        }
        this.productId = new Long(l);
        this.productId_isDirty = true;
        WdoTransaction wdoTransaction = this.getTransaction();
        wdoTransaction.inTransaction();
        WdoTransaction.ReturnTransactionObjectRef((WdoTransaction)wdoTransaction);
        this.setIsDirty(true);
    }

    public boolean productIdIsDefined() throws WdoBaseException {
        if (!this.getIsValid()) {
            this.readStateSync();
        }
        return this.productId != null;
    }

    public void productIdUndefine() throws WdoBaseException {
        this.productId = null;
    }

    public boolean productIdIsDirty() {
        return this.productId_isDirty;
    }

    public String getProductName() throws WdoBaseException {
        if (this.productName == null && !this.getIsValid()) {
            this.readStateSync();
        }
        if (this.productName == null) {
            WdoBaseException.ThrowProxyWdoException((int)10, (String)"Attempt to access undefined attribute 'productName' of class 'DomLicPCache'");
        }
        return this.productName;
    }

    public void setProductName(String string) throws WdoBaseException {
        if (!this.getIsValid()) {
            this.readStateSync();
        }
        this.productName = string;
        this.productName_isDirty = true;
        WdoTransaction wdoTransaction = this.getTransaction();
        wdoTransaction.inTransaction();
        WdoTransaction.ReturnTransactionObjectRef((WdoTransaction)wdoTransaction);
        this.setIsDirty(true);
    }

    public boolean productNameIsDefined() throws WdoBaseException {
        if (!this.getIsValid()) {
            this.readStateSync();
        }
        return this.productName != null;
    }

    public void productNameUndefine() throws WdoBaseException {
        this.productName = null;
    }

    public boolean productNameIsDirty() {
        return this.productName_isDirty;
    }

    public long getUpdateTs() throws WdoBaseException {
        if (this.updateTs == null && !this.getIsValid()) {
            this.readStateSync();
        }
        if (this.updateTs == null) {
            WdoBaseException.ThrowProxyWdoException((int)10, (String)"Attempt to access undefined attribute 'updateTs' of class 'DomLicPCache'");
        }
        return this.updateTs;
    }

    public void setUpdateTs(long l) throws WdoBaseException {
        if (!this.getIsValid()) {
            this.readStateSync();
        }
        this.updateTs = new Long(l);
        this.updateTs_isDirty = true;
        WdoTransaction wdoTransaction = this.getTransaction();
        wdoTransaction.inTransaction();
        WdoTransaction.ReturnTransactionObjectRef((WdoTransaction)wdoTransaction);
        this.setIsDirty(true);
    }

    public boolean updateTsIsDefined() throws WdoBaseException {
        if (!this.getIsValid()) {
            this.readStateSync();
        }
        return this.updateTs != null;
    }

    public void updateTsUndefine() throws WdoBaseException {
        this.updateTs = null;
    }

    public boolean updateTsIsDirty() {
        return this.updateTs_isDirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void CreateEntity() throws WdoBaseException {
        block19: {
            boolean bl;
            Statement statement;
            WdoTransaction wdoTransaction;
            block17: {
                Connection connection = null;
                wdoTransaction = null;
                statement = null;
                bl = false;
                wdoTransaction = WdoTransaction.GetTransactionObject();
                connection = wdoTransaction.getConnection("sdainternal", "development");
                bl = wdoTransaction.getCount() == 1;
                statement = connection.prepareStatement(CreateEntitySqlText);
                WdoStmt wdoStmt = new WdoStmt(CreateEntitySqlText, (PreparedStatement)statement);
                statement.execute();
                wdoTransaction.inTransaction();
                statement.close();
                statement = null;
                if (bl) {
                    wdoTransaction.commit();
                }
                WdoTransaction.ReturnTransactionObject((WdoTransaction)wdoTransaction);
                wdoTransaction = null;
                Object var6_6 = null;
                if (statement == null) break block17;
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (wdoTransaction != null && bl) {
                wdoTransaction.rollback();
            }
            if (wdoTransaction != null) {
                WdoTransaction.ReturnTransactionObject((WdoTransaction)wdoTransaction);
            }
            break block19;
            {
                catch (SQLException sQLException) {
                    WdoBaseException.ThrowJdbcDbException((SQLException)sQLException);
                    Object var6_7 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (wdoTransaction != null && bl) {
                        wdoTransaction.rollback();
                    }
                    if (wdoTransaction != null) {
                        WdoTransaction.ReturnTransactionObject((WdoTransaction)wdoTransaction);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (wdoTransaction != null && bl) {
                    wdoTransaction.rollback();
                }
                if (wdoTransaction != null) {
                    WdoTransaction.ReturnTransactionObject((WdoTransaction)wdoTransaction);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void AddEntry(long l, String string, long l2, String string2, boolean bl, long l3) throws WdoBaseException {
        block19: {
            boolean bl2;
            Statement statement;
            WdoTransaction wdoTransaction;
            block17: {
                Connection connection = null;
                wdoTransaction = null;
                statement = null;
                bl2 = false;
                wdoTransaction = WdoTransaction.GetTransactionObject();
                connection = wdoTransaction.getConnection("sdainternal", "development");
                bl2 = wdoTransaction.getCount() == 1;
                statement = connection.prepareStatement(AddEntrySqlText);
                WdoStmt wdoStmt = new WdoStmt(AddEntrySqlText, (PreparedStatement)statement);
                int n = 1;
                statement.setLong(n++, l);
                statement.setString(n++, string);
                statement.setLong(n++, l2);
                statement.setString(n++, string2);
                statement.setString(n++, String.valueOf(bl ? (char)'1' : '0'));
                statement.setLong(n++, l3);
                statement.execute();
                wdoTransaction.inTransaction();
                statement.close();
                statement = null;
                if (bl2) {
                    wdoTransaction.commit();
                }
                WdoTransaction.ReturnTransactionObject((WdoTransaction)wdoTransaction);
                wdoTransaction = null;
                Object var16_13 = null;
                if (statement == null) break block17;
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (wdoTransaction != null && bl2) {
                wdoTransaction.rollback();
            }
            if (wdoTransaction != null) {
                WdoTransaction.ReturnTransactionObject((WdoTransaction)wdoTransaction);
            }
            break block19;
            {
                catch (SQLException sQLException) {
                    WdoBaseException.ThrowJdbcDbException((SQLException)sQLException);
                    Object var16_14 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (wdoTransaction != null && bl2) {
                        wdoTransaction.rollback();
                    }
                    if (wdoTransaction != null) {
                        WdoTransaction.ReturnTransactionObject((WdoTransaction)wdoTransaction);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var16_15 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (wdoTransaction != null && bl2) {
                    wdoTransaction.rollback();
                }
                if (wdoTransaction != null) {
                    WdoTransaction.ReturnTransactionObject((WdoTransaction)wdoTransaction);
                }
                throw throwable;
            }
        }
    }

    public long getId() throws WdoBaseException {
        return this.getDomainId();
    }

    public void setId(long l) throws WdoBaseException {
        this.setDomainId(l);
    }

    public static DomLicPCache GetDomLicPCache(long l) throws WdoBaseException {
        DomLicPCache domLicPCache = null;
        try {
            domLicPCache = new DomLicPCache();
            domLicPCache.setId(l);
        }
        catch (Exception exception) {
            WdoBaseException.ThrowProxyWdoException((int)10, (String)"Illegal or failed instantiation of eXoDy first class.\nPlease check your package specification and your access control on any inherited application classes.");
        }
        return domLicPCache;
    }

    public static WdoBaseFirstClass Get(long l) throws WdoBaseException {
        DomLicPCache domLicPCache = null;
        try {
            domLicPCache = new DomLicPCache();
            domLicPCache.setId(l);
        }
        catch (Exception exception) {
            WdoBaseException.ThrowProxyWdoException((int)10, (String)"Illegal or failed instantiation of eXoDy first class.\nPlease check your package specification and your access control on any inherited application classes.");
        }
        return domLicPCache;
    }

    public static DomLicPCache GetDomLicPCache() throws WdoBaseException {
        DomLicPCache domLicPCache = null;
        try {
            domLicPCache = new DomLicPCache();
            domLicPCache.setId(0L);
            domLicPCache.setIsValid(true);
        }
        catch (Exception exception) {
            WdoBaseException.ThrowProxyWdoException((int)10, (String)"Illegal or failed instantiation of eXoDy first class.\nPlease check your package specification and your access control on any inherited application classes.");
        }
        return domLicPCache;
    }

    public static WdoBaseFirstClass Get() throws WdoBaseException {
        DomLicPCache domLicPCache = null;
        try {
            domLicPCache = new DomLicPCache();
            domLicPCache.setId(0L);
            domLicPCache.setIsValid(true);
        }
        catch (Exception exception) {
            WdoBaseException.ThrowProxyWdoException((int)10, (String)"Illegal or failed instantiation of eXoDy first class.\nPlease check your package specification and your access control on any inherited application classes.");
        }
        return domLicPCache;
    }

    public static DomLicPCache Get(long l, String string) throws WdoBaseException {
        DomLicPCache domLicPCache = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            WdoBaseException.ThrowProxyWdoException((int)10, (String)("Invalid class name '" + string + "' specified for Get() factory method."));
        }
        try {
            domLicPCache = (DomLicPCache)clazz.newInstance();
            domLicPCache.setId(l);
        }
        catch (Exception exception) {
            WdoBaseException.ThrowProxyWdoException((int)10, (String)"Illegal or failed instantiation of eXoDy first class.\nPlease check your package specification and your access control on any inherited application classes.");
        }
        return domLicPCache;
    }

    public static DomLicPCache Get(String string) throws WdoBaseException {
        DomLicPCache domLicPCache = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            WdoBaseException.ThrowProxyWdoException((int)10, (String)("Invalid class name '" + string + "' specified for Get() factory method."));
        }
        try {
            domLicPCache = (DomLicPCache)clazz.newInstance();
            domLicPCache.setId(0L);
            domLicPCache.setIsValid(true);
        }
        catch (Exception exception) {
            WdoBaseException.ThrowProxyWdoException((int)10, (String)"Illegal or failed instantiation of eXoDy first class.\nPlease check your package specification and your access control on any inherited application classes.");
        }
        return domLicPCache;
    }

    public void clearState() {
        this.domainId = null;
        this.domainName_isDirty = false;
        this.domainName = null;
        this.licenseLimit_isDirty = false;
        this.licenseLimit = new Long(0L);
        this.highWatermark_isDirty = false;
        this.highWatermark = new Long(0L);
        this.checkoutHiWatermark_isDirty = false;
        this.checkoutHiWatermark = new Long(0L);
        this.checkoutActualHiWatermark_isDirty = false;
        this.checkoutActualHiWatermark = new Long(0L);
        this.disabledUserHiWatermark_isDirty = false;
        this.disabledUserHiWatermark = new Long(0L);
        this.peakUsageSample_isDirty = false;
        this.peakUsageSample = new Long(0L);
        this.anonDomain_isDirty = false;
        this.anonDomain = "0";
        this.productId_isDirty = false;
        this.productId = null;
        this.productName_isDirty = false;
        this.productName = null;
        this.updateTs_isDirty = false;
        this.updateTs = null;
    }

    public void clearStatePartial() {
        this.domainName_isDirty = false;
        this.domainName = null;
        this.licenseLimit_isDirty = false;
        this.licenseLimit = new Long(0L);
        this.highWatermark_isDirty = false;
        this.highWatermark = new Long(0L);
        this.checkoutHiWatermark_isDirty = false;
        this.checkoutHiWatermark = new Long(0L);
        this.checkoutActualHiWatermark_isDirty = false;
        this.checkoutActualHiWatermark = new Long(0L);
        this.disabledUserHiWatermark_isDirty = false;
        this.disabledUserHiWatermark = new Long(0L);
        this.peakUsageSample_isDirty = false;
        this.peakUsageSample = new Long(0L);
        this.anonDomain_isDirty = false;
        this.anonDomain = "0";
        this.productId_isDirty = false;
        this.productId = null;
        this.productName_isDirty = false;
        this.productName = null;
        this.updateTs_isDirty = false;
        this.updateTs = null;
    }

    public void checkState() throws WdoBaseException {
        if (!this.domainIdIsDefined()) {
            WdoBaseException.ThrowProxyWdoException((int)2, (String)"Undefined attribute: domainId");
        }
        if (!this.domainNameIsDefined()) {
            WdoBaseException.ThrowProxyWdoException((int)2, (String)"Undefined attribute: domainName");
        }
        if (!this.licenseLimitIsDefined()) {
            WdoBaseException.ThrowProxyWdoException((int)2, (String)"Undefined attribute: licenseLimit");
        }
        if (!this.highWatermarkIsDefined()) {
            WdoBaseException.ThrowProxyWdoException((int)2, (String)"Undefined attribute: highWatermark");
        }
        if (!this.checkoutHiWatermarkIsDefined()) {
            WdoBaseException.ThrowProxyWdoException((int)2, (String)"Undefined attribute: checkoutHiWatermark");
        }
        if (!this.checkoutActualHiWatermarkIsDefined()) {
            WdoBaseException.ThrowProxyWdoException((int)2, (String)"Undefined attribute: checkoutActualHiWatermark");
        }
        if (!this.disabledUserHiWatermarkIsDefined()) {
            WdoBaseException.ThrowProxyWdoException((int)2, (String)"Undefined attribute: disabledUserHiWatermark");
        }
        if (!this.peakUsageSampleIsDefined()) {
            WdoBaseException.ThrowProxyWdoException((int)2, (String)"Undefined attribute: peakUsageSample");
        }
        if (!this.anonDomainIsDefined()) {
            WdoBaseException.ThrowProxyWdoException((int)2, (String)"Undefined attribute: anonDomain");
        }
        if (!this.productIdIsDefined()) {
            WdoBaseException.ThrowProxyWdoException((int)2, (String)"Undefined attribute: productId");
        }
        if (!this.productNameIsDefined()) {
            WdoBaseException.ThrowProxyWdoException((int)2, (String)"Undefined attribute: productName");
        }
        if (!this.updateTsIsDefined()) {
            WdoBaseException.ThrowProxyWdoException((int)2, (String)"Undefined attribute: updateTs");
        }
    }

    public void cleanState() {
        this.domainName_isDirty = false;
        this.licenseLimit_isDirty = false;
        this.highWatermark_isDirty = false;
        this.checkoutHiWatermark_isDirty = false;
        this.checkoutActualHiWatermark_isDirty = false;
        this.disabledUserHiWatermark_isDirty = false;
        this.peakUsageSample_isDirty = false;
        this.anonDomain_isDirty = false;
        this.productId_isDirty = false;
        this.productName_isDirty = false;
        this.updateTs_isDirty = false;
    }

    public Object clone() {
        DomLicPCache domLicPCache = null;
        try {
            domLicPCache = (DomLicPCache)super.clone();
        }
        catch (Exception exception) {
            domLicPCache = null;
        }
        return domLicPCache;
    }

    public static Object FromXML(Element element, boolean bl) throws WdoBaseException {
        if (!element.getTagName().equals("DomLicPCache")) {
            WdoBaseException.ThrowProxyWdoException((int)10, (String)("Attempt to instantiate eXoDy class DomLicPCache from mismatched DOM tree element " + element.getTagName()));
        }
        DomLicPCache domLicPCache = new DomLicPCache();
        domLicPCache.setAttrsFromXML(element, bl);
        return domLicPCache;
    }

    void setAttrsFromXML(Element element, boolean bl) throws WdoBaseException {
        HashMap hashMap = WdoXmlUtil.MakeElementMap((Element)element, (boolean)bl);
        Element element2 = null;
        element2 = (Element)hashMap.get("domainName");
        if (element2 != null) {
            WdoXmlUtil.CheckDatatypeAttr((Element)element2, (String)"String");
            WdoXmlUtil.CheckDimensionAttr((Element)element2, (int)50);
            this.domainName = WdoXmlUtil.GetElementString((Element)element2);
        }
        if ((element2 = (Element)hashMap.get("licenseLimit")) != null) {
            WdoXmlUtil.CheckDatatypeAttr((Element)element2, (String)"long");
            this.licenseLimit = new Long(WdoXmlUtil.GetElementString((Element)element2));
        }
        if ((element2 = (Element)hashMap.get("highWatermark")) != null) {
            WdoXmlUtil.CheckDatatypeAttr((Element)element2, (String)"long");
            this.highWatermark = new Long(WdoXmlUtil.GetElementString((Element)element2));
        }
        if ((element2 = (Element)hashMap.get("checkoutHiWatermark")) != null) {
            WdoXmlUtil.CheckDatatypeAttr((Element)element2, (String)"long");
            this.checkoutHiWatermark = new Long(WdoXmlUtil.GetElementString((Element)element2));
        }
        if ((element2 = (Element)hashMap.get("checkoutActualHiWatermark")) != null) {
            WdoXmlUtil.CheckDatatypeAttr((Element)element2, (String)"long");
            this.checkoutActualHiWatermark = new Long(WdoXmlUtil.GetElementString((Element)element2));
        }
        if ((element2 = (Element)hashMap.get("disabledUserHiWatermark")) != null) {
            WdoXmlUtil.CheckDatatypeAttr((Element)element2, (String)"long");
            this.disabledUserHiWatermark = new Long(WdoXmlUtil.GetElementString((Element)element2));
        }
        if ((element2 = (Element)hashMap.get("peakUsageSample")) != null) {
            WdoXmlUtil.CheckDatatypeAttr((Element)element2, (String)"long");
            this.peakUsageSample = new Long(WdoXmlUtil.GetElementString((Element)element2));
        }
        if ((element2 = (Element)hashMap.get("anonDomain")) != null) {
            WdoXmlUtil.CheckDatatypeAttr((Element)element2, (String)"boolean");
            String string = this.anonDomain = Boolean.valueOf(WdoXmlUtil.GetElementString((Element)element2)) != false ? "1" : "0";
        }
        if ((element2 = (Element)hashMap.get("productName")) != null) {
            WdoXmlUtil.CheckDatatypeAttr((Element)element2, (String)"String");
            WdoXmlUtil.CheckDimensionAttr((Element)element2, (int)50);
            this.productName = WdoXmlUtil.GetElementString((Element)element2);
        }
        if ((element2 = (Element)hashMap.get("updateTs")) != null) {
            WdoXmlUtil.CheckDatatypeAttr((Element)element2, (String)"long");
            this.updateTs = new Long(WdoXmlUtil.GetElementString((Element)element2));
        }
    }

    public void toXML(ContentHandler contentHandler, String string, int n, String string2) throws WdoBaseException, SAXException {
        if (n <= 0) {
            return;
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string == null) {
            string = "";
        }
        String string3 = null;
        AttributesImpl attributesImpl = new AttributesImpl();
        if (!string2.equals("...")) {
            if (!string2.equals("")) {
                attributesImpl.addAttribute(string, "name", "name", "CDATA", string2);
            }
            contentHandler.startElement(string, "DomLicPCache", "DomLicPCache", attributesImpl);
        }
        attributesImpl.clear();
        attributesImpl.addAttribute(string, "datatype", "datatype", "CDATA", "String");
        attributesImpl.addAttribute(string, "dimension", "dimension", "CDATA", "50");
        contentHandler.startElement(string, "domainName", "domainName", attributesImpl);
        string3 = this.getDomainName();
        contentHandler.characters(string3.toCharArray(), 0, string3.length());
        contentHandler.endElement(string, "domainName", "domainName");
        attributesImpl.clear();
        attributesImpl.addAttribute(string, "datatype", "datatype", "CDATA", "long");
        contentHandler.startElement(string, "licenseLimit", "licenseLimit", attributesImpl);
        string3 = String.valueOf(this.getLicenseLimit());
        contentHandler.characters(string3.toCharArray(), 0, string3.length());
        contentHandler.endElement(string, "licenseLimit", "licenseLimit");
        attributesImpl.clear();
        attributesImpl.addAttribute(string, "datatype", "datatype", "CDATA", "long");
        contentHandler.startElement(string, "highWatermark", "highWatermark", attributesImpl);
        string3 = String.valueOf(this.getHighWatermark());
        contentHandler.characters(string3.toCharArray(), 0, string3.length());
        contentHandler.endElement(string, "highWatermark", "highWatermark");
        attributesImpl.clear();
        attributesImpl.addAttribute(string, "datatype", "datatype", "CDATA", "long");
        contentHandler.startElement(string, "checkoutHiWatermark", "checkoutHiWatermark", attributesImpl);
        string3 = String.valueOf(this.getCheckoutHiWatermark());
        contentHandler.characters(string3.toCharArray(), 0, string3.length());
        contentHandler.endElement(string, "checkoutHiWatermark", "checkoutHiWatermark");
        attributesImpl.clear();
        attributesImpl.addAttribute(string, "datatype", "datatype", "CDATA", "long");
        contentHandler.startElement(string, "checkoutActualHiWatermark", "checkoutActualHiWatermark", attributesImpl);
        string3 = String.valueOf(this.getCheckoutActualHiWatermark());
        contentHandler.characters(string3.toCharArray(), 0, string3.length());
        contentHandler.endElement(string, "checkoutActualHiWatermark", "checkoutActualHiWatermark");
        attributesImpl.clear();
        attributesImpl.addAttribute(string, "datatype", "datatype", "CDATA", "long");
        contentHandler.startElement(string, "disabledUserHiWatermark", "disabledUserHiWatermark", attributesImpl);
        string3 = String.valueOf(this.getDisabledUserHiWatermark());
        contentHandler.characters(string3.toCharArray(), 0, string3.length());
        contentHandler.endElement(string, "disabledUserHiWatermark", "disabledUserHiWatermark");
        attributesImpl.clear();
        attributesImpl.addAttribute(string, "datatype", "datatype", "CDATA", "long");
        contentHandler.startElement(string, "peakUsageSample", "peakUsageSample", attributesImpl);
        string3 = String.valueOf(this.getPeakUsageSample());
        contentHandler.characters(string3.toCharArray(), 0, string3.length());
        contentHandler.endElement(string, "peakUsageSample", "peakUsageSample");
        attributesImpl.clear();
        attributesImpl.addAttribute(string, "datatype", "datatype", "CDATA", "boolean");
        contentHandler.startElement(string, "anonDomain", "anonDomain", attributesImpl);
        string3 = String.valueOf(this.getAnonDomain());
        contentHandler.characters(string3.toCharArray(), 0, string3.length());
        contentHandler.endElement(string, "anonDomain", "anonDomain");
        attributesImpl.clear();
        attributesImpl.addAttribute(string, "datatype", "datatype", "CDATA", "String");
        attributesImpl.addAttribute(string, "dimension", "dimension", "CDATA", "50");
        contentHandler.startElement(string, "productName", "productName", attributesImpl);
        string3 = this.getProductName();
        contentHandler.characters(string3.toCharArray(), 0, string3.length());
        contentHandler.endElement(string, "productName", "productName");
        attributesImpl.clear();
        attributesImpl.addAttribute(string, "datatype", "datatype", "CDATA", "long");
        contentHandler.startElement(string, "updateTs", "updateTs", attributesImpl);
        string3 = String.valueOf(this.getUpdateTs());
        contentHandler.characters(string3.toCharArray(), 0, string3.length());
        contentHandler.endElement(string, "updateTs", "updateTs");
        if (!string2.equals("...")) {
            contentHandler.endElement(string, "DomLicPCache", "DomLicPCache");
        }
    }

    public String toXML(int n, String string, boolean bl, String string2) throws WdoBaseException {
        if (n <= 0) {
            return "";
        }
        if (string2 == null) {
            string2 = "";
        }
        String string3 = (bl ? "\n" + string + "<DomLicPCache" + (string2.equals("") ? "" : " name=\"" + string2 + "\"") + ">" : "") + "\n" + string + "  " + "<domainName datatype=\"String\" dimension=\"50\">" + this.getDomainName() + "</domainName>" + "\n" + string + "  " + "<licenseLimit datatype=\"long\">" + String.valueOf(this.getLicenseLimit()) + "</licenseLimit>" + "\n" + string + "  " + "<highWatermark datatype=\"long\">" + String.valueOf(this.getHighWatermark()) + "</highWatermark>" + "\n" + string + "  " + "<checkoutHiWatermark datatype=\"long\">" + String.valueOf(this.getCheckoutHiWatermark()) + "</checkoutHiWatermark>" + "\n" + string + "  " + "<checkoutActualHiWatermark datatype=\"long\">" + String.valueOf(this.getCheckoutActualHiWatermark()) + "</checkoutActualHiWatermark>" + "\n" + string + "  " + "<disabledUserHiWatermark datatype=\"long\">" + String.valueOf(this.getDisabledUserHiWatermark()) + "</disabledUserHiWatermark>" + "\n" + string + "  " + "<peakUsageSample datatype=\"long\">" + String.valueOf(this.getPeakUsageSample()) + "</peakUsageSample>" + "\n" + string + "  " + "<anonDomain datatype=\"boolean\">" + String.valueOf(this.getAnonDomain()) + "</anonDomain>" + "\n" + string + "  " + "<productName datatype=\"String\" dimension=\"50\">" + this.getProductName() + "</productName>" + "\n" + string + "  " + "<updateTs datatype=\"long\">" + String.valueOf(this.getUpdateTs()) + "</updateTs>";
        string3 = string3 + (bl ? "\n" + string + "</DomLicPCache>" : "");
        return string3;
    }

    public String toXML() throws WdoBaseException {
        return this.toXML(1);
    }

    public String toXML(int n) throws WdoBaseException {
        return this.toXML(n, "");
    }

    public String toXML(int n, String string) throws WdoBaseException {
        return this.toXML(n, string, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void readState() throws WdoBaseException {
        block17: {
            Statement statement;
            WdoTransaction wdoTransaction;
            block15: {
                Connection connection = null;
                wdoTransaction = null;
                statement = null;
                wdoTransaction = WdoTransaction.GetTransactionObject();
                connection = wdoTransaction.getConnection("sdainternal", "development");
                if (!this.domainIdIsDefined()) {
                    WdoBaseException.ThrowProxyWdoException((int)10, (String)"Unique id must be defined: domainId");
                }
                statement = connection.prepareStatement(readStateSqlText);
                WdoStmt wdoStmt = new WdoStmt(readStateSqlText, (PreparedStatement)statement);
                int n = 1;
                this.setIsValid(true);
                this.clearStatePartial();
                statement.setLong(n++, this.domainId);
                ResultSet resultSet = wdoStmt.executeQuery();
                if (!resultSet.next()) {
                    WdoBaseException.ThrowProxyWdoException((int)6);
                }
                n = 1;
                this.setDomainName(resultSet.getString(n++));
                this.setLicenseLimit(resultSet.getLong(n++));
                this.setHighWatermark(resultSet.getLong(n++));
                this.setCheckoutHiWatermark(resultSet.getLong(n++));
                this.setCheckoutActualHiWatermark(resultSet.getLong(n++));
                this.setDisabledUserHiWatermark(resultSet.getLong(n++));
                this.setPeakUsageSample(resultSet.getLong(n++));
                this.setAnonDomain(resultSet.getString(n++).charAt(0) == '1');
                this.setProductId(resultSet.getLong(n++));
                this.setProductName(resultSet.getString(n++));
                this.setUpdateTs(resultSet.getLong(n++));
                statement.close();
                statement = null;
                this.setIsDirty(false);
                this.cleanState();
                Object var8_8 = null;
                if (statement == null) break block15;
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (wdoTransaction != null) {
                WdoTransaction.ReturnTransactionObject((WdoTransaction)wdoTransaction);
            }
            break block17;
            {
                catch (SQLException sQLException) {
                    this.setIsValid(false);
                    WdoBaseException.ThrowJdbcDbException((SQLException)sQLException);
                    Object var8_9 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (wdoTransaction != null) {
                        WdoTransaction.ReturnTransactionObject((WdoTransaction)wdoTransaction);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (wdoTransaction != null) {
                    WdoTransaction.ReturnTransactionObject((WdoTransaction)wdoTransaction);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void writeState() throws WdoBaseException {
        block43: {
            boolean bl;
            Statement statement;
            WdoTransaction wdoTransaction;
            block41: {
                long l = 0L;
                Connection connection = null;
                wdoTransaction = null;
                statement = null;
                bl = false;
                wdoTransaction = WdoTransaction.GetTransactionObject();
                connection = wdoTransaction.getConnection("sdainternal", "development");
                bl = wdoTransaction.getCount() == 1;
                this.checkState();
                statement = connection.prepareStatement(writeStateSqlText);
                WdoStmt wdoStmt = new WdoStmt(writeStateSqlText, (PreparedStatement)statement);
                int n = 1;
                if (this.domainNameIsDefined()) {
                    statement.setString(n++, this.domainName);
                } else {
                    statement.setNull(n++, 12);
                }
                if (this.licenseLimitIsDefined()) {
                    statement.setLong(n++, this.licenseLimit);
                } else {
                    statement.setNull(n++, 4);
                }
                if (this.highWatermarkIsDefined()) {
                    statement.setLong(n++, this.highWatermark);
                } else {
                    statement.setNull(n++, 4);
                }
                if (this.checkoutHiWatermarkIsDefined()) {
                    statement.setLong(n++, this.checkoutHiWatermark);
                } else {
                    statement.setNull(n++, 4);
                }
                if (this.checkoutActualHiWatermarkIsDefined()) {
                    statement.setLong(n++, this.checkoutActualHiWatermark);
                } else {
                    statement.setNull(n++, 4);
                }
                if (this.disabledUserHiWatermarkIsDefined()) {
                    statement.setLong(n++, this.disabledUserHiWatermark);
                } else {
                    statement.setNull(n++, 4);
                }
                if (this.peakUsageSampleIsDefined()) {
                    statement.setLong(n++, this.peakUsageSample);
                } else {
                    statement.setNull(n++, 4);
                }
                if (this.anonDomainIsDefined()) {
                    statement.setString(n++, this.anonDomain);
                } else {
                    statement.setNull(n++, 1);
                }
                if (this.productIdIsDefined()) {
                    statement.setLong(n++, this.productId);
                } else {
                    statement.setNull(n++, 4);
                }
                if (this.productNameIsDefined()) {
                    statement.setString(n++, this.productName);
                } else {
                    statement.setNull(n++, 12);
                }
                if (this.updateTsIsDefined()) {
                    statement.setLong(n++, this.updateTs);
                } else {
                    statement.setNull(n++, 4);
                }
                statement.setLong(n++, this.domainId);
                l = wdoStmt.executeUpdate();
                if (l == 0L) {
                    WdoBaseException.ThrowProxyWdoException((int)6);
                }
                if (l > 1L) {
                    WdoBaseException.ThrowProxyWdoException((int)9);
                }
                wdoTransaction.inTransaction();
                statement.close();
                statement = null;
                if (bl) {
                    wdoTransaction.commit();
                }
                WdoTransaction.ReturnTransactionObject((WdoTransaction)wdoTransaction);
                wdoTransaction = null;
                this.setIsDirty(false);
                this.cleanState();
                Object var10_9 = null;
                if (statement == null) break block41;
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (wdoTransaction != null && bl) {
                wdoTransaction.rollback();
            }
            if (wdoTransaction != null) {
                WdoTransaction.ReturnTransactionObject((WdoTransaction)wdoTransaction);
            }
            break block43;
            {
                catch (SQLException sQLException) {
                    WdoBaseException.ThrowJdbcDbException((SQLException)sQLException);
                    Object var10_10 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (wdoTransaction != null && bl) {
                        wdoTransaction.rollback();
                    }
                    if (wdoTransaction != null) {
                        WdoTransaction.ReturnTransactionObject((WdoTransaction)wdoTransaction);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (wdoTransaction != null && bl) {
                    wdoTransaction.rollback();
                }
                if (wdoTransaction != null) {
                    WdoTransaction.ReturnTransactionObject((WdoTransaction)wdoTransaction);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static long Create(DomLicPCache domLicPCache) throws WdoBaseException {
        long l;
        block19: {
            boolean bl;
            Statement statement;
            WdoTransaction wdoTransaction;
            block17: {
                l = 0L;
                Connection connection = null;
                wdoTransaction = null;
                statement = null;
                bl = false;
                wdoTransaction = WdoTransaction.GetTransactionObject();
                connection = wdoTransaction.getConnection("sdainternal", "development");
                l = WdoSeq.GetNextSequence((String)wdoTransaction.getServiceName(), (String)"ilsdb.DomLicPCache");
                bl = wdoTransaction.getCount() == 1;
                domLicPCache.checkState();
                statement = connection.prepareStatement(CreateSqlText);
                WdoStmt wdoStmt = new WdoStmt(CreateSqlText, (PreparedStatement)statement);
                int n = 1;
                statement.setLong(n++, l);
                statement.setString(n++, domLicPCache.domainName);
                statement.setLong(n++, domLicPCache.licenseLimit);
                statement.setLong(n++, domLicPCache.highWatermark);
                statement.setLong(n++, domLicPCache.checkoutHiWatermark);
                statement.setLong(n++, domLicPCache.checkoutActualHiWatermark);
                statement.setLong(n++, domLicPCache.disabledUserHiWatermark);
                statement.setLong(n++, domLicPCache.peakUsageSample);
                statement.setString(n++, domLicPCache.anonDomain);
                statement.setLong(n++, domLicPCache.productId);
                statement.setString(n++, domLicPCache.productName);
                statement.setLong(n++, domLicPCache.updateTs);
                statement.execute();
                wdoTransaction.inTransaction();
                n = 1;
                domLicPCache.setId(l);
                statement.close();
                statement = null;
                if (bl) {
                    wdoTransaction.commit();
                }
                WdoTransaction.ReturnTransactionObject((WdoTransaction)wdoTransaction);
                wdoTransaction = null;
                domLicPCache.setIsValid(true);
                domLicPCache.setIsDirty(false);
                domLicPCache.cleanState();
                Object var10_9 = null;
                if (statement == null) break block17;
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (wdoTransaction != null && bl) {
                wdoTransaction.rollback();
            }
            if (wdoTransaction != null) {
                WdoTransaction.ReturnTransactionObject((WdoTransaction)wdoTransaction);
            }
            break block19;
            {
                catch (SQLException sQLException) {
                    WdoBaseException.ThrowJdbcDbException((SQLException)sQLException);
                    Object var10_10 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (wdoTransaction != null && bl) {
                        wdoTransaction.rollback();
                    }
                    if (wdoTransaction != null) {
                        WdoTransaction.ReturnTransactionObject((WdoTransaction)wdoTransaction);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (wdoTransaction != null && bl) {
                    wdoTransaction.rollback();
                }
                if (wdoTransaction != null) {
                    WdoTransaction.ReturnTransactionObject((WdoTransaction)wdoTransaction);
                }
                throw throwable;
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void Drop(long l) throws WdoBaseException {
        block19: {
            boolean bl;
            Statement statement;
            WdoTransaction wdoTransaction;
            block17: {
                Connection connection = null;
                wdoTransaction = null;
                statement = null;
                bl = false;
                wdoTransaction = WdoTransaction.GetTransactionObject();
                connection = wdoTransaction.getConnection("sdainternal", "development");
                bl = wdoTransaction.getCount() == 1;
                statement = connection.prepareStatement(DropSqlText);
                WdoStmt wdoStmt = new WdoStmt(DropSqlText, (PreparedStatement)statement);
                statement.setLong(1, l);
                statement.execute();
                wdoTransaction.inTransaction();
                statement.close();
                statement = null;
                if (bl) {
                    wdoTransaction.commit();
                }
                WdoTransaction.ReturnTransactionObject((WdoTransaction)wdoTransaction);
                wdoTransaction = null;
                Object var8_7 = null;
                if (statement == null) break block17;
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (wdoTransaction != null && bl) {
                wdoTransaction.rollback();
            }
            if (wdoTransaction != null) {
                WdoTransaction.ReturnTransactionObject((WdoTransaction)wdoTransaction);
            }
            break block19;
            {
                catch (SQLException sQLException) {
                    WdoBaseException.ThrowJdbcDbException((SQLException)sQLException);
                    Object var8_8 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (wdoTransaction != null && bl) {
                        wdoTransaction.rollback();
                    }
                    if (wdoTransaction != null) {
                        WdoTransaction.ReturnTransactionObject((WdoTransaction)wdoTransaction);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (wdoTransaction != null && bl) {
                    wdoTransaction.rollback();
                }
                if (wdoTransaction != null) {
                    WdoTransaction.ReturnTransactionObject((WdoTransaction)wdoTransaction);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static WdoReadIterator GetList() throws WdoBaseException {
        WdoReadIterator wdoReadIterator;
        block16: {
            Statement statement;
            WdoTransaction wdoTransaction;
            block14: {
                wdoReadIterator = null;
                Connection connection = null;
                wdoTransaction = null;
                statement = null;
                wdoTransaction = WdoTransaction.GetTransactionObject();
                connection = wdoTransaction.getConnection("sdainternal", "development");
                if (wdoTransaction.getCount() == 1) {
                    WdoBaseException.ThrowProxyWdoException((int)10, (String)"Cannot execute a method in an implicit transaction if it returns collections.  Use vectors instead.");
                }
                statement = connection.prepareStatement(GetListSqlText);
                statement.setMaxRows(1000000);
                WdoStmt wdoStmt = new WdoStmt(GetListSqlText, (PreparedStatement)statement);
                ResultSet resultSet = wdoStmt.executeQuery();
                wdoReadIterator = new WdoReadIterator(resultSet, statement){

                    protected Object makeObject() throws SQLException, WdoBaseException {
                        int n = 1;
                        DomLicPCache domLicPCache = null;
                        try {
                            domLicPCache = new DomLicPCache();
                        }
                        catch (Exception exception) {
                            WdoBaseException.ThrowProxyWdoException((int)10, (String)"Illegal or failed instantiation of eXoDy first class.\nPlease check your package specification and your access control on any inherited application classes.");
                        }
                        domLicPCache.setIsValid(true);
                        domLicPCache.setDomainId(this.theResultSet.getLong(n++));
                        domLicPCache.setDomainName(this.theResultSet.getString(n++));
                        domLicPCache.setLicenseLimit(this.theResultSet.getLong(n++));
                        domLicPCache.setHighWatermark(this.theResultSet.getLong(n++));
                        domLicPCache.setCheckoutHiWatermark(this.theResultSet.getLong(n++));
                        domLicPCache.setCheckoutActualHiWatermark(this.theResultSet.getLong(n++));
                        domLicPCache.setDisabledUserHiWatermark(this.theResultSet.getLong(n++));
                        domLicPCache.setPeakUsageSample(this.theResultSet.getLong(n++));
                        domLicPCache.setAnonDomain(this.theResultSet.getString(n++).charAt(0) == '1');
                        domLicPCache.setProductId(this.theResultSet.getLong(n++));
                        domLicPCache.setProductName(this.theResultSet.getString(n++));
                        domLicPCache.setUpdateTs(this.theResultSet.getLong(n++));
                        domLicPCache.setIsDirty(false);
                        domLicPCache.cleanState();
                        return domLicPCache;
                    }
                };
                wdoTransaction.addObject((WdoBaseClass)wdoReadIterator);
                statement = null;
                Object var7_7 = null;
                if (statement == null) break block14;
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (wdoTransaction != null) {
                WdoTransaction.ReturnTransactionObject((WdoTransaction)wdoTransaction);
            }
            break block16;
            {
                catch (SQLException sQLException) {
                    WdoBaseException.ThrowJdbcDbException((SQLException)sQLException);
                    Object var7_8 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (wdoTransaction != null) {
                        WdoTransaction.ReturnTransactionObject((WdoTransaction)wdoTransaction);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (wdoTransaction != null) {
                    WdoTransaction.ReturnTransactionObject((WdoTransaction)wdoTransaction);
                }
                throw throwable;
            }
        }
        return wdoReadIterator;
    }

    public void setIsValid(boolean bl) {
        this.isValid = bl;
    }

    public boolean getIsValid() {
        return this.isValid;
    }

    public void setIsDirty(boolean bl) {
        this.isDirty = bl;
    }

    public boolean getIsDirty() {
        return this.isDirty;
    }

    public void setCacheContainer(WdoCacheContainer wdoCacheContainer) {
        this.cacheContainer = wdoCacheContainer;
    }

    public WdoCacheContainer getCacheContainer() {
        return this.cacheContainer;
    }

    public boolean hasTransaction() {
        return this.transactionObject != null;
    }

    public final void readStateSync() throws WdoBaseException {
        if (this.getIsValid()) {
            return;
        }
        this.readState();
    }

    public final void writeStateSync() throws WdoBaseException {
        this.writeState();
    }

    public void removeTransaction() {
        this.transactionObject = null;
    }

    public WdoTransaction getTransaction() {
        WdoTransaction wdoTransaction = this.transactionObject;
        if (wdoTransaction == null) {
            this.transactionObject = WdoTransaction.GetTransactionObjectRef();
            this.transactionObject.addObject((WdoBaseClass)this);
            wdoTransaction = this.transactionObject;
        }
        return wdoTransaction;
    }

    public void dispose() throws WdoBaseException {
        if (this.transactionObject != null) {
            WdoTransaction.ReturnTransactionObjectRef((WdoTransaction)this.transactionObject);
            this.transactionObject = null;
        }
    }

    public void flush() throws WdoBaseException {
        if (this.isDirty) {
            this.writeStateSync();
        }
    }

    public void forget() throws WdoBaseException {
        this.flush();
        this.clearStatePartial();
        this.isValid = false;
    }

    public void undo() throws WdoBaseException {
        if (this.isDirty) {
            this.isValid = false;
            this.clearStatePartial();
            this.isDirty = false;
        }
    }

    public void preTransactionEvent(int n) throws WdoBaseException {
        switch (n) {
            case 1: {
                this.flush();
                break;
            }
            case 2: {
                this.undo();
            }
        }
    }

    public void postTransactionEvent(int n) throws WdoBaseException {
        switch (n) {
            case 1: {
                this.dispose();
                break;
            }
            case 2: {
                this.dispose();
            }
        }
    }
}

