/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils.client;

import com.vs.ils.client.Hfile;
import com.vs.ils.client.Util;
import com.vs.ils.crypt.PkCrypt;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;

public class IlsClient {
    public static final int ILS_STATUS_WARNING_EXPIRING = -1;
    public static final int ILS_STATUS_WARNING_EXPIRED = -2;
    public static final int ILS_STATUS_WARNING_QUOTA_EXPIRING = -3;
    public static final int ILS_STATUS_WARNING_QUOTA_EXPIRED = -4;
    public static final int ILS_STATUS_WARNING_LATE_CHECKIN = -5;
    public static final int ILS_STATUS_WARNING_SERVER_DOWN = -6;
    public static final int ILS_STATUS_WARNING_OBJECT_GONE = -7;
    public static final int ILS_STATUS_WARNING_SOFT_USER_LIMIT_EXCEEDED = -8;
    public static final int ILS_STATUS_WARNING_CANCELLED_CHECKOUT = -9;
    public static final int ILS_STATUS_INFO_UPDATED = -100;
    public static final int ILS_STATUS_INFO_DROPPED = -101;
    public static final int ILS_STATUS_INFO_EXISTS = -102;
    public static final int ILS_STATUS_INFO_NOT_FOUND = -103;
    public static final int ILS_STATUS_INFO_CHANGED_PARAM_VALUES = -104;
    public static final int ILS_STATUS_OK = 0;
    public static final int ILS_STATUS_INVALID_TOKEN = 1;
    public static final int ILS_STATUS_INVALID_MC = 2;
    public static final int ILS_STATUS_INVALID_TS = 3;
    public static final int ILS_STATUS_EXPIRED_TOKEN = 4;
    public static final int ILS_STATUS_EXPIRED_KEY = 5;
    public static final int ILS_STATUS_EXPIRED_QUOTA_KEY = 6;
    public static final int ILS_STATUS_INVALID_PRODUCT = 7;
    public static final int ILS_STATUS_INVALID_DOMAIN = 8;
    public static final int ILS_STATUS_INVALID_USER = 9;
    public static final int ILS_STATUS_DISABLED_PRODUCT = 10;
    public static final int ILS_STATUS_DISABLED_DOMAIN = 11;
    public static final int ILS_STATUS_DISABLED_USER = 12;
    public static final int ILS_STATUS_ALREADY_CHECKED_OUT = 13;
    public static final int ILS_STATUS_ALREADY_CHECKED_IN = 14;
    public static final int ILS_STATUS_PREMATURE_CHECKIN = 15;
    public static final int ILS_STATUS_LATE_CHECKIN = 16;
    public static final int ILS_STATUS_KEY_LIMIT_EXCEEDED = 17;
    public static final int ILS_STATUS_ACCESS_DENIED = 18;
    public static final int ILS_STATUS_INVALID_OP_FOR_LICENSE_MODEL = 19;
    public static final int ILS_STATUS_NO_APP_CTX = 20;
    public static final int ILS_STATUS_ALREADY_REGISTERED = 21;
    public static final int ILS_STATUS_INVALID_CLIENT = 22;
    public static final int ILS_STATUS_PROTOCOL_ERROR = 23;
    public static final int ILS_STATUS_CUSTOM_CONFIG = 24;
    public static final int ILS_STATUS_CONFIG = 25;
    public static final int ILS_STATUS_LICENSE = 26;
    public static final int ILS_STATUS_INVALID_OPTION = 27;
    public static final int ILS_STATUS_UNIMPLEMENTED = 28;
    public static final int ILS_STATUS_COMM_ERROR = 29;
    public static final int ILS_STATUS_INVALID_OP_FOR_LICENSE_PARAMS = 30;
    public static final int ILS_STATUS_INSUFFICIENT_PRIVILEGES = 31;
    public static final int ILS_STATUS_BAD_INPUT_DATA = 32;
    public static final int ILS_STATUS_BAD_QUOTA_VALUE = 33;
    public static final int ILS_STATUS_BAD_EXP_VALUE = 34;
    public static final int ILS_STATUS_INVALID_REPORT_NAME = 35;
    public static final int ILS_STATUS_INVALID_REPORT_RESULT_NAME = 36;
    public static final int ILS_STATUS_REPORT_RESULT_TOO_BIG = 37;
    public static final int ILS_STATUS_FORMAT_ERROR = 100;
    public static final int ILS_STATUS_EXISTS = 101;
    public static final int ILS_STATUS_NOT_FOUND = 102;
    public static final int ILS_STATUS_CLIENT_CLOCK = 103;
    public static final int ILS_STATUS_INTERNAL = 1000;
    public static final int ILS_STATUS_FATAL_INTERNAL = 1001;
    public static final String ILS_HTTP_KWD_SERVICE_STR = "service";
    public static final String ILS_HTTP_KWD_CMD_STR = "cmd";
    public static final String ILS_HTTP_KWD_CUSTOMCMD_STR = "customcmd";
    public static final String ILS_HTTP_KWD_PRODUCT_STR = "product";
    public static final String ILS_HTTP_KWD_DOMAIN_STR = "domain";
    public static final String ILS_HTTP_KWD_USER_STR = "user";
    public static final String ILS_HTTP_KWD_PASSWD_STR = "passwd";
    public static final String ILS_HTTP_KWD_UPDATEOK_STR = "updateok";
    public static final String ILS_HTTP_KWD_ENABLE_STR = "enable";
    public static final String ILS_HTTP_KWD_CHECKEDOUT_STR = "checkedout";
    public static final String ILS_HTTP_KWD_REPORTNAME_STR = "reportname";
    public static final String ILS_HTTP_KWD_REPORTPARAMS_STR = "reportparams";
    public static final String ILS_HTTP_KWD_REPORTRESULTNAME_STR = "reportresultname";
    public static final String ILS_HTTP_KWD_STATUS_STR = "status";
    public static final String ILS_HTTP_KWD_MSG_STR = "msg";
    public static final String ILS_HTTP_KWD_VALUE_STR = "value";
    public static final String ILS_HTTP_KWD_SVRTIME_STR = "svrtime";
    public static final String ILS_HTTP_KWD_PROTOCOL_STR = "protocol_vsn";
    public static final String ILS_HTTP_KWD_ENVELOPE_STR = "envelope";
    public static final String ILS_HTTP_KWD_TOKEN_STR = "token";
    public static final String ILS_HTTP_KWD_MACHINE_STR = "machine";
    public static final String ILS_HTTP_KWD_SESSION_STR = "session";
    public static final String ILS_HTTP_KWD_APPCTX_STR = "appctx";
    public static final String ILS_HTTP_KWD_OPTIONS_STR = "options";
    public static final String ILS_HTTP_KWD_POINTS_STR = "points";
    public static final String ILS_HTTP_KWD_QUOTA_STR = "quota";
    public static final String ILS_HTTP_KWD_QUOTA_CAP_STR = "quota_cap";
    public static final String ILS_HTTP_KWD_DURATION_STR = "ttl";
    public static final String ILS_HTTP_KWD_MIN_DURATION_STR = "ttl_min";
    public static final String ILS_HTTP_KWD_MAX_DURATION_STR = "ttl_max";
    public static final String ILS_HTTP_KWD_CLOCK_STR = "clock";
    public static final String ILS_HTTP_KWD_PARAMS_STR = "params";
    public static final String ILS_HTTP_KWD_USER_EXPTS_STR = "userexpts";
    public static final String ILS_HTTP_KWD_CUSTOMCTX_STR = "customctx";
    public static final String ILS_CMD_CHECKOUT_STR = "checkout";
    public static final String ILS_CMD_CHECKIN_STR = "checkin";
    public static final String ILS_CMD_REGISTER_STR = "register";
    public static final String ILS_CMD_DEREGISTER_STR = "deregister";
    public static final String ILS_CMD_UP_QUOTA_USE_LEVEL_STR = "upquotause";
    public static final String ILS_CMD_SETCTX_STR = "setappctx";
    public static final String ILS_CMD_GETCTX_STR = "getappctx";
    public static final String ILS_CMD_EXECREPORT_STR = "execreport";
    public static final String ILS_CMD_CUSTOM_STR = "custom";
    public static final String ILS_HTTP_MSG_PREFIX = "system=ILS";
    public static final int ILS_ANON_REPORT_RESULT_MAXLENGTH = 2000;
    public static final int ILS_PROTOCOL_VERSION = 3;
    public static final String ILS_CLIENT_MAJOR_VERSION = "1.0";
    public static final String ILS_CLIENT_MINOR_VERSION = "03";
    public static final String ILS_SIGNATURE = "system=ILS&protocol_vsn=3&";
    private static final int _$4061 = 10;
    private String _$4077 = "http://localhost:8008/ils/ils.jsp";
    private String _$4087 = null;
    private String _$4099 = IlsClient._$4111();
    private String _$4123 = null;
    private String _$4135 = null;
    private String _$4146 = null;
    private String _$4155 = null;
    private long _$4162 = 1L;
    private int _$4172 = 1;
    private int _$4191 = 1;
    private String _$4209 = null;
    private int _$4219 = 0;
    private boolean _$4234 = false;
    private long _$4249 = -1L;
    private String _$4262 = null;
    private String _$4268 = null;
    private int _$4280 = 0;
    private String _$4287 = null;
    private String _$4295 = null;
    private String _$4299 = null;
    private String _$4305 = null;
    private long _$4318 = 0L;
    private String _$4333 = null;
    private String _$4340 = null;
    private String _$4350 = null;
    private long _$4357 = 0L;
    private long _$4370 = 0L;
    private long _$4379 = -1L;
    private long _$4391 = -1L;
    private long _$4403 = -1L;
    private long _$4412 = -1L;
    private int _$4422 = 0;
    private long _$4431 = -2L;
    private int _$4439 = 0;

    public static String[] getVersionInfo() {
        return new String[]{ILS_CLIENT_MAJOR_VERSION, ILS_CLIENT_MINOR_VERSION};
    }

    public IlsClient() {
    }

    public IlsClient(String string, String string2, String string3, String string4, String string5) {
        this._$4460(string, string2, string3, 1L, string4, string5, null, null, 1, null, 1, 0);
    }

    public IlsClient(String string, String string2, String string3, String string4, String string5, String string6) {
        this._$4460(string, string2, string3, 1L, string4, string5, string6, null, 1, null, 1, 0);
        this._$4234 = string6 != null;
    }

    public IlsClient(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this._$4460(string, string2, string3, 1L, string4, string5, string6, string7, 1, null, 1, 0);
        this._$4234 = string6 != null;
    }

    public IlsClient(String string, String string2, String string3, long l, String string4, String string5) {
        this._$4460(string, string2, string3, l, string4, string5, null, null, 1, null, 1, 0);
    }

    public IlsClient(String string, String string2, String string3, long l, String string4, String string5, String string6) {
        this._$4460(string, string2, string3, l, string4, string5, string6, null, 1, null, 1, 0);
        this._$4234 = string6 != null;
    }

    public IlsClient(String string, String string2, String string3, long l, String string4, String string5, String string6, String string7) {
        this._$4460(string, string2, string3, l, string4, string5, string6, string7, 1, null, 1, 0);
        this._$4234 = string6 != null;
    }

    public IlsClient(String string, String string2, String string3, long l, String string4, String string5, String string6, String string7, int n, int n2, String string8, int n3) {
        this._$4460(string, string2, string3, l, string4, string5, string6, string7, n, string8, n2, n3);
        this._$4234 = string6 != null;
    }

    public String saveCheckoutState(String string) {
        return this.saveCheckoutState(string, null);
    }

    public String saveCheckoutState(String string, String string2) {
        long l = new Date().getTime();
        String string3 = "system=ILS;version=1.0;";
        if (this._$4077 != null) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("ilsSvrUrl=").concat(String.valueOf(this._$4077))).concat(String.valueOf(";"))));
        }
        if (this._$4087 != null) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("serviceName=").concat(String.valueOf(this._$4087))).concat(String.valueOf(";"))));
        }
        if (this._$4099 != null) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("machineName=").concat(String.valueOf(this._$4099))).concat(String.valueOf(";"))));
        }
        if (this._$4123 != null) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("productName=").concat(String.valueOf(this._$4123))).concat(String.valueOf(";"))));
        }
        if (this._$4135 != null) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("domainName=").concat(String.valueOf(this._$4135))).concat(String.valueOf(";"))));
        }
        if (this._$4146 != null) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("userName=").concat(String.valueOf(this._$4146))).concat(String.valueOf(";"))));
        }
        if (this._$4155 != null) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("passwd=").concat(String.valueOf(this._$4155))).concat(String.valueOf(";"))));
        }
        if (this._$4162 != (long)1) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("sessionId=").concat(String.valueOf(this._$4162))).concat(String.valueOf(";"))));
        }
        if (this._$4172 != 1) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("durationCacheCount=").concat(String.valueOf(this._$4172))).concat(String.valueOf(";"))));
        }
        if (this._$4191 != 1) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("pointsPerCheckout=").concat(String.valueOf(this._$4191))).concat(String.valueOf(";"))));
        }
        if (this._$4209 != null) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("publicKey=").concat(String.valueOf(this._$4209))).concat(String.valueOf(";"))));
        }
        if (this._$4219 != 0) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("overdraftLimit=").concat(String.valueOf(this._$4219))).concat(String.valueOf(";"))));
        }
        if (this._$4249 != (long)-1) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("checkoutDate=").concat(String.valueOf(this._$4249))).concat(String.valueOf(";"))));
        }
        if (this._$4262 != null) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("token=").concat(String.valueOf(this._$4262))).concat(String.valueOf(";"))));
        }
        if (this._$4268 != null) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("responseMsg=").concat(String.valueOf(Util.TranslateString(this._$4268)))).concat(String.valueOf(";"))));
        }
        if (this._$4280 != 0) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("status=").concat(String.valueOf(this._$4280))).concat(String.valueOf(";"))));
        }
        if (this._$4287 != null) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("options=").concat(String.valueOf(Util.TranslateString(this._$4287)))).concat(String.valueOf(";"))));
        }
        if (this._$4295 != null) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("msg=").concat(String.valueOf(Util.TranslateString(this._$4295)))).concat(String.valueOf(";"))));
        }
        if (this._$4299 != null) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("value=").concat(String.valueOf(Util.TranslateString(this._$4299)))).concat(String.valueOf(";"))));
        }
        if (this._$4305 != null) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("otherMachine=").concat(String.valueOf(this._$4305))).concat(String.valueOf(";"))));
        }
        if (this._$4318 != (long)0) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("otherSessionId=").concat(String.valueOf(this._$4318))).concat(String.valueOf(";"))));
        }
        if (this._$4333 != null) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("params=").concat(String.valueOf(Util.TranslateString(this._$4333)))).concat(String.valueOf(";"))));
        }
        if (this._$4340 != null) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("customCtx=").concat(String.valueOf(Util.TranslateString(this._$4340)))).concat(String.valueOf(";"))));
        }
        if (this._$4350 != null) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("appCtx=").concat(String.valueOf(Util.TranslateString(this._$4350)))).concat(String.valueOf(";"))));
        }
        if (this._$4357 != (long)0) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("balanceQuota=").concat(String.valueOf(this._$4357))).concat(String.valueOf(";"))));
        }
        if (this._$4370 != (long)0) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("duration=").concat(String.valueOf(this._$4370))).concat(String.valueOf(";"))));
        }
        if (this._$4379 != (long)-1) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("minDuration=").concat(String.valueOf(this._$4379))).concat(String.valueOf(";"))));
        }
        if (this._$4391 != (long)-1) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("maxDuration=").concat(String.valueOf(this._$4391))).concat(String.valueOf(";"))));
        }
        if (this._$4403 != (long)-1) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("quotaCap=").concat(String.valueOf(this._$4403))).concat(String.valueOf(";"))));
        }
        if (this._$4412 != (long)-1) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("userExpTs=").concat(String.valueOf(this._$4412))).concat(String.valueOf(";"))));
        }
        if (this._$4422 != 0) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("protocol=").concat(String.valueOf(this._$4422))).concat(String.valueOf(";"))));
        }
        if (this._$4431 != (long)-2) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("svrTime=").concat(String.valueOf(this._$4431))).concat(String.valueOf(";"))));
        }
        if (this._$4439 != 0) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf(String.valueOf("overdraftCount=").concat(String.valueOf(this._$4439))).concat(String.valueOf(";"))));
        }
        string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf("nowts=").concat(String.valueOf(l / (long)1000))));
        Hfile.updateHfile(l, string2);
        Util.Trace(7, "SaveCheckoutState", String.valueOf("state before encryption:\n").concat(String.valueOf(string3)));
        return PkCrypt.encryptIls((String)string3, (String)string);
    }

    public boolean restoreCheckoutState(String string, String string2) {
        return this.restoreCheckoutState(string, string2, -1L);
    }

    public boolean restoreCheckoutState(String string, String string2, long l) {
        return this.restoreCheckoutState(string, string2, l, 0, null);
    }

    public boolean restoreCheckoutState(String string, String string2, long l, int n, String string3) {
        boolean bl;
        if ((string = PkCrypt.decryptIls((String)string, (String)string2)) == null) {
            Util.Trace(3, "restoreCheckoutState", String.valueOf("decrypt failed for input string:\n").concat(String.valueOf(string)));
            return false;
        }
        Util.Trace(7, "restoreCheckoutState", String.valueOf("input string:\n").concat(String.valueOf(string)));
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        long l2 = 0L;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            int n2 = string4.indexOf("=");
            if (n2 <= 0 || n2 == string4.length()) {
                Util.Trace(3, "restoreCheckoutState", String.valueOf("bad kwdval: ").concat(String.valueOf(string4)));
                return false;
            }
            String string5 = string4.substring(0, n2);
            String string6 = string4.substring(n2 + 1);
            if (string5.equals("ilsSvrUrl")) {
                this._$4077 = string6;
                continue;
            }
            if (string5.equals("serviceName")) {
                this._$4087 = string6;
                continue;
            }
            if (string5.equals("machineName")) {
                this._$4099 = string6;
                continue;
            }
            if (string5.equals("productName")) {
                this._$4123 = string6;
                continue;
            }
            if (string5.equals("domainName")) {
                this._$4135 = string6;
                continue;
            }
            if (string5.equals("userName")) {
                this._$4146 = string6;
                continue;
            }
            if (string5.equals(ILS_HTTP_KWD_PASSWD_STR)) {
                this._$4155 = string6;
                continue;
            }
            if (string5.equals("sessionId")) {
                this._$4162 = IlsClient._$4802(string6);
                continue;
            }
            if (string5.equals("durationCacheCount")) {
                this._$4172 = (int)IlsClient._$4802(string6);
                continue;
            }
            if (string5.equals("pointsPerCheckout")) {
                this._$4191 = (int)IlsClient._$4802(string6);
                continue;
            }
            if (string5.equals("publicKey")) {
                this._$4209 = string6;
                continue;
            }
            if (string5.equals("overdraftLimit")) {
                this._$4219 = (int)IlsClient._$4802(string6);
                continue;
            }
            if (string5.equals("checkoutDate")) {
                this._$4249 = IlsClient._$4802(string6);
                continue;
            }
            if (string5.equals(ILS_HTTP_KWD_TOKEN_STR)) {
                this._$4262 = string6;
                continue;
            }
            if (string5.equals("responseMsg")) {
                this._$4268 = Util.ReverseTranslateString(string6);
                continue;
            }
            if (string5.equals(ILS_HTTP_KWD_STATUS_STR)) {
                this._$4280 = (int)IlsClient._$4802(string6);
                continue;
            }
            if (string5.equals(ILS_HTTP_KWD_OPTIONS_STR)) {
                this._$4287 = Util.ReverseTranslateString(string6);
                continue;
            }
            if (string5.equals(ILS_HTTP_KWD_MSG_STR)) {
                this._$4295 = Util.ReverseTranslateString(string6);
                continue;
            }
            if (string5.equals(ILS_HTTP_KWD_VALUE_STR)) {
                this._$4299 = Util.ReverseTranslateString(string6);
                continue;
            }
            if (string5.equals("otherMachine")) {
                this._$4305 = string6;
                continue;
            }
            if (string5.equals("otherSessionId")) {
                this._$4318 = IlsClient._$4802(string6);
                continue;
            }
            if (string5.equals(ILS_HTTP_KWD_PARAMS_STR)) {
                this._$4333 = Util.ReverseTranslateString(string6);
                continue;
            }
            if (string5.equals("customCtx")) {
                this._$4340 = Util.ReverseTranslateString(string6);
                continue;
            }
            if (string5.equals("appCtx")) {
                this._$4350 = Util.ReverseTranslateString(string6);
                continue;
            }
            if (string5.equals("balanceQuota")) {
                this._$4357 = IlsClient._$4802(string6);
                continue;
            }
            if (string5.equals("duration")) {
                this._$4370 = IlsClient._$4802(string6);
                continue;
            }
            if (string5.equals("minDuration")) {
                this._$4379 = IlsClient._$4802(string6);
                continue;
            }
            if (string5.equals("maxDuration")) {
                this._$4391 = IlsClient._$4802(string6);
                continue;
            }
            if (string5.equals("quotaCap")) {
                this._$4403 = IlsClient._$4802(string6);
                continue;
            }
            if (string5.equals("userExpTs")) {
                this._$4412 = IlsClient._$4802(string6);
                continue;
            }
            if (string5.equals("protocol")) {
                this._$4422 = (int)IlsClient._$4802(string6);
                continue;
            }
            if (string5.equals("svrTime")) {
                this._$4431 = IlsClient._$4802(string6);
                continue;
            }
            if (string5.equals("overdraftCount")) {
                this._$4439 = (int)IlsClient._$4802(string6);
                continue;
            }
            if (string5.equals("nowts")) {
                l2 = IlsClient._$4802(string6);
                bl4 = true;
                continue;
            }
            if (string5.equals("system")) {
                if (!string6.equals("ILS")) {
                    Util.Trace(3, "restoreCheckoutState", String.valueOf("bad system val: ").concat(String.valueOf(string6)));
                    return false;
                }
                bl2 = true;
                continue;
            }
            if (string5.equals("version")) {
                if (!string6.equals(ILS_CLIENT_MAJOR_VERSION)) {
                    Util.Trace(3, "restoreCheckoutState", String.valueOf("bad version val: ").concat(String.valueOf(string6)));
                    return false;
                }
                bl3 = true;
                continue;
            }
            Util.Trace(3, "restoreCheckoutState", String.valueOf("unrecognized kwd: ").concat(String.valueOf(string5)));
            return false;
        }
        this._$4234 = this._$4146 != null;
        boolean bl5 = bl = bl2 && bl3 && bl4;
        if (bl) {
            long l3 = new Date().getTime();
            Util.Trace(7, "restoreCheckoutState", String.valueOf(String.valueOf(String.valueOf("Got nowTs = ").concat(String.valueOf(l3))).concat(String.valueOf(", corresponds to date: "))).concat(String.valueOf(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").format(new Date(l3)))));
            long l4 = Hfile.getHfileTs(true, l3, n, string3);
            Util.Trace(7, "restoreCheckoutState", new String[]{String.valueOf("nowTs=\t").concat(String.valueOf(l3)), String.valueOf("hfileTs=\t").concat(String.valueOf(l4)), String.valueOf("saveTs=\t").concat(String.valueOf(l2 *= (long)1000)), String.valueOf("shelfLife=").concat(String.valueOf(l)), String.valueOf("tolerance=").concat(String.valueOf(n))}, false, null);
            if (l4 == (long)0 && l >= (long)0 && !Hfile.olderThan(l3, l2, n)) {
                if ((l3 - l2) / (long)1000 > l * (long)3600) {
                    this._$4280 = 103;
                    this._$4295 = String.valueOf(String.valueOf("Disconnected application was not activated within ").concat(String.valueOf(l))).concat(String.valueOf(" hour(s) of being licensed."));
                    bl = false;
                } else {
                    Util.Trace(7, "restoreCheckoutState", "No previous application execution history.  Activating.");
                    Hfile.updateHfile(l3, string3);
                    l4 = Hfile.getHfileTs(true, l3, n, string3);
                    if (l4 <= (long)0) {
                        bl = false;
                    }
                }
            }
            if (bl) {
                if (l4 <= (long)0 || Hfile.olderThan(l3, l2, n) || Hfile.olderThan(l4, l2, n)) {
                    this._$4280 = 103;
                    this._$4295 = "Client's system clock is suspect and / or the client configuration has been tampered with.";
                    bl = false;
                } else {
                    Hfile.updateHfile(l3, string3);
                }
            }
        }
        if (!bl) {
            Util.Trace(3, "restoreCheckoutState", String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("*** bad got*: gotSystem=").concat(String.valueOf(bl2))).concat(String.valueOf(", gotVersion="))).concat(String.valueOf(bl3))).concat(String.valueOf(", gotNowTs="))).concat(String.valueOf(bl4)));
        }
        return bl;
    }

    public String makeErrMsg() {
        int n = this.getStatus();
        String string = null;
        switch (n) {
            case 0: {
                return "No error.";
            }
            case -6: {
                string = "License server is not accessible";
                break;
            }
            case 9: 
            case 12: {
                string = "User authentication error";
                break;
            }
            case 18: 
            case 31: {
                string = "Authorization error";
                break;
            }
            case 7: 
            case 10: 
            case 25: {
                string = "Configuration error";
                break;
            }
            case 29: {
                string = "Communication error";
                break;
            }
            default: {
                string = "System error";
            }
        }
        string = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(string).concat(String.valueOf(":"))).concat(String.valueOf(this.getMsg()))).concat(String.valueOf(this.getValue() != null ? this.getValue() : ""))).concat(String.valueOf(": status code: "))).concat(String.valueOf(this.getStatus()));
        return string;
    }

    private boolean _$4939(long l, String string, String string2) {
        Date date = new Date();
        String string3 = this._$4970(ILS_CMD_CHECKOUT_STR, false, true);
        if (this._$4172 > 1) {
            l *= (long)this._$4172;
        }
        if (this._$4191 > 1) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf("&").concat(String.valueOf(this._$4992()))));
        }
        string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf("&").concat(String.valueOf(this._$5013(l)))));
        if (string != null && !string.equals("")) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf("&").concat(String.valueOf(this._$5036(URLEncoder.encode(string))))));
        }
        if (string2 != null && !string2.equals("")) {
            string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf("&").concat(String.valueOf(this._$5076(URLEncoder.encode(string2))))));
        }
        if (!this._$5100(string3) || !this._$5108()) {
            return false;
        }
        if (this._$4262 == null || l <= (long)0) {
            return this._$5128("missing / invalid return data");
        }
        this._$4249 = date.getTime();
        return true;
    }

    public boolean checkout(long l, String string, String string2) {
        long l2 = 0L;
        while (this._$4439 > 0) {
            this._$5167(true);
            if (this._$4939(l, string, string2)) {
                --this._$4439;
                if (this._$4431 >= (long)0 && l2 >= (long)0) {
                    l2 += this._$4431;
                    continue;
                }
                l2 = -1L;
                continue;
            }
            if (this._$4280 == 29 && this._$4439 < this._$4219) {
                ++this._$4439;
                this._$4370 = l;
                this._$4280 = -6;
                return true;
            }
            return false;
        }
        Date date = new Date();
        long l3 = -1L;
        if (this._$4249 != (long)-1 && l > (long)0) {
            long l4 = l;
            if (this._$4172 > 0) {
                l4 = l * (long)this._$4172;
            }
            l3 = this._$4249 + l4 * (long)1000;
        }
        this._$5167(false);
        if (l3 != (long)-1 && l3 > date.getTime() + l * (long)1000) {
            this._$4370 = l;
            this._$4431 = l2;
            return true;
        }
        if (!this._$4939(l, string, string2)) {
            if (this._$4280 == 29 && this._$4439 < this._$4219) {
                ++this._$4439;
                this._$4370 = l;
                this._$4280 = -6;
                return true;
            }
            return false;
        }
        if (this._$4431 >= (long)0 && l2 >= (long)0) {
            this._$4431 += l2;
        }
        return true;
    }

    public boolean checkout(long l, String string) {
        return this.checkout(l, string, null);
    }

    public boolean checkout(long l) {
        return this.checkout(l, null, null);
    }

    public void patchCtx(boolean bl) {
        this._$4249 = bl ? (this._$4249 /= (long)1000) : (this._$4249 *= (long)1000);
    }

    public boolean checkin() {
        return this.checkin(null);
    }

    public boolean checkin(String string) {
        if (this._$4249 <= (long)0 || this._$4262 == null) {
            return this._$5128("no token specified for checkin");
        }
        this._$5167(false);
        this._$4333 = string;
        String string2 = this._$4970(ILS_CMD_CHECKIN_STR, true, false);
        if (!this._$5100(string2) || !this._$5108()) {
            return false;
        }
        this._$4249 = -1L;
        this._$4262 = null;
        return true;
    }

    public boolean upQuotaUseLevel(int n) {
        if (this._$4249 == (long)-1 || this._$4262 == null) {
            return this._$5128("no token specified");
        }
        this._$5167(false);
        String string = this._$4970(ILS_CMD_UP_QUOTA_USE_LEVEL_STR, true, false);
        string = String.valueOf(string).concat(String.valueOf(String.valueOf("&").concat(String.valueOf(this._$5310(n)))));
        if (!this._$5100(string) || !this._$5108()) {
            return false;
        }
        if (this._$4357 < (long)0) {
            return this._$5128("balance quota use level not returned");
        }
        return true;
    }

    public boolean upQuotaUseLevel() {
        return this.upQuotaUseLevel(1);
    }

    public boolean doSetAppCtx(String string) {
        if (this._$4249 == (long)-1 || this._$4262 == null) {
            return this._$5128("no token specified");
        }
        this._$5167(false);
        String string2 = this._$4970(ILS_CMD_SETCTX_STR, true, false);
        string2 = String.valueOf(string2).concat(String.valueOf(String.valueOf("&").concat(String.valueOf(this._$5372(string == null ? null : URLEncoder.encode(string))))));
        return this._$5100(string2) && this._$5108();
    }

    public boolean doGetAppCtx() {
        if (this._$4249 == (long)-1 || this._$4262 == null) {
            return this._$5128("not checked out");
        }
        this._$5167(false);
        String string = this._$4970(ILS_CMD_GETCTX_STR, true, false);
        if (!this._$5100(string) || !this._$5108()) {
            return false;
        }
        if (this._$4350 == null) {
            return this._$5128("app ctx not returned");
        }
        return true;
    }

    public boolean doCustomCmd(String string, String string2) {
        this._$5167(true);
        String string3 = this._$4970(ILS_CMD_CUSTOM_STR, false, true);
        string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf("&").concat(String.valueOf(this._$5457(string, string2 == null ? null : URLEncoder.encode(string2))))));
        return this._$5100(string3) && this._$5108();
    }

    public boolean registerUser(String string, String string2, String string3, long l, int n, String string4) {
        return this.registerUser(string, string2, string3, l, n, string4, null, false, null, false);
    }

    public boolean registerUser(String string, String string2, String string3, long l, int n, String string4, String string5, boolean bl, String string6, boolean bl2) {
        this._$5167(false);
        this._$4146 = string;
        this._$4155 = string2;
        this._$4135 = string3;
        this._$4333 = string4;
        this._$4403 = l;
        this._$4412 = n < 0 ? -1L : new Date().getTime() / (long)1000 + (long)n * (long)86400;
        String string7 = this._$4970(ILS_CMD_REGISTER_STR, true, true);
        if (string5 != null && !string5.equals("")) {
            string7 = String.valueOf(string7).concat(String.valueOf(String.valueOf("&").concat(String.valueOf(this._$5036(URLEncoder.encode(string5))))));
        }
        if (bl) {
            string7 = String.valueOf(string7).concat(String.valueOf(String.valueOf("&").concat(String.valueOf(this._$5581()))));
        }
        if (string6 != null) {
            string7 = String.valueOf(string7).concat(String.valueOf(String.valueOf("&").concat(String.valueOf(this._$5604(string6)))));
        }
        if (bl2) {
            string7 = String.valueOf(string7).concat(String.valueOf(String.valueOf("&").concat(String.valueOf(this._$5625()))));
        }
        return this._$5100(string7) && this._$5108();
    }

    public boolean deregisterUser(String string, String string2, String string3) {
        return this.deregisterUser(string, string3);
    }

    public boolean deregisterUser(String string, String string2) {
        this._$5167(false);
        this._$4146 = string;
        this._$4135 = string2;
        String string3 = this._$4970(ILS_CMD_DEREGISTER_STR, true, true);
        return this._$5100(string3) && this._$5108();
    }

    public boolean executeReport(String string, String string2, String string3, String string4) {
        this._$5167(false);
        this._$4135 = string4;
        String string5 = this._$4970(ILS_CMD_EXECREPORT_STR, true, true);
        string5 = String.valueOf(string5).concat(String.valueOf(String.valueOf("&").concat(String.valueOf(this._$5755(ILS_HTTP_KWD_REPORTNAME_STR, string)))));
        if (string2 != null) {
            string5 = String.valueOf(string5).concat(String.valueOf(String.valueOf("&").concat(String.valueOf(this._$5755(ILS_HTTP_KWD_REPORTPARAMS_STR, string2)))));
        }
        if (string3 != null) {
            string5 = String.valueOf(string5).concat(String.valueOf(String.valueOf("&").concat(String.valueOf(this._$5755(ILS_HTTP_KWD_REPORTRESULTNAME_STR, string3)))));
        }
        return this._$5100(string5) && this._$5108();
    }

    public boolean checkInCheckoutDuration() {
        return this.checkInCheckoutDuration(0, null, true);
    }

    public boolean checkInCheckoutDuration(int n, String string, boolean bl) {
        long l;
        long l2 = new Date().getTime();
        boolean bl2 = true;
        if (bl && (l = Hfile.getHfileTs(true, l2, n, string)) <= (long)0) {
            this._$4280 = 103;
            this._$4295 = "Client's system clock is suspect and / or the client configuration has been tampered with.";
            return false;
        }
        boolean bl3 = bl2 = this._$4249 > (long)0 && this._$4370 > (l2 - this._$4249) / (long)1000;
        if (bl) {
            bl2 &= Hfile.updateHfile(l2, string);
        }
        return bl2;
    }

    public String getIlsSvrUrl() {
        return this._$4077;
    }

    public String getServiceName() {
        return this._$4087;
    }

    public String getMachineName() {
        return this._$4099;
    }

    public String getProductName() {
        return this._$4123;
    }

    public String getDomainName() {
        return this._$4135;
    }

    public String getUserName() {
        return this._$4146;
    }

    public String getPasswd() {
        return this._$4155;
    }

    public long getSessionId() {
        return this._$4162;
    }

    public int getDurationCacheCount() {
        return this._$4172;
    }

    public int getPointsPerCheckout() {
        return this._$4191;
    }

    public String getPublicKey() {
        return this._$4209;
    }

    public int getOverdraftLimit() {
        return this._$4219;
    }

    public Date getCheckoutDate() {
        return this._$4249 == (long)-1 ? null : new Date(this._$4249);
    }

    public String getToken() {
        return this._$4262;
    }

    public int getStatus() {
        return this._$4280;
    }

    public String getMsg() {
        return this._$4295;
    }

    public String getResponseMsg() {
        return this._$4268;
    }

    public String getValue() {
        return this._$4299;
    }

    public String getOtherMachine() {
        return this._$4305;
    }

    public long getOtherSessionId() {
        return this._$4318;
    }

    public String getAppCtx() {
        return this._$4350;
    }

    public String getCustomCtx() {
        return this._$4340;
    }

    public String getParams() {
        return this._$4333;
    }

    public String getOptions() {
        return this._$4287;
    }

    public long getBalanceQuota() {
        return this._$4357;
    }

    public long getQuotaCap() {
        return this._$4403;
    }

    public long getDuration() {
        return this._$4370;
    }

    public long getMinDuration() {
        return this._$4391;
    }

    public long getMaxDuration() {
        return this._$4379;
    }

    public long getUserExpTs() {
        return this._$4412 * (long)1000;
    }

    public int getProtocol() {
        return this._$4422;
    }

    public long getSvrTime() {
        return this._$4431;
    }

    public void setParams(String string) {
        this._$4333 = string;
    }

    public void setCustomCtx(String string) {
        this._$4340 = string;
    }

    public void setAppCtx(String string) {
        this._$4350 = string;
    }

    public void setBalanceQuota(long l) {
        this._$4357 = l;
    }

    public void setQuotaCap(long l) {
        this._$4403 = l;
    }

    public void setUserExpTs(long l) {
        this._$4412 = l;
    }

    private void _$4460(String string, String string2, String string3, long l, String string4, String string5, String string6, String string7, int n, String string8, int n2, int n3) {
        if (string != null && !string.equals("")) {
            if (!string.startsWith("http:") && !string.startsWith("inprocess:")) {
                string = String.valueOf("http://").concat(String.valueOf(string));
            }
            this._$4077 = string;
        }
        if (string2 != null && !string2.equals("")) {
            this._$4087 = string2;
        }
        if (string3 != null && !string3.equals("")) {
            this._$4099 = string3;
        }
        if (l > (long)0) {
            this._$4162 = l;
        }
        if (string4 != null && !string4.equals("")) {
            this._$4123 = string4;
        }
        if (string5 != null && !string5.equals("")) {
            this._$4135 = string5;
        }
        if (string6 != null && !string6.equals("")) {
            this._$4146 = string6;
        }
        if (string7 != null && !string7.equals("")) {
            this._$4155 = string7;
        }
        this._$4191 = n;
        this._$4439 = 0;
        if (n2 > 0) {
            this._$4172 = n2;
        }
        if (string8 != null) {
            this._$4209 = string8;
        }
        if (n3 >= 0) {
            this._$4219 = n3;
        }
        long l2 = new Date().getTime();
    }

    private void _$5167(boolean bl) {
        this._$4280 = 29;
        this._$4295 = null;
        this._$4299 = null;
        this._$4305 = null;
        this._$4318 = 0L;
        if (bl) {
            this._$4350 = null;
            this._$4333 = null;
            this._$4357 = -1L;
            this._$4403 = -1L;
            this._$4370 = -1L;
            this._$4379 = -1L;
            this._$4391 = -1L;
            this._$4412 = -1L;
            this._$4262 = null;
        }
        this._$4431 = -2L;
    }

    private String _$4970(String string, boolean bl, boolean bl2) {
        String string2 = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this._$4087 == null ? "" : String.valueOf(String.valueOf("service=").concat(String.valueOf(URLEncoder.encode(this._$4087)))).concat(String.valueOf("&"))).concat(String.valueOf(ILS_HTTP_KWD_CLOCK_STR))).concat(String.valueOf("="))).concat(String.valueOf(new Date().getTime() / (long)1000))).concat(String.valueOf("&"))).concat(String.valueOf(ILS_HTTP_KWD_CMD_STR))).concat(String.valueOf("="))).concat(String.valueOf(string))).concat(String.valueOf("&"))).concat(String.valueOf(ILS_HTTP_KWD_MACHINE_STR))).concat(String.valueOf("="))).concat(String.valueOf(URLEncoder.encode(this._$4099)));
        if (this._$4333 != null) {
            string2 = String.valueOf(string2).concat(String.valueOf(String.valueOf("&params=").concat(String.valueOf(URLEncoder.encode(this._$4333)))));
        }
        if (this._$4403 != (long)-1) {
            string2 = String.valueOf(string2).concat(String.valueOf(String.valueOf("&quota_cap=").concat(String.valueOf(this._$4403))));
        }
        if (this._$4412 > (long)0) {
            string2 = String.valueOf(string2).concat(String.valueOf(String.valueOf("&userexpts=").concat(String.valueOf(this._$4412))));
        }
        if (bl) {
            string2 = String.valueOf(string2).concat(String.valueOf(String.valueOf("&token=").concat(String.valueOf(URLEncoder.encode(this._$4262)))));
        }
        if (bl2) {
            if (this._$4162 > (long)0) {
                string2 = String.valueOf(string2).concat(String.valueOf(String.valueOf("&session=").concat(String.valueOf(this._$4162))));
            }
            if (this._$4135 != null) {
                string2 = String.valueOf(string2).concat(String.valueOf(String.valueOf("&domain=").concat(String.valueOf(URLEncoder.encode(this._$4135)))));
            }
            if (this._$4146 != null) {
                string2 = String.valueOf(string2).concat(String.valueOf(String.valueOf("&user=").concat(String.valueOf(URLEncoder.encode(this._$4146)))));
            }
            if (this._$4155 != null) {
                string2 = String.valueOf(string2).concat(String.valueOf(String.valueOf("&passwd=").concat(String.valueOf(URLEncoder.encode(this._$4155)))));
            }
        }
        return string2;
    }

    private String _$5457(String string, String string2) {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("customcmd=").concat(String.valueOf(string))).concat(String.valueOf("&"))).concat(String.valueOf(ILS_HTTP_KWD_CUSTOMCTX_STR))).concat(String.valueOf("="))).concat(String.valueOf(string2));
    }

    private String _$5372(String string) {
        return String.valueOf("appctx=").concat(String.valueOf(string));
    }

    private String _$4992() {
        return String.valueOf("points=").concat(String.valueOf(this._$4191));
    }

    private String _$5013(long l) {
        return String.valueOf("ttl=").concat(String.valueOf(l));
    }

    private String _$5036(String string) {
        return String.valueOf("options=").concat(String.valueOf(string));
    }

    private String _$5581() {
        return "updateok=1";
    }

    private String _$5604(String string) {
        return String.valueOf("enable=").concat(String.valueOf(string));
    }

    private String _$5625() {
        return "checkedout=No";
    }

    private String _$5076(String string) {
        return String.valueOf("customctx=").concat(String.valueOf(string));
    }

    private String _$5310(int n) {
        return String.valueOf("quota=").concat(String.valueOf(n));
    }

    private String _$5755(String string, String string2) {
        return String.valueOf(String.valueOf(string).concat(String.valueOf("="))).concat(String.valueOf(URLEncoder.encode(string2)));
    }

    private String _$6352(String string) {
        String string2 = String.valueOf(String.valueOf("product=").concat(String.valueOf(URLEncoder.encode(this._$4123)))).concat(String.valueOf("&"));
        string2 = this._$4209 != null ? String.valueOf(string2).concat(String.valueOf(String.valueOf("envelope=").concat(String.valueOf(URLEncoder.encode(PkCrypt.encryptWithPublicKey((String)string, (String)this._$4209)))))) : String.valueOf(string2).concat(String.valueOf(string));
        return string2;
    }

    private String _$6386(String string) {
        if (this._$4209 == null) {
            return string;
        }
        if (string.startsWith("envelope=")) {
            int n = (string = string.substring(string.indexOf("=") + 1)).indexOf("|");
            if (n > 0) {
                String string2 = string.substring(n + 1);
                string2 = string2.substring(string2.indexOf("=") + 1);
                try {
                    this._$4431 = Long.parseLong(string2);
                }
                catch (Throwable throwable) {
                    this._$4431 = -1L;
                }
                string = string.substring(0, n);
            }
            string = PkCrypt.decryptWithPublicKey((String)string, (String)this._$4209);
        }
        return string;
    }

    private boolean _$5108() {
        StringTokenizer stringTokenizer = new StringTokenizer(this._$4268, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            int n = string.indexOf("=");
            if (n <= 0 || n == string.length()) {
                return false;
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            if (string2.equals(ILS_HTTP_KWD_PROTOCOL_STR)) {
                try {
                    this._$4422 = Integer.parseInt(string3);
                }
                catch (Throwable throwable) {
                    boolean bl = this._$5128(String.valueOf("bad protocol value: ").concat(String.valueOf(string3)));
                    return bl;
                }
                if (this._$4422 >= 3) continue;
                return this._$5128(String.valueOf("incompatible / old server protocol version ").concat(String.valueOf(this._$4422)));
            }
            if (string2.equals(ILS_HTTP_KWD_STATUS_STR)) {
                try {
                    this._$4280 = Integer.parseInt(string3);
                    continue;
                }
                catch (Throwable throwable) {
                    boolean bl = this._$5128(String.valueOf("bad status value: ").concat(String.valueOf(string3)));
                    return bl;
                }
            }
            if (string2.equals(ILS_HTTP_KWD_MSG_STR)) {
                this._$4295 = URLDecoder.decode(string3);
                continue;
            }
            if (string2.equals(ILS_HTTP_KWD_VALUE_STR)) {
                this._$4299 = URLDecoder.decode(string3);
                continue;
            }
            if (string2.equals(ILS_HTTP_KWD_OPTIONS_STR)) {
                this._$4287 = URLDecoder.decode(string3);
                continue;
            }
            if (string2.equals(ILS_HTTP_KWD_PARAMS_STR)) {
                this._$4333 = URLDecoder.decode(string3);
                continue;
            }
            if (string2.equals(ILS_HTTP_KWD_CUSTOMCTX_STR)) {
                this._$4340 = URLDecoder.decode(string3);
                continue;
            }
            if (string2.equals(ILS_HTTP_KWD_TOKEN_STR)) {
                this._$4262 = URLDecoder.decode(string3);
                continue;
            }
            if (string2.equals(ILS_HTTP_KWD_MACHINE_STR)) {
                this._$4305 = URLDecoder.decode(string3);
                continue;
            }
            if (string2.equals(ILS_HTTP_KWD_SESSION_STR)) {
                try {
                    this._$4318 = Long.parseLong(string3);
                    continue;
                }
                catch (Throwable throwable) {
                    boolean bl = this._$5128(String.valueOf("bad session id value: ").concat(String.valueOf(string3)));
                    return bl;
                }
            }
            if (string2.equals(ILS_HTTP_KWD_APPCTX_STR)) {
                this._$4350 = URLDecoder.decode(string3);
                continue;
            }
            if (string2.equals(ILS_HTTP_KWD_USER_EXPTS_STR)) {
                try {
                    this._$4412 = Long.parseLong(string3);
                    continue;
                }
                catch (Throwable throwable) {
                    boolean bl = this._$5128(String.valueOf("bad user expiration timestamp value: ").concat(String.valueOf(string3)));
                    return bl;
                }
            }
            if (string2.equals(ILS_HTTP_KWD_QUOTA_STR)) {
                try {
                    this._$4357 = Long.parseLong(string3);
                    continue;
                }
                catch (Throwable throwable) {
                    boolean bl = this._$5128(String.valueOf("bad balance quota value: ").concat(String.valueOf(string3)));
                    return bl;
                }
            }
            if (string2.equals(ILS_HTTP_KWD_QUOTA_CAP_STR)) {
                try {
                    this._$4403 = Long.parseLong(string3);
                    continue;
                }
                catch (Throwable throwable) {
                    boolean bl = this._$5128(String.valueOf("bad quota cap value: ").concat(String.valueOf(string3)));
                    return bl;
                }
            }
            if (string2.equals(ILS_HTTP_KWD_DURATION_STR)) {
                try {
                    this._$4370 = Long.parseLong(string3);
                    continue;
                }
                catch (Throwable throwable) {
                    boolean bl = this._$5128(String.valueOf("bad duration value: ").concat(String.valueOf(string3)));
                    return bl;
                }
            }
            if (string2.equals(ILS_HTTP_KWD_MIN_DURATION_STR)) {
                try {
                    this._$4379 = Long.parseLong(string3);
                    continue;
                }
                catch (Throwable throwable) {
                    boolean bl = this._$5128(String.valueOf("bad minimum-duration value: ").concat(String.valueOf(string3)));
                    return bl;
                }
            }
            if (string2.equals(ILS_HTTP_KWD_MAX_DURATION_STR)) {
                try {
                    this._$4391 = Long.parseLong(string3);
                    continue;
                }
                catch (Throwable throwable) {
                    boolean bl = this._$5128(String.valueOf("bad maximum-duration value: ").concat(String.valueOf(string3)));
                    return bl;
                }
            }
            if (string2.equals(ILS_HTTP_KWD_SVRTIME_STR)) {
                try {
                    this._$4431 = Long.parseLong(string3);
                }
                catch (Throwable throwable) {
                    this._$4431 = -1L;
                }
                continue;
            }
            return this._$5128(String.valueOf("unrecognized keyword: ").concat(String.valueOf(string)));
        }
        return this._$4280 <= 0;
    }

    private boolean _$5128(String string) {
        this._$4280 = 23;
        this._$4295 = "protocol violation";
        this._$4299 = string;
        return false;
    }

    /*
     * Loose catch block
     */
    private boolean _$5100(String string) {
        Util.Trace(10, "postMsg", String.valueOf("Request string: ").concat(String.valueOf(string)));
        string = String.valueOf(ILS_SIGNATURE).concat(String.valueOf(this._$6352(string)));
        String string2 = "";
        if (this._$4077.startsWith("inprocess:")) {
            try {
                Class<?> clazz = Class.forName("com.vs.ils.IlsCmdDriver");
                Object obj = clazz.newInstance();
                Method method = clazz.getMethod("processClientCmd", Class.forName("java.lang.String"));
                Object[] objectArray = new Object[]{string};
                string2 = (String)method.invoke(obj, objectArray);
            }
            catch (Throwable throwable) {
                boolean bl = this._$6609(String.valueOf("unable to dynamically invoke method in class com.vs.ils.IlsCmdDriver: check classpath.  Details: ").concat(String.valueOf(throwable.getMessage())));
                return bl;
            }
        }
        long l = new Date().getTime();
        InputStreamReader inputStreamReader = null;
        int n = 0;
        while (true) {
            URL uRL = new URL(this._$4077);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoOutput(true);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(uRLConnection.getOutputStream());
            outputStreamWriter.write(string);
            outputStreamWriter.flush();
            outputStreamWriter.close();
            inputStreamReader = new InputStreamReader(uRLConnection.getInputStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                string2 = String.valueOf(string2).concat(String.valueOf(string3));
            }
            inputStreamReader.close();
            inputStreamReader = null;
            Object var13_15 = null;
            if (inputStreamReader == null) break;
            try {
                inputStreamReader.close();
            }
            catch (Exception exception) {}
            break;
            {
                catch (Throwable throwable) {
                    Util.Trace(7, "postMsg", new String[]{String.valueOf(String.valueOf(String.valueOf("*** Error connecting to url.  Exception: ").concat(String.valueOf(throwable.getClass().getName()))).concat(String.valueOf(", Message: "))).concat(String.valueOf(throwable.getMessage()))}, true, throwable);
                    if (++n == 10) {
                        boolean bl = this._$6609("unable to connect to Ils server");
                        var13_15 = null;
                        if (inputStreamReader != null) {
                            try {
                                inputStreamReader.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return bl;
                    }
                    var13_15 = null;
                    if (inputStreamReader == null) continue;
                    try {
                        inputStreamReader.close();
                    }
                    catch (Exception exception) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var13_15 = null;
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        long l2 = new Date().getTime();
        Util.Trace(10, "postMsg", String.valueOf(String.valueOf("CLIENT TIME TRACE: Elapsed comm time: ").concat(String.valueOf(l2 - l))).concat(String.valueOf(" ms.")));
        if (!string2.startsWith(ILS_HTTP_MSG_PREFIX)) {
            return this._$6609("error response from Ils server");
        }
        Util.Trace(10, "postMsg", String.valueOf("Response string: ").concat(String.valueOf(string2)));
        this._$4268 = string2.substring(string2.indexOf("|") + 1);
        this._$4268 = this._$6386(this._$4268);
        return true;
    }

    private boolean _$6609(String string) {
        this._$4280 = 29;
        this._$4295 = string;
        return false;
    }

    private static String _$4111() {
        String string = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            if (inetAddress != null) {
                string = inetAddress.getHostName();
            }
            if (string == null) {
                string = "localhost";
            }
        }
        catch (Throwable throwable) {
            string = "localhost";
        }
        return string;
    }

    private static long _$4802(String string) {
        long l = -1L;
        try {
            l = Long.parseLong(string);
        }
        catch (Throwable throwable) {
            l = -1L;
        }
        return l;
    }

    public static boolean dropHfile(String string) {
        return Hfile.dropHfile(string);
    }
}

