/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.mockingbird.instrumenter;

import com.agitar.common.asm.AsmUtil;
import com.agitar.common.util.ClassCacheMap;
import com.agitar.common.util.DefiningClassLoader;
import com.agitar.common.util.ReflectionCache;
import com.agitar.lib.mockingbird.MockingbirdError;
import com.agitar.lib.mockingbird.Utils;
import com.agitar.mockingbird.instrumenter.AsmMockingbirdConstants;
import com.agitar.mockingbird.instrumenter.AsmMockingbirdUtility;
import com.agitar.mockingbird.instrumenter.MethodContainer;
import com.agitar.mockingbird.instrumenter.MockingbirdInstrumenter;
import com.agitar.security.AgPolicy;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Constants;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class MockingbirdSubclassCache
implements ReflectionCache,
AsmMockingbirdConstants {
    public static final MockingbirdSubclassCache cache = new MockingbirdSubclassCache();
    private MyClassLoader currentClassLoader = new MyClassLoader();
    private final Map currentClassCache = new ClassCacheMap(MockingbirdSubclassCache.class.getName());
    static /* synthetic */ Class class$com$agitar$mockingbird$instrumenter$MockingbirdSubclassCache$MyClassLoader;
    static /* synthetic */ Class class$java$lang$Throwable;

    public static Class generate(Class cls) throws IOException, ClassNotFoundException {
        return MockingbirdSubclassCache.generate(cls, true);
    }

    public static Class generate(Class cls, boolean overrideMethods) throws IOException, ClassNotFoundException {
        Class subClass = (Class)MockingbirdSubclassCache.cache.currentClassCache.get(cls.getName());
        if (subClass != null) {
            return subClass;
        }
        subClass = MockingbirdSubclassCache.cache.currentClassLoader.load(Utils.getSubclassName(cls), cls, overrideMethods);
        MockingbirdSubclassCache.cache.currentClassCache.put(cls.getName(), subClass);
        return subClass;
    }

    public void releaseReflection() {
        this.currentClassLoader = new MyClassLoader();
        this.currentClassCache.clear();
    }

    private MockingbirdSubclassCache() {
    }

    private static class MockingbirdSubclassGenerator
    implements Constants,
    AsmMockingbirdConstants {
        private final ClassNode classNode;
        private final ClassWriter cw;
        private final String className;
        private final boolean isSystemClass;
        private final boolean overrideMethods;
        private final boolean isSubclassOfThrowable;
        private static final String CONSTRUCTOR_NAME = "<init>";

        private static byte[] generateByteCode(String className, Class cls, boolean overrideMethods) throws IOException {
            String canBeInherited = Utils.canBeInherited(cls);
            if (canBeInherited != null) {
                throw new MockingbirdError(cls.getName() + ": " + canBeInherited);
            }
            MockingbirdSubclassGenerator srg = new MockingbirdSubclassGenerator(AsmMockingbirdUtility.getClassNode(cls), Utils.isSystemClass(cls), overrideMethods, (class$java$lang$Throwable == null ? (class$java$lang$Throwable = MockingbirdSubclassCache.class$("java.lang.Throwable")) : class$java$lang$Throwable).isAssignableFrom(cls));
            return srg.generate(cls.getClassLoader());
        }

        private MockingbirdSubclassGenerator(ClassNode node, boolean isSystemClass, boolean overrideMethods, boolean isSubclassOfThrowable) {
            this.overrideMethods = overrideMethods;
            this.isSubclassOfThrowable = isSubclassOfThrowable;
            this.isSystemClass = isSystemClass;
            this.classNode = node;
            this.className = (isSystemClass ? "com.agitar.lib.mockingbird.".replace('.', '/') : "") + this.classNode.name + "_Mock";
            this.cw = new ClassWriter(true, true);
        }

        private byte[] generate(ClassLoader classLoader) {
            boolean isInterface = Modifier.isInterface(this.classNode.access);
            this.cw.visit(this.classNode.version, 33, this.className, isInterface ? AsmUtil.JAVA_LANG_OBJECT_TYPE.getInternalName() : this.classNode.name, new String[]{MOCKINGBIRD_SUBCLASS_PROXY_CLASS_TYPE.getInternalName()}, null);
            HashMap map = new HashMap();
            MockingbirdSubclassGenerator.getMethods(map, classLoader, this.classNode, this.isSystemClass, new HashSet());
            Iterator iter = map.values().iterator();
            while (iter.hasNext()) {
                MethodContainer mc = (MethodContainer)iter.next();
                if (this.isSubclassOfThrowable && MockingbirdInstrumenter.isSpecialMethod(mc.method) || mc.isStatic || mc.isPrivate || mc.isFinal || !this.overrideMethods && !mc.isAbstract && !mc.isSystemClass) continue;
                this.generateMethod(mc);
            }
            this.generateConstructor();
            this.cw.visitEnd();
            return this.cw.toByteArray();
        }

        private void generateConstructor() {
            MethodNode constructor = null;
            Iterator iter = this.classNode.methods.iterator();
            while (iter.hasNext()) {
                MethodNode method = (MethodNode)iter.next();
                if (!method.name.equals(CONSTRUCTOR_NAME) || constructor != null && method.desc.length() >= constructor.desc.length()) continue;
                constructor = method;
            }
            CodeVisitor cv = this.cw.visitMethod(1, CONSTRUCTOR_NAME, "()V", null, null);
            cv.visitVarInsn(25, 0);
            if (constructor != null) {
                MethodContainer mc = new MethodContainer(constructor);
                for (int i = 0; i < mc.paramTypes.length; ++i) {
                    Type type = mc.paramTypes[i];
                    AsmMockingbirdUtility.loadDefaultValue(cv, type);
                }
            }
            cv.visitMethodInsn(183, constructor == null ? AsmUtil.JAVA_LANG_OBJECT_TYPE.getInternalName() : this.classNode.name, CONSTRUCTOR_NAME, constructor == null ? "()V" : constructor.desc);
            cv.visitVarInsn(25, 0);
            cv.visitInsn(177);
            cv.visitMaxs(1, 1);
        }

        private void generateMethod(MethodContainer mc) {
            int access = 1;
            if ((mc.method.access & 0x20) > 0) {
                access += 32;
            }
            CodeVisitor cv = this.cw.visitMethod(access, mc.method.name, mc.method.desc, AsmMockingbirdUtility.strings(mc.method.exceptions), mc.method.attrs);
            if (mc.method.name.equals("finalize") && mc.method.desc.equals("()V")) {
                cv.visitInsn(mc.returnType.getOpcode(172));
            } else {
                AsmMockingbirdUtility.mockingbirdCode(this.className, mc.method, cv, false);
                this.checkReturn(mc, cv);
            }
            cv.visitMaxs(1, 1);
        }

        private void checkReturn(MethodContainer mc, CodeVisitor cv) {
            IS_IN_TEST_MODE.visitMethod(cv);
            Label l0 = new Label();
            cv.visitJumpInsn(154, l0);
            AsmMockingbirdUtility.loadDefaultValue(cv, mc.returnType);
            cv.visitInsn(mc.returnType.getOpcode(172));
            cv.visitLabel(l0);
            String methodName = mc.method.name;
            if (methodName.equals(MockingbirdSubclassGenerator.TO_STRING.methodName) && mc.method.desc.equals(MockingbirdSubclassGenerator.TO_STRING.description)) {
                cv.visitLdcInsn((Object)this.className.replace('/', '.'));
                cv.visitVarInsn(25, 0);
                COMPUTE_TO_STRING.visitMethod(cv);
                cv.visitInsn(mc.returnType.getOpcode(172));
            } else {
                cv.visitTypeInsn(187, NO_RECORDING_IN_TAPE_ERROR_CLASS_TYPE.getInternalName());
                cv.visitInsn(89);
                String signature = Utils.convertToPrettySignature(methodName, mc.method.desc);
                cv.visitLdcInsn((Object)signature);
                NEW_NO_RECORDING_IN_TAPE_ERROR.visitMethod(cv);
                cv.visitInsn(191);
            }
        }

        private static void getMethods(Map map, ClassLoader classLoader, ClassNode node, boolean isSystemClass, Set processed) {
            MockingbirdSubclassGenerator.getMethods(map, node, isSystemClass, processed);
            if (node.superName != null) {
                try {
                    AsmMockingbirdUtility.ClassNodeWrapper wrapper = AsmMockingbirdUtility.getClassNodeWrapper(classLoader, node.superName + ".class");
                    MockingbirdSubclassGenerator.getMethods(map, classLoader, wrapper.node, wrapper.isSystemClass, processed);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            Iterator iter = node.interfaces.iterator();
            while (iter.hasNext()) {
                String interfaceName = (String)iter.next();
                try {
                    AsmMockingbirdUtility.ClassNodeWrapper wrapper = AsmMockingbirdUtility.getClassNodeWrapper(classLoader, interfaceName + ".class");
                    MockingbirdSubclassGenerator.getMethods(map, classLoader, wrapper.node, wrapper.isSystemClass, processed);
                }
                catch (IOException e) {}
            }
        }

        private static void getMethods(Map map, ClassNode node, boolean isSystemClass, Set processed) {
            if (node.name.equals(AsmUtil.JAVA_LANG_OBJECT_TYPE.getInternalName())) {
                MockingbirdSubclassGenerator.addInstrumentableMethodsFromJavaLangObject(map, node, isSystemClass, processed);
                return;
            }
            boolean isInJavaPackage = AsmMockingbirdUtility.isInJavaPackage(node.name);
            Iterator iter = node.methods.iterator();
            while (iter.hasNext()) {
                MethodNode method = (MethodNode)iter.next();
                if (method.name.startsWith("<") || Modifier.isPrivate(method.access) || Modifier.isStatic(method.access) || AsmMockingbirdUtility.isSynthetic(method.access)) continue;
                String key = MockingbirdSubclassGenerator.getKey(method);
                if (isInJavaPackage && AsmMockingbirdUtility.isPackageFriendly(method) || isSystemClass && Modifier.isFinal(method.access)) {
                    processed.add(key);
                    continue;
                }
                if (processed.contains(key) || map.get(key) != null) continue;
                MethodContainer mc = new MethodContainer(method, isSystemClass);
                map.put(key, mc);
            }
        }

        private static void addInstrumentableMethodsFromJavaLangObject(Map map, ClassNode node, boolean isSystemClass, Set processed) {
            Iterator iter = node.methods.iterator();
            while (iter.hasNext()) {
                String key;
                MethodNode method = (MethodNode)iter.next();
                if (!AsmMockingbirdUtility.instrumentableMethodFromJavaLangObject(method) || processed.contains(key = MockingbirdSubclassGenerator.getKey(method)) || map.get(key) != null) continue;
                MethodContainer mc = new MethodContainer(method, isSystemClass);
                map.put(key, mc);
            }
        }

        private static String getKey(MethodNode method) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(method.name);
            buffer.append('.');
            buffer.append(method.desc);
            String key = buffer.toString();
            return key;
        }
    }

    private static class MyClassLoader
    extends ClassLoader {
        public MyClassLoader() {
            super((class$com$agitar$mockingbird$instrumenter$MockingbirdSubclassCache$MyClassLoader == null ? (class$com$agitar$mockingbird$instrumenter$MockingbirdSubclassCache$MyClassLoader = MockingbirdSubclassCache.class$("com.agitar.mockingbird.instrumenter.MockingbirdSubclassCache$MyClassLoader")) : class$com$agitar$mockingbird$instrumenter$MockingbirdSubclassCache$MyClassLoader).getClassLoader());
        }

        Class load(String subclassName, Class cls, boolean overrideMethods) throws ClassNotFoundException, IOException {
            ClassLoader contextLoader;
            Class<?> c = this.findLoadedClass(subclassName);
            if (c != null) {
                return c;
            }
            if (Utils.getLogger() != null && Utils.getLogger().getLevel() != null && Level.FINE.intValue() >= Utils.getLogger().getLevel().intValue()) {
                Utils.getLogger().fine((class$com$agitar$mockingbird$instrumenter$MockingbirdSubclassCache$MyClassLoader == null ? (class$com$agitar$mockingbird$instrumenter$MockingbirdSubclassCache$MyClassLoader = MockingbirdSubclassCache.class$("com.agitar.mockingbird.instrumenter.MockingbirdSubclassCache$MyClassLoader")) : class$com$agitar$mockingbird$instrumenter$MockingbirdSubclassCache$MyClassLoader).getName() + " asked to load " + subclassName + ", for class: " + cls.getName() + " loaded by " + cls.getClassLoader());
            }
            if ((contextLoader = cls.getClassLoader()) == null) {
                contextLoader = MyClassLoader.getSystemClassLoader();
            }
            if (contextLoader instanceof DefiningClassLoader && (c = ((DefiningClassLoader)contextLoader).findPreviousLoadedClass(subclassName)) != null) {
                return c;
            }
            byte[] bytes = MockingbirdSubclassGenerator.generateByteCode(subclassName, cls, overrideMethods);
            if (contextLoader instanceof DefiningClassLoader) {
                return ((DefiningClassLoader)contextLoader).loadClassFromBytes(subclassName, bytes);
            }
            c = this.defineClass(subclassName, bytes, 0, bytes.length, new ProtectionDomain(AgPolicy.USER_CODE, null, this, null));
            this.loadClass(subclassName);
            return c;
        }
    }
}

