/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.mockingbird.instrumenter;

import com.agitar.common.asm.AsmUtil;
import com.agitar.common.asm.BytecodeSizeChecker;
import com.agitar.lib.mockingbird.ClassCache;
import com.agitar.lib.mockingbird.MockingbirdError;
import com.agitar.lib.mockingbird.Utils;
import com.agitar.mockingbird.instrumenter.AsmMockingbirdConstants;
import com.agitar.mockingbird.instrumenter.AsmMockingbirdUtility;
import com.agitar.mockingbird.instrumenter.ByteCodeSubstitution;
import com.agitar.mockingbird.instrumenter.ConstructorInstrumenter;
import com.agitar.mockingbird.instrumenter.MethodContainer;
import com.agitar.mockingbird.instrumenter.ThreadAndSystemInOutErrSubstitution;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.CodeWriter;
import org.objectweb.asm.Constants;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MethodNode;

public class MockingbirdInstrumenter
implements Constants,
AsmMockingbirdConstants {
    private static final String JAVA_LANG_OBJECT_INTERNAL_NAME = AsmUtil.JAVA_LANG_OBJECT_TYPE.getInternalName();
    private boolean isCUT;
    private static ByteCodeSubstitution byteCodeSubstitution = new ByteCodeSubstitution.NullByteCodeSubstitution();
    private static MethodNode[] javaLangObjectMethods;
    private static AsmMockingbirdUtility.ClassNodeWrapper javaLangObjectNode;
    private int instrumentedMethodCount;
    private Set signatures = new HashSet();
    private ClassWriter cw;
    private final String internalName;
    private final ClassNode classNode;
    private final byte[] bytes;
    private final boolean isInterface;
    private static int totalSize;
    private static int totalCount;
    static /* synthetic */ Class class$java$lang$Throwable;

    public static void setMethodCallSubstitution(ByteCodeSubstitution subs) {
        byteCodeSubstitution = subs;
    }

    public static byte[] instrument(byte[] bytes, Set targetClasses) {
        MockingbirdInstrumenter instrumenter = new MockingbirdInstrumenter(bytes, targetClasses);
        byte[] result = instrumenter.instrument();
        if (result.length != bytes.length && instrumenter.instrumentedMethodCount > 0) {
            totalCount += instrumenter.instrumentedMethodCount;
            totalSize += result.length - bytes.length;
        }
        return result;
    }

    private MockingbirdInstrumenter(byte[] oldBytes, Set targetClasses) {
        this.bytes = oldBytes;
        this.cw = new ClassWriter(true, true);
        this.classNode = AsmMockingbirdUtility.getClassNode(new ClassReader(this.bytes));
        this.internalName = this.classNode.name;
        this.isInterface = Modifier.isInterface(this.classNode.access);
        this.isCUT = targetClasses != null && targetClasses.contains(this.classNode.name.replace('/', '.'));
    }

    private byte[] instrument() {
        boolean needToAddClassLoaderField;
        LinkedHashSet interfaces = new LinkedHashSet(this.classNode.interfaces);
        if (interfaces.contains(AGITAR_PROXY_CLASS_TYPE.getInternalName())) {
            return this.bytes;
        }
        ArrayList<String> list = new ArrayList<String>(interfaces);
        list.add(AGITAR_PROXY_CLASS_TYPE.getInternalName());
        this.cw.visit(this.classNode.version, this.classNode.access, this.classNode.name, this.classNode.superName, AsmMockingbirdUtility.strings(list), this.classNode.sourceFile);
        if (this.classNode.attrs != null) {
            this.cw.visitAttribute(this.classNode.attrs);
        }
        List inners = this.classNode.innerClasses;
        Iterator iter = inners.iterator();
        while (iter.hasNext()) {
            InnerClassNode inner = (InnerClassNode)iter.next();
            this.cw.visitInnerClass(inner.name, inner.outerName, inner.innerName, inner.access);
        }
        MethodNode[] methodNodes = this.classNode.methods.toArray(new MethodNode[0]);
        MethodNode clinit = this.processMethods(methodNodes);
        boolean bl = needToAddClassLoaderField = !this.classLoaderFieldExists();
        if (needToAddClassLoaderField && clinit == null) {
            AsmUtil.addClinit((ClassVisitor)this.cw, (String)this.classNode.name);
        } else if (clinit != null) {
            this.handleClinit(clinit, needToAddClassLoaderField);
        }
        if (!this.isInterface) {
            this.addMethodsFromSuperClass(this.classNode.superName);
        }
        this.processFields(needToAddClassLoaderField);
        this.cw.visitEnd();
        byte[] toByteArray = this.cw.toByteArray();
        return toByteArray;
    }

    private void processFields(boolean addClassLoaderField) {
        Iterator iter = this.classNode.fields.iterator();
        while (iter.hasNext()) {
            FieldNode field = (FieldNode)iter.next();
            int access = this.isInterface ? field.access : field.access & 0xFFFFFFEF;
            this.cw.visitField(access, field.name, field.desc, field.value, field.attrs);
        }
        if (addClassLoaderField) {
            AsmUtil.addAgitarClassLoaderField((ClassVisitor)this.cw, (boolean)this.isInterface);
        }
    }

    private boolean classLoaderFieldExists() {
        Iterator iter = this.classNode.fields.iterator();
        while (iter.hasNext()) {
            FieldNode field = (FieldNode)iter.next();
            if (!field.name.equals("$agitar_classloader")) continue;
            return true;
        }
        return false;
    }

    static boolean isSpecialMethod(MethodNode method) {
        return method.name.equals("hashCode") && method.desc.equals("()I") || method.name.equals(MockingbirdInstrumenter.FILL_STACK_TRACE.methodName) && method.desc.equals(MockingbirdInstrumenter.FILL_STACK_TRACE.description) || method.name.equals(MockingbirdInstrumenter.GET_STACK_TRACE.methodName) && method.desc.equals(MockingbirdInstrumenter.GET_STACK_TRACE.description) || method.name.equals(MockingbirdInstrumenter.SET_STACK_TRACE.methodName) && method.desc.equals(MockingbirdInstrumenter.SET_STACK_TRACE.description);
    }

    private void addMethodsFromSuperClass(String superName) {
        while (!JAVA_LANG_OBJECT_INTERNAL_NAME.equals(superName)) {
            Class superClass = ClassCache.getClassFromInternalName(superName, null, false);
            boolean systemClass = Utils.isSystemClass(superClass);
            if (systemClass) {
                try {
                    boolean isSubclassOfThrowable = (class$java$lang$Throwable == null ? MockingbirdInstrumenter.class$("java.lang.Throwable") : class$java$lang$Throwable).isAssignableFrom(superClass);
                    AsmMockingbirdUtility.ClassNodeWrapper superNode = AsmMockingbirdUtility.getClassNodeWrapper(superClass);
                    MethodNode[] methodNodes = superNode.getMethods();
                    this.addMethods(systemClass, isSubclassOfThrowable, superNode, methodNodes);
                }
                catch (IOException e) {
                    throw new MockingbirdError("Cannot load class file of '" + superClass.getName() + "'", e);
                }
            }
            superName = superClass.getSuperclass().getName().replace('.', '/');
        }
        if (!this.isInterface) {
            this.addMethodsFormJavaLangObject();
        }
    }

    private void addMethods(boolean systemClass, boolean isSubclassOfThrowable, AsmMockingbirdUtility.ClassNodeWrapper superNode, MethodNode[] methodNodes) {
        for (int i = 0; i < methodNodes.length; ++i) {
            MethodNode method = methodNodes[i];
            int access = method.access;
            if (method.name.startsWith("<")) continue;
            if (Modifier.isStatic(access) || (access & 0x1000) > 0 || Modifier.isAbstract(access) || Modifier.isFinal(access) || Modifier.isPrivate(access) || !Modifier.isPublic(access) && !Modifier.isProtected(access) || isSubclassOfThrowable && MockingbirdInstrumenter.isSpecialMethod(method)) {
                this.signatures.add(this.getKey(method));
                continue;
            }
            this.addMethod(superNode, method, systemClass);
        }
    }

    private void addMethodsFormJavaLangObject() {
        MethodNode[] methods = MockingbirdInstrumenter.getjavaLangObjectMethods();
        this.addMethods(true, false, javaLangObjectNode, methods);
    }

    private static MethodNode[] getjavaLangObjectMethods() {
        if (javaLangObjectMethods == null) {
            try {
                ArrayList<MethodNode> list = new ArrayList<MethodNode>();
                javaLangObjectNode = AsmMockingbirdUtility.getClassNodeWrapper(Object.class);
                MethodNode[] methods = javaLangObjectNode.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    MethodNode method = methods[i];
                    if (!AsmMockingbirdUtility.instrumentableMethodFromJavaLangObject(method)) continue;
                    list.add(method);
                }
                javaLangObjectMethods = list.toArray(new MethodNode[0]);
            }
            catch (IOException e) {
                javaLangObjectMethods = new MethodNode[0];
                throw new MockingbirdError("Cannot load class file of '" + Object.class.getName() + "'", e);
            }
        }
        return javaLangObjectMethods;
    }

    private void addMethod(AsmMockingbirdUtility.ClassNodeWrapper superNode, MethodNode method, boolean systemClass) {
        if (this.signatures.add(this.getKey(method))) {
            CodeVisitor cv = AsmMockingbirdUtility.visitMethod(this.cw, method, method.access & 0xFFFFFEFF);
            AsmMockingbirdUtility.mockingbirdCode(this.internalName, method, cv, true);
            MethodContainer mc = new MethodContainer(method, systemClass);
            AsmMockingbirdUtility.superMethodCall(superNode.node, mc, cv);
            cv.visitInsn(mc.returnType.getOpcode(172));
            cv.visitMaxs(1, 1);
        }
    }

    private String getKey(MethodNode method) {
        String sig = method.name + method.desc;
        return sig;
    }

    private MethodNode processMethods(MethodNode[] methods) {
        MethodNode clinit = null;
        for (int i = 0; i < methods.length; ++i) {
            MethodNode method = methods[i];
            CodeVisitor cv = null;
            if (MockingbirdInstrumenter.shouldNotInstruemnt(method)) {
                method.accept((ClassVisitor)this.cw);
                this.addSignature(method);
            } else if (method.name.equals("<init>")) {
                ++this.instrumentedMethodCount;
                cv = this.visitMethod(method);
                ConstructorInstrumenter.visit(this.internalName, this.classNode.superName, method, cv);
            } else if (method.name.equals("<clinit>")) {
                clinit = method;
            } else {
                ++this.instrumentedMethodCount;
                cv = this.visitMethod(method);
                AsmMockingbirdUtility.mockingbirdCode(this.internalName, method, cv, true);
                this.copyMethod(method, cv);
                cv.visitMaxs(1, 1);
            }
            if (cv == null || !(cv instanceof CodeWriter)) continue;
            BytecodeSizeChecker.check((CodeVisitor)((CodeWriter)cv), (String)this.internalName, (String)method.name, (String)method.desc, (boolean)true, (boolean)true);
        }
        return clinit;
    }

    private static boolean shouldNotInstruemnt(MethodNode node) {
        int access = node.access;
        if (Modifier.isAbstract(access)) {
            return true;
        }
        if (Modifier.isNative(access)) {
            return true;
        }
        return (access & 0x1000) > 0 && !node.name.startsWith("access$");
    }

    private void handleClinit(MethodNode method, boolean needToAddClassLoaderField) {
        CodeVisitor cv = AsmMockingbirdUtility.visitMethod(this.cw, method);
        if (needToAddClassLoaderField) {
            AsmUtil.initAgitarClassLoaderField((CodeVisitor)cv, (String)this.internalName);
        }
        Label tryLabel = new Label();
        cv.visitLabel(tryLabel);
        cv.visitLdcInsn((Object)this.internalName);
        ENTER_CLINIT.visitMethod(cv);
        this.copyMethod(method, cv);
        Label catchEnd = new Label();
        cv.visitJumpInsn(167, catchEnd);
        Label catchLabel = new Label();
        cv.visitLabel(catchLabel);
        cv.visitVarInsn(58, 0);
        cv.visitVarInsn(25, 0);
        FILL_STACK_TRACE.visitMethod(cv);
        cv.visitVarInsn(58, 0);
        cv.visitLdcInsn((Object)this.internalName);
        cv.visitVarInsn(25, 0);
        CLINIT_SHOULD_THROW.visitMethod(cv);
        cv.visitLdcInsn((Object)this.internalName);
        EXIT_CLINIT.visitMethod(cv);
        cv.visitLabel(catchEnd);
        cv.visitInsn(177);
        cv.visitTryCatchBlock(tryLabel, catchLabel, catchLabel, THROWABLE_TYPE.getInternalName());
        cv.visitMaxs(1, 1);
    }

    private CodeVisitor visitMethod(MethodNode method) {
        this.addSignature(method);
        int access = method.access & 0xFFFFFFEF;
        return AsmMockingbirdUtility.visitMethod(this.cw, method, access);
    }

    private void addSignature(MethodNode method) throws ClassFormatError {
        String sig = this.getKey(method);
        if (!this.signatures.add(sig)) {
            throw new ClassFormatError("Repetitive method name/signature: " + AsmMockingbirdUtility.replaceSlash(this.internalName) + "." + sig);
        }
    }

    private void copyMethod(final MethodNode method, final CodeVisitor cv) {
        method.accept(new ClassVisitor(){
            String className;

            public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
                ThreadAndSystemInOutErrSubstitution substitution = new ThreadAndSystemInOutErrSubstitution(this, byteCodeSubstitution, cv){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0, x1);
                    }

                    public void visitInsn(int opcode) {
                        if (opcode == 177 && 1.access$100(this.this$1).name.equals("<clinit>")) {
                            1.access$400(this.this$1).visitLdcInsn((Object)MockingbirdInstrumenter.access$300(1.access$200(this.this$1)));
                            AsmMockingbirdConstants.EXIT_CLINIT.visitMethod(1.access$400(this.this$1));
                        }
                        super.visitInsn(opcode);
                    }

                    public void visitMaxs(int maxStack, int maxLocals) {
                    }
                };
                substitution.setCut(MockingbirdInstrumenter.this.isCUT);
                substitution.setEnclosingClassName(this.className);
                substitution.setEnclosingMethodName(name);
                substitution.setEnclosingMethodDescriptor(desc);
                return substitution;
            }

            public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
                this.className = name;
            }

            public void visitInnerClass(String name, String outerName, String innerName, int access) {
            }

            public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
            }

            public void visitAttribute(Attribute attr) {
            }

            public void visitEnd() {
            }

            static /* synthetic */ MethodNode access$100(1 x0) {
                return x0.method;
            }

            static /* synthetic */ MockingbirdInstrumenter access$200(1 x0) {
                return x0.MockingbirdInstrumenter.this;
            }

            static /* synthetic */ CodeVisitor access$400(1 x0) {
                return x0.cv;
            }
        });
    }

    public static int averageIncreasePerMethod() {
        return totalCount == 0 ? 0 : totalSize / totalCount;
    }

    static /* synthetic */ String access$300(MockingbirdInstrumenter x0) {
        return x0.internalName;
    }
}

