/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.mockingbird.instrumenter;

import com.agitar.mockingbird.instrumenter.AsmMockingbirdUtility;
import java.lang.reflect.Modifier;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;

public final class MethodContainer {
    public final MethodNode method;
    public final Type returnType;
    public final boolean isStatic;
    public final boolean isVoid;
    public final Type[] paramTypes;
    public final int[] paramIndex;
    public final int localVarLengthForParams;
    public final boolean isSynthetic;
    public final boolean isPrivate;
    public final boolean isFinal;
    public final boolean isAbstract;
    public final boolean isSystemClass;
    private int maxLocals = Integer.MIN_VALUE;

    public MethodContainer(MethodNode method, boolean isSystemClass) {
        this.isSystemClass = isSystemClass;
        this.method = method;
        this.returnType = Type.getReturnType((String)method.desc);
        this.isAbstract = Modifier.isAbstract(method.access);
        this.isStatic = Modifier.isStatic(method.access);
        this.isPrivate = Modifier.isPrivate(method.access);
        this.isSynthetic = AsmMockingbirdUtility.isSynthetic(method.access);
        this.isFinal = Modifier.isFinal(method.access);
        this.isVoid = Type.VOID_TYPE.equals((Object)this.returnType);
        this.paramTypes = Type.getArgumentTypes((String)method.desc);
        this.paramIndex = new int[this.paramTypes.length];
        int len = this.isStatic ? 0 : 1;
        for (int i = 0; i < this.paramTypes.length; ++i) {
            Type type = this.paramTypes[i];
            this.paramIndex[i] = len;
            len += type.getSize();
        }
        this.localVarLengthForParams = len;
    }

    public MethodContainer(MethodNode method) {
        this(method, false);
    }

    public String getMethodKey() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.method.name);
        buffer.append(this.method.desc);
        return buffer.toString();
    }

    public int getMaxLocals() {
        if (this.maxLocals == Integer.MIN_VALUE) {
            if (Modifier.isNative(this.method.access) || this.isAbstract) {
                this.maxLocals = Modifier.isStatic(this.method.access) ? 0 : 1;
                for (int i = 0; i < this.paramTypes.length; ++i) {
                    this.maxLocals += this.paramTypes[i].getSize();
                }
            } else {
                this.maxLocals = this.method.maxLocals;
            }
        }
        return this.maxLocals;
    }
}

