/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.mockingbird.instrumenter;

import [Ljava.lang.Object;;
import com.agitar.common.asm.AsmUtil;
import com.agitar.common.asm.JUnit4Annotation;
import com.agitar.common.asm.NullCodeVisitor;
import com.agitar.common.asm.SerialIDInstrumenter;
import com.agitar.common.util.StringUtility;
import com.agitar.lib.mockingbird.Caller;
import com.agitar.lib.mockingbird.Value;
import com.agitar.mockingbird.instrumenter.AsmMockingbirdConstants;
import com.agitar.mockingbird.instrumenter.LocalVariables;
import com.agitar.mockingbird.instrumenter.MethodContainer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Constants;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TreeClassAdapter;

public abstract class AsmMockingbirdUtility
implements Constants,
AsmMockingbirdConstants {
    public static final Type JAVA_LANG_CLASS_TYPE = Type.getType((Class)Class.class);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String JDK_MOCKINGBIRD_PREFIX = "com.agitar.lib.mockingbird.";
    private static final AsmUtil.MethodDescription MOCKINGBIRD_CALLER_CHECK = new AsmUtil.MethodDescription(Caller.class, "check", new Class[]{String.class, Object.class, String.class, Object;.class}, Value.class);

    public static boolean instrumentableMethodFromJavaLangObject(MethodNode method) {
        String name = method.name;
        return "equals".equals(name) || "clone".equals(name) || "toString".equals(name);
    }

    public static boolean isJunit4TestMethod(MethodNode methodNode) {
        if (JUnit4Annotation.hasJunit4()) {
            Attribute attr = methodNode.attrs;
            while (attr != null) {
                if (JUnit4Annotation.isJUnit4Method((String)attr.toString())) {
                    return true;
                }
                attr = attr.next;
            }
        }
        return false;
    }

    public static boolean isSynthetic(int access) {
        return (access & 0x1000) > 0;
    }

    public static boolean isAnonymous(String className) {
        int idx = className.indexOf(36);
        while (idx >= 0 && idx < className.length() - 1) {
            if (Character.isDigit(className.charAt(idx + 1))) {
                return true;
            }
            idx = className.indexOf(36, idx + 1);
        }
        return false;
    }

    public static String replaceSlash(String name) {
        return name.replace('/', '.');
    }

    public static boolean isPrimitive(Type type) {
        switch (type.getDescriptor().charAt(0)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return true;
            }
        }
        return false;
    }

    static void push(CodeVisitor cv, int i) {
        if (i < 128) {
            cv.visitIntInsn(16, i);
        } else {
            cv.visitIntInsn(17, i);
        }
    }

    public static ClassNode getClassNode(ClassReader reader) {
        TreeClassAdapter tca = new TreeClassAdapter(new ClassVisitor(){

            public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
            }

            public void visitInnerClass(String name, String outerName, String innerName, int access) {
            }

            public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
            }

            public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
                return new NullCodeVisitor();
            }

            public void visitAttribute(Attribute attr) {
            }

            public void visitEnd() {
            }
        });
        AsmMockingbirdUtility.readerAccept(reader, (ClassVisitor)tca);
        return tca.classNode;
    }

    public static void readerAccept(ClassReader reader, ClassVisitor classVisitor) {
        SerialIDInstrumenter wrappedClassVisitor = new SerialIDInstrumenter();
        wrappedClassVisitor.setNext(classVisitor);
        reader.accept((ClassVisitor)wrappedClassVisitor, AsmUtil.getDefaultAttributes(), false);
    }

    public static CodeVisitor visitMethod(ClassWriter cw, MethodNode method) {
        return AsmMockingbirdUtility.visitMethod(cw, method, Integer.MIN_VALUE);
    }

    public static CodeVisitor visitMethod(ClassWriter cw, MethodNode method, int access) {
        if (access == Integer.MIN_VALUE) {
            access = method.access;
        }
        return cw.visitMethod(access, method.name, method.desc, AsmMockingbirdUtility.strings(method.exceptions), method.attrs);
    }

    public static void getClass(CodeVisitor cv, String className) {
        cv.visitLdcInsn((Object)className);
        GET_CLASS_FROM_INTERNAL_NAME.visitMethod(cv);
    }

    public static Label inRecordOrPlayback(CodeVisitor cv) {
        IS_IN_NORMAL_MODE.visitMethod(cv);
        Label dubLable = new Label();
        cv.visitJumpInsn(154, dubLable);
        return dubLable;
    }

    public static void invokeWrapper(CodeVisitor cv, Type type) {
        String sig = AsmMockingbirdUtility.isPrimitive(type) ? type.getDescriptor() : AsmUtil.JAVA_LANG_OBJECT_TYPE.getDescriptor();
        cv.visitMethodInsn(184, MOCKINGBIRD_UTILITY_CLASS_TYPE.getInternalName(), "wrap", "(" + sig + ")" + AsmUtil.JAVA_LANG_OBJECT_TYPE.getDescriptor());
    }

    public static int changeClassAccess(int classAccess) {
        int access = 1;
        if (Modifier.isStatic(classAccess)) {
            access += 8;
        }
        if (Modifier.isAbstract(classAccess)) {
            access += 1024;
        }
        if ((classAccess & 0x20) > 0) {
            access += 32;
        }
        return access;
    }

    private static void loadParams(CodeVisitor cv, boolean isStatic, Type[] paramTypes, LocalVariables indices) {
        AsmMockingbirdUtility.push(cv, paramTypes.length);
        cv.visitTypeInsn(189, AsmUtil.JAVA_LANG_OBJECT_TYPE.getInternalName());
        cv.visitVarInsn(58, indices.getParamArrayIndex());
        if (paramTypes.length > 0) {
            int paramIndex = isStatic ? 0 : 1;
            for (int i = 0; i < paramTypes.length; ++i) {
                Type type = paramTypes[i];
                cv.visitVarInsn(25, indices.getParamArrayIndex());
                AsmMockingbirdUtility.push(cv, i);
                cv.visitVarInsn(type.getOpcode(21), paramIndex);
                AsmMockingbirdUtility.invokeWrapper(cv, type);
                cv.visitInsn(83);
                paramIndex += type.getSize();
            }
        }
    }

    public static String[] strings(Collection exceptions) {
        if (exceptions == null || exceptions.size() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList list = new ArrayList();
        Iterator iter = exceptions.iterator();
        while (iter.hasNext()) {
            Object str = iter.next();
            if (str == null) continue;
            list.add(str);
        }
        return StringUtility.strings(list);
    }

    public static void mockingbirdCode(String internalClasslName, MethodNode method, CodeVisitor cv, boolean addInterceptor) {
        MethodContainer mc = new MethodContainer(method);
        LocalVariables indices = new LocalVariables(mc);
        AsmMockingbirdUtility.mockingbirdRecordPlayback(internalClasslName, cv, mc, indices);
        if (addInterceptor) {
            AsmMockingbirdUtility.interceptorCode(internalClasslName, cv, mc.isStatic, mc.method.name, mc.method.desc, indices);
        }
    }

    public static void interceptorCode(String internalClasslName, CodeVisitor cv, boolean isStatic, String methodName, String methodDesc, LocalVariables indices) {
        cv.visitLdcInsn((Object)internalClasslName);
        cv.visitLdcInsn((Object)methodName);
        cv.visitLdcInsn((Object)methodDesc);
        FIND_METHOD_INTERCEPTOR.visitMethod(cv);
        cv.visitVarInsn(58, indices.getInterceptorIndex());
        Label interceptorLable = new Label();
        cv.visitVarInsn(25, indices.getInterceptorIndex());
        cv.visitJumpInsn(198, interceptorLable);
        Label tryLabel = new Label();
        Label catchLabel = new Label();
        cv.visitLabel(tryLabel);
        AsmMockingbirdUtility.loadParams(cv, isStatic, Type.getArgumentTypes((String)methodDesc), indices);
        cv.visitVarInsn(25, indices.getInterceptorIndex());
        if (isStatic) {
            cv.visitInsn(1);
        } else {
            cv.visitVarInsn(25, 0);
        }
        cv.visitLdcInsn((Object)internalClasslName);
        cv.visitLdcInsn((Object)methodName);
        cv.visitLdcInsn((Object)methodDesc);
        cv.visitVarInsn(25, indices.getParamArrayIndex());
        AsmMockingbirdUtility.visitClassLoaderField(internalClasslName, cv);
        INTERCEPTOR_METHOD.visitMethod(cv);
        cv.visitVarInsn(58, indices.getReturnValueIndex());
        Label afterCatch = new Label();
        cv.visitJumpInsn(167, afterCatch);
        cv.visitLabel(catchLabel);
        AsmMockingbirdUtility.fillAndThrow(cv, indices);
        cv.visitTryCatchBlock(tryLabel, catchLabel, catchLabel, THROWABLE_TYPE.getInternalName());
        cv.visitLabel(afterCatch);
        AsmMockingbirdUtility.handleReturnValue(cv, Type.getReturnType((String)methodDesc), indices, interceptorLable);
        cv.visitLabel(interceptorLable);
    }

    public static void visitClassLoaderField(String internalClasslName, CodeVisitor cv) {
        cv.visitFieldInsn(178, internalClasslName, "$agitar_classloader", AsmUtil.JAVA_LANG_CLASS_LOADER_TYPE.getDescriptor());
    }

    private static void handleReturnValue(CodeVisitor cv, Type returnType, LocalVariables indices, Label interceptorLable) {
        cv.visitVarInsn(25, indices.getReturnValueIndex());
        cv.visitJumpInsn(198, interceptorLable);
        cv.visitVarInsn(25, indices.getReturnValueIndex());
        if (!Type.VOID_TYPE.equals((Object)returnType)) {
            AsmMockingbirdUtility.callReturnValueMethod(cv, returnType);
        }
        cv.visitInsn(returnType.getOpcode(172));
    }

    private static void mockingbirdRecordPlayback(String internalClasslName, CodeVisitor cv, MethodContainer mc, LocalVariables indices) {
        Label tryLabel = new Label();
        Label catchLabel = new Label();
        Label mockingbirdLabel = AsmMockingbirdUtility.inRecordOrPlayback(cv);
        AsmMockingbirdUtility.loadParams(cv, mc.isStatic, mc.paramTypes, indices);
        cv.visitLabel(tryLabel);
        if (mc.isStatic) {
            cv.visitLdcInsn((Object)internalClasslName);
            cv.visitInsn(1);
        } else {
            cv.visitInsn(1);
            cv.visitVarInsn(25, 0);
        }
        cv.visitLdcInsn((Object)mc.getMethodKey());
        cv.visitVarInsn(25, indices.getParamArrayIndex());
        MOCKINGBIRD_CALLER_CHECK.visitMethod(cv);
        cv.visitVarInsn(58, indices.getReturnValueIndex());
        Label afterCatch = new Label();
        cv.visitJumpInsn(167, afterCatch);
        cv.visitLabel(catchLabel);
        AsmMockingbirdUtility.fillAndThrow(cv, indices);
        cv.visitTryCatchBlock(tryLabel, catchLabel, catchLabel, THROWABLE_TYPE.getInternalName());
        cv.visitLabel(afterCatch);
        AsmMockingbirdUtility.handleReturnValue(cv, mc.returnType, indices, mockingbirdLabel);
        cv.visitLabel(mockingbirdLabel);
    }

    private static void fillAndThrow(CodeVisitor cv, LocalVariables indices) {
        cv.visitVarInsn(58, indices.getThrowableIndex());
        cv.visitVarInsn(25, indices.getThrowableIndex());
        FILL_STACK_TRACE.visitMethod(cv);
        cv.visitInsn(191);
    }

    private static void callReturnValueMethod(CodeVisitor cv, Type returnType) {
        String methodNamePrefix = "";
        String returnDescriptor = "";
        boolean isJavaLangObject = false;
        if (AsmMockingbirdUtility.isPrimitive(returnType)) {
            returnDescriptor = returnType.getDescriptor();
        } else {
            returnDescriptor = AsmUtil.JAVA_LANG_OBJECT_TYPE.getDescriptor();
            isJavaLangObject = true;
        }
        switch (returnType.getDescriptor().charAt(0)) {
            case 'Z': {
                methodNamePrefix = Boolean.TYPE.getName();
                break;
            }
            case 'B': {
                methodNamePrefix = Byte.TYPE.getName();
                break;
            }
            case 'C': {
                methodNamePrefix = Character.TYPE.getName();
                break;
            }
            case 'S': {
                methodNamePrefix = Short.TYPE.getName();
                break;
            }
            case 'I': {
                methodNamePrefix = Integer.TYPE.getName();
                break;
            }
            case 'J': {
                methodNamePrefix = Long.TYPE.getName();
                break;
            }
            case 'F': {
                methodNamePrefix = Float.TYPE.getName();
                break;
            }
            case 'D': {
                methodNamePrefix = Double.TYPE.getName();
                break;
            }
            default: {
                methodNamePrefix = "get";
            }
        }
        cv.visitMethodInsn(182, RETURN_VALUE_TYPE.getInternalName(), methodNamePrefix + "Value", "()" + returnDescriptor);
        if (isJavaLangObject) {
            if (returnType.getSort() == 9) {
                cv.visitTypeInsn(192, returnType.getDescriptor());
            } else {
                cv.visitTypeInsn(192, returnType.getClassName().replace('.', '/'));
            }
        }
    }

    public static void loadDefaultValue(CodeVisitor cv, Type type) {
        switch (type.getDescriptor().charAt(0)) {
            case 'V': {
                break;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                cv.visitInsn(3);
                break;
            }
            case 'J': {
                cv.visitInsn(9);
                break;
            }
            case 'F': {
                cv.visitInsn(11);
                break;
            }
            case 'D': {
                cv.visitInsn(14);
                break;
            }
            default: {
                cv.visitInsn(1);
            }
        }
    }

    static boolean isPackageFriendly(MethodNode method) {
        int access = method.access;
        return !Modifier.isPublic(access) && !Modifier.isProtected(access) && !Modifier.isPrivate(access);
    }

    public static ClassNode getClassNode(Class cls) throws IOException {
        return AsmMockingbirdUtility.getClassNodeWrapper((Class)cls).node;
    }

    public static ClassNodeWrapper getClassNodeWrapper(Class cls) throws IOException {
        ClassLoader classLoader = cls.getClassLoader();
        String fileName = AsmMockingbirdUtility.getClassFileName(cls);
        ClassNodeWrapper wrapper = AsmMockingbirdUtility.getClassNodeWrapper(classLoader, fileName);
        return wrapper;
    }

    static String getClassFileName(Class cls) {
        String fileName = cls.getName().replace('.', '/') + ".class";
        return fileName;
    }

    static ClassNodeWrapper getClassNodeWrapper(ClassLoader classLoader, String fileName) throws IOException {
        boolean isSystemClass = classLoader == null;
        ClassReader classReader = AsmMockingbirdUtility.getClassReader(classLoader, fileName);
        return new ClassNodeWrapper(AsmMockingbirdUtility.getClassNode(classReader), isSystemClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ClassReader getClassReader(ClassLoader classLoader, String fileName) throws IOException {
        InputStream is;
        InputStream inputStream = is = classLoader == null ? ClassLoader.getSystemResourceAsStream(fileName) : classLoader.getResourceAsStream(fileName);
        if (is == null) {
            throw new IOException("Cannot find " + fileName);
        }
        try {
            ClassReader classReader = new ClassReader((InputStream)new BufferedInputStream(is, 16384));
            return classReader;
        }
        finally {
            is.close();
        }
    }

    public static boolean isInJavaPackage(String className) {
        return className.startsWith("java/");
    }

    public static void write(byte[] bytes, File dir, String name) throws IOException {
        File file = new File(dir, name);
        file.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(bytes, 0, bytes.length);
        fos.close();
    }

    public static String getJDKMockClassName(Class cls) {
        return JDK_MOCKINGBIRD_PREFIX + cls.getName();
    }

    static void superMethodCall(ClassNode superNode, MethodContainer mc, CodeVisitor cv) {
        cv.visitVarInsn(25, 0);
        for (int i = 0; i < mc.paramTypes.length; ++i) {
            Type type = mc.paramTypes[i];
            cv.visitVarInsn(type.getOpcode(21), mc.paramIndex[i]);
        }
        cv.visitMethodInsn(183, superNode.name, mc.method.name, mc.method.desc);
    }

    private AsmMockingbirdUtility() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(String internalName, byte[] toByteArray, File bytecodeOutputDir) throws IOException {
        File classFile = new File(bytecodeOutputDir, internalName.replace('/', File.separatorChar) + ".class");
        classFile.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(classFile);
        try {
            fos.write(toByteArray);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static class ClassNodeWrapper {
        final boolean isSystemClass;
        public final ClassNode node;
        private MethodNode[] methods;

        private ClassNodeWrapper(ClassNode node, boolean isSystemClass) {
            this.isSystemClass = isSystemClass;
            this.node = node;
        }

        public MethodNode[] getMethods() {
            if (this.methods == null) {
                this.methods = this.node.methods.toArray(new MethodNode[0]);
            }
            return this.methods;
        }
    }
}

