/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.lib.mockingbird.tape;

import com.agitar.lib.mockingbird.Mockingbird;
import com.agitar.lib.mockingbird.MockingbirdError;
import com.agitar.lib.mockingbird.Utils;
import java.util.ArrayList;

class ValueList {
    public static final int MAX_END_OF_TAPE_COUNTER = 12;
    private final ArrayList list = new ArrayList();
    private boolean endOfTapeReached;
    private boolean lastRecordIsPersistent;
    private final String signature;
    private int endOfTapeCounter;
    private int numberOfRecording;

    ValueList(String signature) {
        this.signature = signature;
    }

    void add(Object value) {
        if (this.lastRecordIsPersistent) {
            throw new MockingbirdError("Cannot add more vales to tape with persistent record");
        }
        ++this.numberOfRecording;
        this.list.add(value);
    }

    void setLastRecordIsPersistent() {
        if (this.list.isEmpty()) {
            throw new MockingbirdError("There is no record to persist");
        }
        this.lastRecordIsPersistent = true;
    }

    Object get(boolean isInPeekMode) {
        if (this.list.size() == 0) {
            return null;
        }
        if (this.list.size() == 1 && Mockingbird.isInTestMode()) {
            if (isInPeekMode || this.lastRecordIsPersistent) {
                return this.list.get(0);
            }
            this.endOfTapeReached = true;
            return this.list.remove(0);
        }
        if (this.list.size() == 1) {
            if (this.endOfTapeCounter >= 12) {
                throw new MockingbirdError.NoRecordingInTapeError(Utils.getPrettySignature(this.signature));
            }
            if (!isInPeekMode && !this.lastRecordIsPersistent) {
                ++this.endOfTapeCounter;
            }
            return this.list.get(0);
        }
        if (isInPeekMode) {
            return this.list.get(0);
        }
        return this.list.remove(0);
    }

    MockingbirdError.LeftOverInTape leftOverInTape() {
        if (!this.endOfTapeReached) {
            return new MockingbirdError.LeftOverInTape(this.signature, this.numberOfRecording, this.numberOfRecording - this.list.size());
        }
        return null;
    }

    public boolean isLastRecordIsPersistent() {
        return this.lastRecordIsPersistent;
    }
}

