/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.lib.mockingbird.tape;

import com.agitar.lib.mockingbird.Mockingbird;
import com.agitar.lib.mockingbird.MockingbirdError;
import com.agitar.lib.mockingbird.MockingbirdSubclassProxyMarker;
import com.agitar.lib.mockingbird.Tape;
import com.agitar.lib.mockingbird.Utils;
import com.agitar.lib.mockingbird.Value;
import com.agitar.lib.mockingbird.tape.ExceptionHolder;
import com.agitar.lib.mockingbird.tape.MethodTapes;
import com.agitar.lib.mockingbird.tape.ParameterTapes;
import com.agitar.lib.mockingbird.tape.TapeForConstructor;
import java.util.IdentityHashMap;
import java.util.Map;

public final class TapeVault {
    private static final Object[] EMPTY_OBJECT_ARRAY;
    static final String TIMES_MUST_BE_GREATER_THAN_ZERO = "Times must be greater than zero";
    static final String EXCEPTION_CANNOT_BE_NULL = "Exception cannot be null";
    static final String MOCKINGBIRD_IS_NOT_IN_RECORDING_MODE = "Mockingbird is not in recording mode";
    private final ClassTapeMap classMap = new ClassTapeMap();
    private final ObjectTapeMap objectMap = new ObjectTapeMap();
    private final MethodTapeMap methodMap = new MethodTapeMap();
    private boolean targetIsSet;
    private boolean isStatic;
    private Object target;
    private String signature;
    private Object[] params;
    private Thread thread;
    private Class classUnderTest;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void clear() {
        this.classMap.clear();
        this.objectMap.clear();
        this.methodMap.clear();
        this.clearRecord();
        this.classUnderTest = null;
    }

    public void clearRecord() {
        this.targetIsSet = false;
        this.target = null;
        this.signature = null;
        this.params = null;
        this.thread = null;
    }

    void removeRecording(Object target) {
        this.objectMap.removeRecording(target);
    }

    void removeStaticRecording(Class target) {
        this.classMap.removeRecording(target);
    }

    public void checkTapeEndReached() {
        this.objectMap.checkTapeInMap();
        this.classMap.checkTapeInMap();
    }

    public boolean objectHasRecording(Object targetObject) {
        return this.objectMap.find(targetObject) != null;
    }

    public void setException(boolean ignoreParam, Throwable exception, int times) {
        this.checkRecordingMode(false);
        if (exception == null) {
            this.handleError(EXCEPTION_CANNOT_BE_NULL);
        }
        if (!Utils.isDeclaredException(exception, Utils.getExceptions(this.isStatic, this.target, this.signature))) {
            this.handleError(exception.getClass().getName() + " is not a declared exception of method: " + Utils.getPrettySignature(this.signature));
        }
        this.setValue(ignoreParam, new ExceptionHolder(exception), times);
    }

    public void setException(Class target2, String signature2, Throwable exception, int times) {
        this.targetIsSet = true;
        this.checkRecordingMode(false);
        if (times <= 0) {
            this.handleError(TIMES_MUST_BE_GREATER_THAN_ZERO);
        }
        if (exception == null) {
            this.handleError(EXCEPTION_CANNOT_BE_NULL);
        }
        if (!Utils.isDeclaredException(exception, Utils.getExceptions(this.isStatic, this.target, this.signature))) {
            this.handleError(exception.getClass().getName() + " is not a declared exception of method: " + Utils.getPrettySignature(this.signature));
        }
        TapeVault.record(this.signature, EMPTY_OBJECT_ARRAY, new ExceptionHolder(exception), times, this.methodMap, this.target);
    }

    public Object playback(boolean isStatic, Object target, String signature, Object[] params) {
        Object value;
        if (this.classUnderTest != null && target != null && (isStatic ? this.classUnderTest.equals(target) : this.classUnderTest.isInstance(target))) {
            this.classUnderTest = null;
            return Value.DO_ORIGINAL;
        }
        TapeMap tapeMap = isStatic ? this.classMap : this.objectMap;
        Tape tape = tapeMap.find(target);
        Object object = value = tape == null ? null : tape.playback(signature, params, Mockingbird.isInPeekMode());
        if (value == null) {
            tape = this.methodMap.find(isStatic ? target : (target == null ? null : target.getClass()));
            value = tape == null ? null : tape.playback(signature, params, Mockingbird.isInPeekMode());
        }
        return value;
    }

    public void dub(Object objectFromConstructor, TapeForConstructor.Value value, Object objectFromTape) {
        Tape tape = this.objectMap.find(objectFromTape);
        if (tape != null && value.getKeepOriginal() && objectFromConstructor != null) {
            this.objectMap.put(objectFromConstructor, tape);
            this.objectMap.removeRecording(objectFromTape);
        }
    }

    public void setReturnValue(boolean ignoreParam, Object value, int times) {
        this.checkRecordingMode(true);
        Utils.checkReturnValue(value, this.signature);
        this.setValue(ignoreParam, value, times);
    }

    public void setReturnValue(Class target, String signature, Object value, int times) {
        this.targetIsSet = true;
        this.checkRecordingMode(true);
        Utils.checkReturnValue(value, signature);
        if (times <= 0) {
            this.handleError(TIMES_MUST_BE_GREATER_THAN_ZERO);
        }
        TapeVault.record(signature, EMPTY_OBJECT_ARRAY, value, times, this.methodMap, target);
    }

    private void setValue(boolean ignoreParam, Object value, int times) {
        if (times <= 0) {
            this.handleError(TIMES_MUST_BE_GREATER_THAN_ZERO);
        }
        if (this.thread != Thread.currentThread()) {
            this.handleError("setValue is called from a different thread (recorded=" + this.thread + " this=" + Thread.currentThread());
        }
        MethodTapeMap tapeMap = ignoreParam ? this.methodMap : (this.isStatic ? this.classMap : this.objectMap);
        Object obj = this.getTarget(ignoreParam);
        this.record(value, times, tapeMap, obj);
        if (ignoreParam && !this.isStatic && MockingbirdSubclassProxyMarker.class.isAssignableFrom(this.target.getClass())) {
            this.record(value, times, tapeMap, this.target.getClass().getSuperclass());
        }
    }

    private Object getTarget(boolean ignoreParam) {
        if (ignoreParam) {
            if (this.isStatic || this.target instanceof Class) {
                return this.target;
            }
            return this.target.getClass();
        }
        return this.target;
    }

    private void record(Object value, int times, TapeMap tapeMap, Object obj) {
        TapeVault.record(this.signature, this.params, value, times, tapeMap, obj);
    }

    private static void record(String signature, Object[] params, Object value, int times, TapeMap tapeMap, Object obj) {
        Tape tape = tapeMap.create(obj);
        if (times >= 0x3FFFFFFF) {
            tape.record(signature, params, value == null ? Tape.NULL_OBJECT : value, true);
        } else {
            for (int i = 0; i < times; ++i) {
                tape.record(signature, params, value == null ? Tape.NULL_OBJECT : value, false);
            }
        }
    }

    private void checkRecordingMode(boolean isSetValue) throws MockingbirdError {
        if (!Mockingbird.isInRecordingMode()) {
            this.handleError(MOCKINGBIRD_IS_NOT_IN_RECORDING_MODE);
        }
        if (!this.targetIsSet) {
            this.handleError("No target recording method is set for '" + (isSetValue ? "setReturnValue" : "setException") + "'");
        }
    }

    private void handleError(String msg) throws MockingbirdError {
        this.clearRecord();
        throw new MockingbirdError(msg);
    }

    private static void checkTapeInMap(Map map) throws MockingbirdError.LeftOverInTape {
        Object[] objects = map.values().toArray();
        for (int i = 0; i < objects.length; ++i) {
            Tape tape = (Tape)objects[i];
            tape.checkTapeEndReached();
        }
    }

    public void setRecordForSetReturnValue(boolean isStatic, Object target, String signature, Object[] params) {
        if (!($assertionsDisabled || isStatic && target instanceof Class || target != null)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || signature != null && signature.length() > 0)) {
            throw new AssertionError();
        }
        Thread currentThread = Thread.currentThread();
        if (currentThread.getThreadGroup().getParent() == null) {
            return;
        }
        this.thread = currentThread;
        this.targetIsSet = true;
        this.isStatic = isStatic;
        this.target = target;
        this.signature = signature;
        this.params = params == null ? EMPTY_OBJECT_ARRAY : params;
    }

    public void setClassUnderTest(Class classUnderTest) {
        this.classUnderTest = classUnderTest;
    }

    static {
        $assertionsDisabled = !TapeVault.class.desiredAssertionStatus();
        EMPTY_OBJECT_ARRAY = new Object[0];
    }

    private static class ObjectTapeMap
    extends TapeMap {
        private final Map classToObjectMap = new IdentityHashMap();
        static final /* synthetic */ boolean $assertionsDisabled;

        private ObjectTapeMap() {
        }

        protected Map getMap() {
            return this.classToObjectMap;
        }

        protected Tape findTape(Object target) {
            Class<?> cls = target.getClass();
            IdentityHashMap map = (IdentityHashMap)this.classToObjectMap.get(cls);
            if (map == null || map.size() == 0) {
                return null;
            }
            return (Tape)map.get(target);
        }

        protected void removeRecordingFromTape(Object target) {
            Class<?> cls = target.getClass();
            IdentityHashMap map = (IdentityHashMap)this.classToObjectMap.get(cls);
            if (map == null || map.size() == 0) {
                return;
            }
            map.remove(target);
        }

        public Tape create(Object target) {
            if (!$assertionsDisabled && target == null) {
                throw new AssertionError();
            }
            IdentityHashMap map = this.getMap(target);
            Tape tape = (Tape)map.get(target);
            if (tape == null) {
                tape = new ParameterTapes();
                map.put(target, tape);
            }
            return tape;
        }

        private void put(Object target, Tape tape) {
            if (target != null) {
                IdentityHashMap map = this.getMap(target);
                map.put(target, tape);
            }
        }

        private IdentityHashMap getMap(Object target) {
            Class<?> cls = target.getClass();
            IdentityHashMap map = (IdentityHashMap)this.classToObjectMap.get(cls);
            if (map == null) {
                map = new IdentityHashMap();
                this.classToObjectMap.put(cls, map);
            }
            return map;
        }

        public void checkTapeInMap() throws MockingbirdError.LeftOverInTape {
            Object[] maps = this.classToObjectMap.values().toArray();
            for (int i = 0; i < maps.length; ++i) {
                Map map = (Map)maps[i];
                TapeVault.checkTapeInMap(map);
            }
        }

        protected Tape createNewTape() {
            throw new UnsupportedOperationException();
        }

        static {
            $assertionsDisabled = !(class$com$agitar$lib$mockingbird$tape$TapeVault == null ? (class$com$agitar$lib$mockingbird$tape$TapeVault = TapeVault.class$("com.agitar.lib.mockingbird.tape.TapeVault")) : class$com$agitar$lib$mockingbird$tape$TapeVault).desiredAssertionStatus();
        }
    }

    private static class MethodTapeMap
    extends TapeMap {
        private final IdentityHashMap map = new IdentityHashMap();

        private MethodTapeMap() {
        }

        protected Tape createNewTape() {
            return new MethodTapes();
        }

        protected Map getMap() {
            return this.map;
        }
    }

    private static class ClassTapeMap
    extends TapeMap {
        private final IdentityHashMap map = new IdentityHashMap();

        private ClassTapeMap() {
        }

        protected Tape createNewTape() {
            return new ParameterTapes();
        }

        protected Map getMap() {
            return this.map;
        }
    }

    private static abstract class TapeMap {
        private TapeMap() {
        }

        public Tape create(Object target) {
            Tape tape = this.find(target);
            if (tape == null) {
                tape = this.createNewTape();
                this.getMap().put(target, tape);
            }
            return tape;
        }

        protected abstract Tape createNewTape();

        public Tape find(Object target) {
            if (target == null || this.getMap() == null || this.getMap().size() == 0) {
                return null;
            }
            return this.findTape(target);
        }

        protected Tape findTape(Object target) {
            return (Tape)this.getMap().get(target);
        }

        public void clear() {
            if (this.getMap() != null) {
                this.getMap().clear();
            }
        }

        public void removeRecording(Object target) {
            if (target == null || this.getMap() == null || this.getMap().size() == 0) {
                return;
            }
            this.removeRecordingFromTape(target);
        }

        protected void removeRecordingFromTape(Object target) {
            this.getMap().remove(target);
        }

        public void checkTapeInMap() throws MockingbirdError.LeftOverInTape {
            if (this.getMap() != null) {
                TapeVault.checkTapeInMap(this.getMap());
            }
        }

        protected abstract Map getMap();
    }
}

